/*
 * Decompiled with CFR 0.152.
 */
package com.grookage.iosave.bundle;

import com.aerospike.client.IAerospikeClient;
import com.codahale.metrics.health.HealthCheck;
import com.grookage.iosave.as.client.AerospikeClient;
import com.grookage.iosave.as.config.IOSaveAerospikeConfig;
import com.grookage.iosave.as.repository.ASRequestRepository;
import com.grookage.iosave.as.utils.AerospikeClientUtils;
import com.grookage.iosave.bundle.InboundMessageFilter;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.setup.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IOSaveBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private static final Logger log = LoggerFactory.getLogger(IOSaveBundle.class);

    public abstract IOSaveAerospikeConfig getConfig(T var1);

    public abstract void preBundle(T var1);

    public void run(T configuration, Environment environment) {
        IOSaveAerospikeConfig aerospikeConfig = this.getConfig(configuration);
        IAerospikeClient iAeroClient = AerospikeClientUtils.provideIAerospikeClient((IOSaveAerospikeConfig)aerospikeConfig);
        AerospikeClient aeroClient = AerospikeClient.builder().client(iAeroClient).namespace(aerospikeConfig.getNamespace()).storeType(aerospikeConfig.getDefaultSet()).ttl(aerospikeConfig.getTtl()).mapper(environment.getObjectMapper()).build();
        final ASRequestRepository messageRepository = new ASRequestRepository(aeroClient);
        environment.jersey().register((Object)InboundMessageFilter.builder().messageRepository(messageRepository).mapper(environment.getObjectMapper()).build());
        environment.healthChecks().register("iosave-as-health", new HealthCheck(){

            protected HealthCheck.Result check() {
                return messageRepository.connected() ? HealthCheck.Result.healthy((String)"IOSave is healthy") : HealthCheck.Result.unhealthy((String)"IOSave is unhealthy");
            }
        });
    }
}

