/*
 * Decompiled with CFR 0.152.
 */
package org.dataloader;

import org.dataloader.BatchLoader;
import org.dataloader.BatchLoaderWithContext;
import org.dataloader.BatchPublisher;
import org.dataloader.BatchPublisherWithContext;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderOptions;
import org.dataloader.MappedBatchLoader;
import org.dataloader.MappedBatchLoaderWithContext;
import org.dataloader.MappedBatchPublisher;
import org.dataloader.MappedBatchPublisherWithContext;
import org.dataloader.Try;
import org.dataloader.annotations.PublicApi;

@PublicApi
public class DataLoaderFactory {
    public static <K, V> DataLoader<K, V> newDataLoader(BatchLoader<K, V> batchLoadFunction) {
        return DataLoaderFactory.newDataLoader(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newDataLoader(BatchLoader<K, V> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newDataLoaderWithTry(BatchLoader<K, Try<V>> batchLoadFunction) {
        return DataLoaderFactory.newDataLoaderWithTry(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newDataLoaderWithTry(BatchLoader<K, Try<V>> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newDataLoader(BatchLoaderWithContext<K, V> batchLoadFunction) {
        return DataLoaderFactory.newDataLoader(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newDataLoader(BatchLoaderWithContext<K, V> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newDataLoaderWithTry(BatchLoaderWithContext<K, Try<V>> batchLoadFunction) {
        return DataLoaderFactory.newDataLoaderWithTry(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newDataLoaderWithTry(BatchLoaderWithContext<K, Try<V>> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newMappedDataLoader(MappedBatchLoader<K, V> batchLoadFunction) {
        return DataLoaderFactory.newMappedDataLoader(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newMappedDataLoader(MappedBatchLoader<K, V> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newMappedDataLoaderWithTry(MappedBatchLoader<K, Try<V>> batchLoadFunction) {
        return DataLoaderFactory.newMappedDataLoaderWithTry(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newMappedDataLoaderWithTry(MappedBatchLoader<K, Try<V>> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newMappedDataLoader(MappedBatchLoaderWithContext<K, V> batchLoadFunction) {
        return DataLoaderFactory.newMappedDataLoader(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newMappedDataLoader(MappedBatchLoaderWithContext<K, V> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newMappedDataLoaderWithTry(MappedBatchLoaderWithContext<K, Try<V>> batchLoadFunction) {
        return DataLoaderFactory.newMappedDataLoaderWithTry(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newMappedDataLoaderWithTry(MappedBatchLoaderWithContext<K, Try<V>> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newPublisherDataLoader(BatchPublisher<K, V> batchLoadFunction) {
        return DataLoaderFactory.newPublisherDataLoader(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newPublisherDataLoader(BatchPublisher<K, V> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newPublisherDataLoaderWithTry(BatchPublisher<K, Try<V>> batchLoadFunction) {
        return DataLoaderFactory.newPublisherDataLoaderWithTry(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newPublisherDataLoaderWithTry(BatchPublisher<K, Try<V>> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newPublisherDataLoader(BatchPublisherWithContext<K, V> batchLoadFunction) {
        return DataLoaderFactory.newPublisherDataLoader(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newPublisherDataLoader(BatchPublisherWithContext<K, V> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newPublisherDataLoaderWithTry(BatchPublisherWithContext<K, Try<V>> batchLoadFunction) {
        return DataLoaderFactory.newPublisherDataLoaderWithTry(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newPublisherDataLoaderWithTry(BatchPublisherWithContext<K, Try<V>> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newMappedPublisherDataLoader(MappedBatchPublisher<K, V> batchLoadFunction) {
        return DataLoaderFactory.newMappedPublisherDataLoader(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newMappedPublisherDataLoader(MappedBatchPublisher<K, V> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newMappedPublisherDataLoaderWithTry(MappedBatchPublisher<K, Try<V>> batchLoadFunction) {
        return DataLoaderFactory.newMappedPublisherDataLoaderWithTry(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newMappedPublisherDataLoaderWithTry(MappedBatchPublisher<K, Try<V>> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newMappedPublisherDataLoader(MappedBatchPublisherWithContext<K, V> batchLoadFunction) {
        return DataLoaderFactory.newMappedPublisherDataLoader(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newMappedPublisherDataLoader(MappedBatchPublisherWithContext<K, V> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newMappedPublisherDataLoaderWithTry(MappedBatchPublisherWithContext<K, Try<V>> batchLoadFunction) {
        return DataLoaderFactory.newMappedPublisherDataLoaderWithTry(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newMappedPublisherDataLoaderWithTry(MappedBatchPublisherWithContext<K, Try<V>> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(batchLoadFunction, options);
    }

    static <K, V> DataLoader<K, V> mkDataLoader(Object batchLoadFunction, DataLoaderOptions options) {
        return new DataLoader(batchLoadFunction, options);
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static <K, V> Builder<K, V> builder(DataLoader<K, V> dataLoader) {
        return new Builder(dataLoader);
    }

    public static class Builder<K, V> {
        Object batchLoadFunction;
        DataLoaderOptions options = DataLoaderOptions.newOptions();

        Builder() {
        }

        Builder(DataLoader<?, ?> dataLoader) {
            this.batchLoadFunction = dataLoader.getBatchLoadFunction();
            this.options = dataLoader.getOptions();
        }

        public Builder<K, V> batchLoadFunction(Object batchLoadFunction) {
            this.batchLoadFunction = batchLoadFunction;
            return this;
        }

        public Builder<K, V> options(DataLoaderOptions options) {
            this.options = options;
            return this;
        }

        DataLoader<K, V> build() {
            return DataLoaderFactory.mkDataLoader(this.batchLoadFunction, this.options);
        }
    }
}

