/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalars.datetime;

import graphql.Internal;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.scalars.util.Kit;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.time.DateTimeException;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.function.Function;

@Internal
public class DateTimeScalar {
    public static GraphQLScalarType INSTANCE;

    static {
        Coercing<OffsetDateTime, String> coercing = new Coercing<OffsetDateTime, String>(){

            public String serialize(Object input) throws CoercingSerializeException {
                OffsetDateTime offsetDateTime;
                if (input instanceof OffsetDateTime) {
                    offsetDateTime = (OffsetDateTime)input;
                } else if (input instanceof ZonedDateTime) {
                    offsetDateTime = ((ZonedDateTime)input).toOffsetDateTime();
                } else if (input instanceof String) {
                    offsetDateTime = this.parseOffsetDateTime(input.toString(), CoercingSerializeException::new);
                } else {
                    throw new CoercingSerializeException("Expected something we can convert to 'java.time.OffsetDateTime' but was '" + Kit.typeName(input) + "'.");
                }
                try {
                    return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(offsetDateTime);
                }
                catch (DateTimeException e) {
                    throw new CoercingSerializeException("Unable to turn TemporalAccessor into OffsetDateTime because of : '" + e.getMessage() + "'.");
                }
            }

            public OffsetDateTime parseValue(Object input) throws CoercingParseValueException {
                OffsetDateTime offsetDateTime;
                if (input instanceof OffsetDateTime) {
                    offsetDateTime = (OffsetDateTime)input;
                } else if (input instanceof ZonedDateTime) {
                    offsetDateTime = ((ZonedDateTime)input).toOffsetDateTime();
                } else if (input instanceof String) {
                    offsetDateTime = this.parseOffsetDateTime(input.toString(), CoercingParseValueException::new);
                } else {
                    throw new CoercingParseValueException("Expected a 'String' but was '" + Kit.typeName(input) + "'.");
                }
                return offsetDateTime;
            }

            public OffsetDateTime parseLiteral(Object input) throws CoercingParseLiteralException {
                if (!(input instanceof StringValue)) {
                    throw new CoercingParseLiteralException("Expected AST type 'StringValue' but was '" + Kit.typeName(input) + "'.");
                }
                return this.parseOffsetDateTime(((StringValue)input).getValue(), CoercingParseLiteralException::new);
            }

            public Value<?> valueToLiteral(Object input) {
                String s = this.serialize(input);
                return StringValue.newStringValue((String)s).build();
            }

            private OffsetDateTime parseOffsetDateTime(String s, Function<String, RuntimeException> exceptionMaker) {
                try {
                    return OffsetDateTime.parse(s, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
                }
                catch (DateTimeParseException e) {
                    throw exceptionMaker.apply("Invalid RFC3339 value : '" + s + "'. because of : '" + e.getMessage() + "'");
                }
            }
        };
        INSTANCE = GraphQLScalarType.newScalar().name("DateTime").description("An RFC-3339 compliant DateTime Scalar").coercing((Coercing)coercing).build();
    }
}

