/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalars.datetime;

import graphql.GraphQLContext;
import graphql.Internal;
import graphql.execution.CoercedVariables;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.scalars.util.Kit;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.function.Function;

@Internal
public final class DateScalar {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final GraphQLScalarType INSTANCE;

    private DateScalar() {
    }

    static {
        Coercing<LocalDate, String> coercing = new Coercing<LocalDate, String>(){

            public String serialize(Object input, GraphQLContext graphQLContext, Locale locale) throws CoercingSerializeException {
                TemporalAccessor temporalAccessor;
                if (input instanceof TemporalAccessor) {
                    temporalAccessor = (TemporalAccessor)input;
                } else if (input instanceof String) {
                    temporalAccessor = this.parseLocalDate(input.toString(), CoercingSerializeException::new);
                } else {
                    throw new CoercingSerializeException("Expected a 'String' or 'java.time.temporal.TemporalAccessor' but was '" + Kit.typeName(input) + "'.");
                }
                try {
                    return DATE_FORMATTER.format(temporalAccessor);
                }
                catch (DateTimeException e) {
                    throw new CoercingSerializeException("Unable to turn TemporalAccessor into full date because of : '" + e.getMessage() + "'.");
                }
            }

            public LocalDate parseValue(Object input, GraphQLContext graphQLContext, Locale locale) throws CoercingParseValueException {
                TemporalAccessor temporalAccessor;
                if (input instanceof TemporalAccessor) {
                    temporalAccessor = (TemporalAccessor)input;
                } else if (input instanceof String) {
                    temporalAccessor = this.parseLocalDate(input.toString(), CoercingParseValueException::new);
                } else {
                    throw new CoercingParseValueException("Expected a 'String' or 'java.time.temporal.TemporalAccessor' but was '" + Kit.typeName(input) + "'.");
                }
                try {
                    return LocalDate.from(temporalAccessor);
                }
                catch (DateTimeException e) {
                    throw new CoercingParseValueException("Unable to turn TemporalAccessor into full date because of : '" + e.getMessage() + "'.");
                }
            }

            public LocalDate parseLiteral(Value<?> input, CoercedVariables variables, GraphQLContext graphQLContext, Locale locale) throws CoercingParseLiteralException {
                if (!(input instanceof StringValue)) {
                    throw new CoercingParseLiteralException("Expected AST type 'StringValue' but was '" + Kit.typeName(input) + "'.");
                }
                return this.parseLocalDate(((StringValue)input).getValue(), CoercingParseLiteralException::new);
            }

            public Value<?> valueToLiteral(Object input, GraphQLContext graphQLContext, Locale locale) {
                String s = this.serialize(input, graphQLContext, locale);
                return StringValue.newStringValue((String)s).build();
            }

            private LocalDate parseLocalDate(String s, Function<String, RuntimeException> exceptionMaker) {
                try {
                    TemporalAccessor temporalAccessor = DATE_FORMATTER.parse(s);
                    return LocalDate.from(temporalAccessor);
                }
                catch (DateTimeParseException e) {
                    throw exceptionMaker.apply("Invalid RFC3339 full date value : '" + s + "'. because of : '" + e.getMessage() + "'");
                }
            }
        };
        INSTANCE = GraphQLScalarType.newScalar().name("Date").description("An RFC-3339 compliant Full Date Scalar").coercing((Coercing)coercing).build();
    }
}

