/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalars.currency;

import graphql.GraphQLContext;
import graphql.Internal;
import graphql.execution.CoercedVariables;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.scalars.util.Kit;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.util.Currency;
import java.util.Locale;
import java.util.function.Function;

@Internal
public class CurrencyScalar {
    public static final GraphQLScalarType INSTANCE;

    static {
        Coercing<Currency, String> coercing = new Coercing<Currency, String>(){

            public String serialize(Object input, GraphQLContext graphQLContext, Locale locale) throws CoercingSerializeException {
                Currency currency = this.parseCurrency(input, CoercingSerializeException::new);
                return currency.getCurrencyCode();
            }

            public Currency parseValue(Object input, GraphQLContext graphQLContext, Locale locale) throws CoercingParseValueException {
                return this.parseCurrency(input, CoercingParseValueException::new);
            }

            public Currency parseLiteral(Value<?> input, CoercedVariables variables, GraphQLContext graphQLContext, Locale locale) throws CoercingParseLiteralException {
                if (!(input instanceof StringValue)) {
                    throw new CoercingParseLiteralException("Expected AST type 'StringValue' but was '" + Kit.typeName(input) + "'.");
                }
                String stringValue = ((StringValue)input).getValue();
                return this.parseCurrency(stringValue, CoercingParseLiteralException::new);
            }

            public Value<?> valueToLiteral(Object input, GraphQLContext graphQLContext, Locale locale) {
                String serializedInput = this.serialize(input, graphQLContext, locale);
                return StringValue.newStringValue((String)serializedInput).build();
            }

            private Currency parseCurrency(Object input, Function<String, RuntimeException> exceptionMaker) {
                Currency result;
                if (input instanceof Currency) {
                    result = (Currency)input;
                } else if (input instanceof String) {
                    try {
                        result = Currency.getInstance((String)input);
                    }
                    catch (IllegalArgumentException | NullPointerException ex) {
                        throw exceptionMaker.apply("Invalid ISO 4217 value : '" + String.valueOf(input) + "'. because of : '" + ex.getMessage() + "'");
                    }
                } else {
                    throw exceptionMaker.apply("Expected a 'String' or 'Currency' but was '" + Kit.typeName(input) + "'.");
                }
                return result;
            }
        };
        INSTANCE = GraphQLScalarType.newScalar().name("Currency").description("An ISO-4217 compliant Currency Scalar").coercing((Coercing)coercing).build();
    }
}

