/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalars.datetime;

import graphql.GraphQLContext;
import graphql.Internal;
import graphql.execution.CoercedVariables;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.scalars.util.Kit;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.time.DateTimeException;
import java.time.Year;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.function.Function;

@Internal
public final class YearScalar {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy");
    public static final GraphQLScalarType INSTANCE;

    private YearScalar() {
    }

    static {
        Coercing<Year, String> coercing = new Coercing<Year, String>(){

            public String serialize(Object input, GraphQLContext graphQLContext, Locale locale) throws CoercingSerializeException {
                TemporalAccessor temporalAccessor;
                if (input instanceof TemporalAccessor) {
                    temporalAccessor = (TemporalAccessor)input;
                } else if (input instanceof String) {
                    temporalAccessor = this.parseYear(input.toString(), CoercingSerializeException::new);
                } else {
                    throw new CoercingSerializeException("Expected a 'String' or 'java.time.temporal.TemporalAccessor' but was '" + Kit.typeName(input) + "'.");
                }
                try {
                    return DATE_FORMATTER.format(temporalAccessor);
                }
                catch (DateTimeException e) {
                    throw new CoercingSerializeException("Unable to turn TemporalAccessor into full year because of : '" + e.getMessage() + "'.");
                }
            }

            public Year parseValue(Object input, GraphQLContext graphQLContext, Locale locale) throws CoercingParseValueException {
                TemporalAccessor temporalAccessor;
                if (input instanceof TemporalAccessor) {
                    temporalAccessor = (TemporalAccessor)input;
                } else if (input instanceof String) {
                    temporalAccessor = this.parseYear(input.toString(), CoercingParseValueException::new);
                } else {
                    throw new CoercingParseValueException("Expected a 'String' or 'java.time.temporal.TemporalAccessor' but was '" + Kit.typeName(input) + "'.");
                }
                try {
                    return Year.from(temporalAccessor);
                }
                catch (DateTimeException e) {
                    throw new CoercingParseValueException("Unable to turn TemporalAccessor into full year because of : '" + e.getMessage() + "'.");
                }
            }

            public Year parseLiteral(Value<?> input, CoercedVariables variables, GraphQLContext graphQLContext, Locale locale) throws CoercingParseLiteralException {
                if (!(input instanceof StringValue)) {
                    throw new CoercingParseLiteralException("Expected AST type 'StringValue' but was '" + Kit.typeName(input) + "'.");
                }
                return this.parseYear(((StringValue)input).getValue(), CoercingParseLiteralException::new);
            }

            public Value<?> valueToLiteral(Object input, GraphQLContext graphQLContext, Locale locale) {
                String s = this.serialize(input, graphQLContext, locale);
                return StringValue.newStringValue((String)s).build();
            }

            private Year parseYear(String s, Function<String, RuntimeException> exceptionMaker) {
                try {
                    TemporalAccessor temporalAccessor = DATE_FORMATTER.parse(s);
                    return Year.from(temporalAccessor);
                }
                catch (DateTimeParseException e) {
                    throw exceptionMaker.apply("Invalid RFC3339 full year value : '" + s + "'. because of : '" + e.getMessage() + "'");
                }
            }
        };
        INSTANCE = GraphQLScalarType.newScalar().name("Year").description("An RFC-3339 compliant Full Year Scalar").coercing((Coercing)coercing).build();
    }
}

