/*
 * Decompiled with CFR 0.152.
 */
package graphql.agent;

import graphql.agent.DataFetchingEnvironmentAdvice;
import graphql.agent.DataLoaderLoadAdvice;
import graphql.agent.DataLoaderRegistryAdvice;
import graphql.agent.result.ExecutionTrackingResult;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.ResultPath;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatchers;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderRegistry;
import org.dataloader.DispatchResult;

public class GraphQLJavaAgent {
    public static final Map<ExecutionId, ExecutionTrackingResult> executionIdToData = new ConcurrentHashMap<ExecutionId, ExecutionTrackingResult>();
    public static final Map<DataLoader, ExecutionId> dataLoaderToExecutionId = new ConcurrentHashMap<DataLoader, ExecutionId>();

    public static void premain(String agentArgs, Instrumentation inst) {
        GraphQLJavaAgent.agentmain(agentArgs, inst);
    }

    public static void agentmain(String agentArgs, Instrumentation inst) {
        System.out.println("GraphQL Java Agent is starting");
        new AgentBuilder.Default().type(ElementMatchers.named("graphql.execution.Execution")).transform((builder, typeDescription, classLoader, module, protectionDomain) -> builder.visit(Advice.to(ExecutionAdvice.class).on(ElementMatchers.nameMatches("executeOperation")))).type(ElementMatchers.named("graphql.execution.ExecutionStrategy")).transform((builder, typeDescription, classLoader, module, protectionDomain) -> builder.visit(Advice.to(DataFetcherInvokeAdvice.class).on(ElementMatchers.nameMatches("invokeDataFetcher")))).type(ElementMatchers.named("org.dataloader.DataLoaderRegistry")).transform((builder, typeDescription, classLoader, module, protectionDomain) -> builder.visit(Advice.to(DataLoaderRegistryAdvice.class).on(ElementMatchers.nameMatches("dispatchAll")))).type(ElementMatchers.named("org.dataloader.DataLoader")).transform((builder, typeDescription, classLoader, module, protectionDomain) -> builder.visit(Advice.to(DataLoaderLoadAdvice.class).on(ElementMatchers.nameMatches("load")))).type(ElementMatchers.named("org.dataloader.DataLoaderHelper")).transform((builder, typeDescription, classLoader, module, protectionDomain) -> builder.visit(Advice.to(DataLoaderHelperDispatchAdvice.class).on(ElementMatchers.nameMatches("dispatch"))).visit(Advice.to(DataLoaderHelperInvokeBatchLoaderAdvice.class).on(ElementMatchers.nameMatches("invokeLoader").and(ElementMatchers.takesArguments(List.class, List.class, List.class))))).type(ElementMatchers.named("graphql.schema.DataFetchingEnvironmentImpl")).transform((builder, typeDescription, classLoader, module, protectionDomain) -> builder.visit(Advice.to(DataFetchingEnvironmentAdvice.class).on(ElementMatchers.nameMatches("getDataLoader")))).disableClassFormatChanges().installOn(inst);
    }

    public static DataLoader getDataLoaderForHelper(Object dataLoaderHelper) {
        try {
            Field field = dataLoaderHelper.getClass().getDeclaredField("dataLoader");
            field.setAccessible(true);
            return (DataLoader)field.get(dataLoaderHelper);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static class DataLoaderHelperDispatchAdvice {
        @Advice.OnMethodExit
        public static void dispatch(@Advice.This(typing=Assigner.Typing.DYNAMIC) Object dataLoaderHelper, @Advice.Return(typing=Assigner.Typing.DYNAMIC) DispatchResult dispatchResult) {
        }
    }

    public static class DataLoaderHelperInvokeBatchLoaderAdvice {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Advice.OnMethodEnter
        public static void invokeLoader(@Advice.Argument(value=0) List keys, @Advice.Argument(value=1) List keysContext, @Advice.Argument(value=2) List queuedFutures, @Advice.This(typing=Assigner.Typing.DYNAMIC) Object dataLoaderHelper) {
            DataLoader dataLoader = GraphQLJavaAgent.getDataLoaderForHelper(dataLoaderHelper);
            ExecutionId executionId = dataLoaderToExecutionId.get(dataLoader);
            ExecutionTrackingResult executionTrackingResult = executionIdToData.get(executionId);
            String dataLoaderName = (String)executionTrackingResult.dataLoaderToName.get(dataLoader);
            Map map = executionTrackingResult.dataLoaderNameToBatchCall;
            synchronized (map) {
                executionTrackingResult.dataLoaderNameToBatchCall.putIfAbsent(dataLoaderName, new ArrayList());
                ((List)executionTrackingResult.dataLoaderNameToBatchCall.get(dataLoaderName)).add(new ExecutionTrackingResult.BatchLoadingCall(keys.size(), Thread.currentThread().getName()));
            }
        }
    }

    public static class DataFetcherInvokeAdvice {
        @Advice.OnMethodEnter
        public static void invokeDataFetcherEnter(@Advice.Argument(value=0) ExecutionContext executionContext, @Advice.Argument(value=1) ExecutionStrategyParameters parameters) {
            ExecutionTrackingResult executionTrackingResult = executionIdToData.get(executionContext.getExecutionId());
            executionTrackingResult.start(parameters.getPath(), System.nanoTime());
            executionTrackingResult.startInvocationThreadPerPath.put(parameters.getPath(), Thread.currentThread().getName());
        }

        @Advice.OnMethodExit
        public static void invokeDataFetcherExit(@Advice.Argument(value=0) ExecutionContext executionContext, @Advice.Argument(value=1) ExecutionStrategyParameters parameters, @Advice.Return(readOnly=false) Object cfOrObject) {
            ExecutionTrackingResult executionTrackingResult = executionIdToData.get(executionContext.getExecutionId());
            ResultPath path = parameters.getPath();
            long startTime = (Long)executionTrackingResult.timePerPath.get(path);
            executionTrackingResult.end(path, System.nanoTime());
            if (cfOrObject instanceof CompletableFuture) {
                CompletableFuture result = (CompletableFuture)cfOrObject;
                if (result.isDone()) {
                    if (result.isCancelled()) {
                        executionTrackingResult.setDfResultTypes(path, ExecutionTrackingResult.DFResultType.DONE_CANCELLED);
                    } else if (result.isCompletedExceptionally()) {
                        executionTrackingResult.setDfResultTypes(path, ExecutionTrackingResult.DFResultType.DONE_EXCEPTIONALLY);
                    } else {
                        executionTrackingResult.setDfResultTypes(path, ExecutionTrackingResult.DFResultType.DONE_OK);
                    }
                } else {
                    executionTrackingResult.setDfResultTypes(path, ExecutionTrackingResult.DFResultType.PENDING);
                }
                cfOrObject = result.whenComplete((BiConsumer)new DataFetcherFinishedHandler(executionContext, parameters, startTime));
            } else {
                executionTrackingResult.setDfResultTypes(path, ExecutionTrackingResult.DFResultType.DONE_OK);
                new DataFetcherFinishedHandler(executionContext, parameters, startTime).accept(cfOrObject, null);
            }
        }

        public static class DataFetcherFinishedHandler
        implements BiConsumer<Object, Throwable> {
            private final ExecutionContext executionContext;
            private final ExecutionStrategyParameters parameters;
            private final long startTime;

            public DataFetcherFinishedHandler(ExecutionContext executionContext, ExecutionStrategyParameters parameters, long startTime) {
                this.executionContext = executionContext;
                this.parameters = parameters;
                this.startTime = startTime;
            }

            @Override
            public void accept(Object o, Throwable throwable) {
                ExecutionId executionId = this.executionContext.getExecutionId();
                ExecutionTrackingResult executionTrackingResult = executionIdToData.get(executionId);
                ResultPath path = this.parameters.getPath();
                executionTrackingResult.finishedTimePerPath.put(path, System.nanoTime() - this.startTime);
                executionTrackingResult.finishedThreadPerPath.put(path, Thread.currentThread().getName());
            }
        }
    }

    public static class ExecutionAdvice {
        @Advice.OnMethodEnter
        public static void executeOperationEnter(@Advice.Argument(value=0) ExecutionContext executionContext) {
            ExecutionTrackingResult executionTrackingResult = new ExecutionTrackingResult();
            executionTrackingResult.startExecutionTime.set(System.nanoTime());
            executionTrackingResult.startThread.set(Thread.currentThread().getName());
            executionContext.getGraphQLContext().put((Object)"__GJ_AGENT_EXECUTION_TRACKING", (Object)new ExecutionTrackingResult());
            executionIdToData.put(executionContext.getExecutionId(), executionTrackingResult);
            DataLoaderRegistry dataLoaderRegistry = executionContext.getDataLoaderRegistry();
            for (String name : dataLoaderRegistry.getDataLoadersMap().keySet()) {
                DataLoader dataLoader = dataLoaderRegistry.getDataLoader(name);
                dataLoaderToExecutionId.put(dataLoader, executionContext.getExecutionId());
                executionTrackingResult.dataLoaderToName.put(dataLoader, name);
            }
        }

        @Advice.OnMethodExit
        public static void executeOperationExit(@Advice.Argument(value=0) ExecutionContext executionContext, @Advice.Return(typing=Assigner.Typing.DYNAMIC) CompletableFuture<Object> result) {
            result.whenComplete((BiConsumer)new AfterExecutionHandler(executionContext));
        }

        public static class AfterExecutionHandler
        implements BiConsumer<Object, Throwable> {
            private final ExecutionContext executionContext;

            public AfterExecutionHandler(ExecutionContext executionContext) {
                this.executionContext = executionContext;
            }

            @Override
            public void accept(Object o, Throwable throwable) {
                ExecutionId executionId = this.executionContext.getExecutionId();
                ExecutionTrackingResult executionTrackingResult = executionIdToData.get(executionId);
                executionTrackingResult.endExecutionTime.set(System.nanoTime());
                executionTrackingResult.endThread.set(Thread.currentThread().getName());
                this.executionContext.getGraphQLContext().put((Object)"__GJ_AGENT_EXECUTION_TRACKING", (Object)executionTrackingResult);
                for (DataLoader dataLoader : executionTrackingResult.dataLoaderToName.keySet()) {
                    dataLoaderToExecutionId.remove(dataLoader);
                }
                executionIdToData.remove(executionId);
            }
        }
    }
}

