/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.servlet.core.internal;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.Part;

public class VariableMapper {
    private static final Pattern PERIOD = Pattern.compile("\\.");
    private static final Mapper<Map<String, Object>> MAP_MAPPER = new Mapper<Map<String, Object>>(){

        @Override
        public Object set(Map<String, Object> location, String target, Part value) {
            return location.put(target, value);
        }

        @Override
        public Object recurse(Map<String, Object> location, String target) {
            return location.get(target);
        }
    };
    private static final Mapper<List<Object>> LIST_MAPPER = new Mapper<List<Object>>(){

        @Override
        public Object set(List<Object> location, String target, Part value) {
            return location.set(Integer.parseInt(target), value);
        }

        @Override
        public Object recurse(List<Object> location, String target) {
            return location.get(Integer.parseInt(target));
        }
    };

    public static void mapVariable(String objectPath, Map<String, Object> variables, Part part) {
        String[] segments = PERIOD.split(objectPath);
        if (segments.length < 2) {
            throw new RuntimeException("object-path in map must have at least two segments");
        }
        if (!"variables".equals(segments[0])) {
            throw new RuntimeException("can only map into variables");
        }
        Object currentLocation = variables;
        for (int i = 1; i < segments.length; ++i) {
            String segmentName = segments[i];
            Mapper<?> mapper = VariableMapper.determineMapper(currentLocation, objectPath, segmentName);
            if (i == segments.length - 1) {
                if (null == mapper.set(currentLocation, segmentName, part)) continue;
                throw new RuntimeException("expected null value when mapping " + objectPath);
            }
            if (null != (currentLocation = mapper.recurse(currentLocation, segmentName))) continue;
            throw new RuntimeException("found null intermediate value when trying to map " + objectPath);
        }
    }

    private static Mapper<?> determineMapper(Object currentLocation, String objectPath, String segmentName) {
        if (currentLocation instanceof Map) {
            return MAP_MAPPER;
        }
        if (currentLocation instanceof List) {
            return LIST_MAPPER;
        }
        throw new RuntimeException("expected a map or list at " + segmentName + " when trying to map " + objectPath);
    }

    static interface Mapper<T> {
        public Object set(T var1, String var2, Part var3);

        public Object recurse(T var1, String var2);
    }
}

