/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet.subscriptions;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import javax.websocket.Session;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketSendSubscriber
implements Subscriber<String> {
    private static final Logger log = LoggerFactory.getLogger(WebSocketSendSubscriber.class);
    private final Session session;
    private AtomicReference<Subscription> subscriptionRef = new AtomicReference();

    public void onSubscribe(Subscription subscription) {
        this.subscriptionRef.set(subscription);
        this.subscriptionRef.get().request(1L);
    }

    public void onNext(String message) {
        this.subscriptionRef.get().request(1L);
        if (this.session.isOpen()) {
            try {
                this.session.getBasicRemote().sendText(message);
            }
            catch (IOException e) {
                log.error("Cannot send message {}", (Object)message, (Object)e);
            }
        }
    }

    public void onError(Throwable t) {
    }

    public void onComplete() {
        this.subscriptionRef.get().request(1L);
        if (this.session.isOpen()) {
            try {
                log.debug("Closing session");
                this.session.close();
            }
            catch (IOException e) {
                log.error("Cannot close session", (Throwable)e);
            }
        }
        this.subscriptionRef.get().cancel();
    }

    public WebSocketSendSubscriber(Session session) {
        this.session = session;
    }
}

