/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet.input;

import graphql.ExecutionInput;
import graphql.execution.ExecutionId;
import graphql.schema.GraphQLSchema;
import graphql.servlet.context.GraphQLContext;
import graphql.servlet.core.internal.GraphQLRequest;
import java.util.Optional;
import javax.security.auth.Subject;
import org.dataloader.DataLoaderRegistry;

public class GraphQLSingleInvocationInput {
    private final GraphQLSchema schema;
    private final ExecutionInput executionInput;
    private final Optional<Subject> subject;

    public GraphQLSingleInvocationInput(GraphQLRequest request, GraphQLSchema schema, GraphQLContext context, Object root) {
        this.schema = schema;
        this.executionInput = this.createExecutionInput(request, context, root);
        this.subject = context.getSubject();
    }

    public GraphQLSchema getSchema() {
        return this.schema;
    }

    public Optional<Subject> getSubject() {
        return this.subject;
    }

    private ExecutionInput createExecutionInput(GraphQLRequest graphQLRequest, GraphQLContext context, Object root) {
        return ExecutionInput.newExecutionInput().query(graphQLRequest.getQuery()).operationName(graphQLRequest.getOperationName()).context((Object)context).root(root).variables(graphQLRequest.getVariables()).dataLoaderRegistry(context.getDataLoaderRegistry().orElse(new DataLoaderRegistry())).executionId(ExecutionId.generate()).build();
    }

    public ExecutionInput getExecutionInput() {
        return this.executionInput;
    }
}

