/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet.core;

import graphql.ExceptionWhileDataFetching;
import graphql.GraphQLError;
import graphql.execution.NonNullableFieldWasNullError;
import graphql.servlet.core.GenericGraphQLError;
import graphql.servlet.core.GraphQLErrorHandler;
import graphql.servlet.core.RenderableNonNullableFieldWasNullError;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGraphQLErrorHandler
implements GraphQLErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultGraphQLErrorHandler.class);

    @Override
    public List<GraphQLError> processErrors(List<GraphQLError> errors) {
        List<GraphQLError> clientErrors = this.filterGraphQLErrors(errors);
        if (clientErrors.size() < errors.size()) {
            clientErrors.add(new GenericGraphQLError("Internal Server Error(s) while executing query"));
            errors.stream().filter(error -> !this.isClientError((GraphQLError)error)).forEach(this::logError);
        }
        return clientErrors;
    }

    protected void logError(GraphQLError error) {
        if (error instanceof Throwable) {
            log.error("Error executing query!", (Throwable)error);
        } else if (error instanceof ExceptionWhileDataFetching) {
            log.error("Error executing query {}", (Object)error.getMessage(), (Object)((ExceptionWhileDataFetching)error).getException());
        } else {
            log.error("Error executing query ({}): {}", (Object)error.getClass().getSimpleName(), (Object)error.getMessage());
        }
    }

    protected List<GraphQLError> filterGraphQLErrors(List<GraphQLError> errors) {
        return errors.stream().filter(this::isClientError).map(this::replaceNonNullableFieldWasNullError).collect(Collectors.toList());
    }

    protected boolean isClientError(GraphQLError error) {
        if (error instanceof ExceptionWhileDataFetching) {
            return ((ExceptionWhileDataFetching)error).getException() instanceof GraphQLError;
        }
        return true;
    }

    private GraphQLError replaceNonNullableFieldWasNullError(GraphQLError error) {
        if (error instanceof NonNullableFieldWasNullError) {
            return new RenderableNonNullableFieldWasNullError((NonNullableFieldWasNullError)error);
        }
        return error;
    }
}

