/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.servlet.BatchExecutionHandler;
import graphql.servlet.GraphQLBatchedInvocationInput;
import graphql.servlet.GraphQLInvocationInput;
import graphql.servlet.GraphQLObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.function.BiFunction;
import javax.servlet.http.HttpServletResponse;

public class DefaultBatchExecutionHandler
implements BatchExecutionHandler {
    @Override
    public void handleBatch(GraphQLBatchedInvocationInput batchedInvocationInput, HttpServletResponse response, GraphQLObjectMapper graphQLObjectMapper, BiFunction<GraphQLInvocationInput, ExecutionInput, ExecutionResult> queryFunction) {
        response.setContentType("application/json;charset=UTF-8");
        response.setStatus(200);
        try {
            PrintWriter writer = response.getWriter();
            Iterator<ExecutionInput> executionInputIterator = batchedInvocationInput.getExecutionInputs().iterator();
            ((Writer)writer).write("[");
            while (executionInputIterator.hasNext()) {
                ExecutionResult result = queryFunction.apply(batchedInvocationInput, executionInputIterator.next());
                ((Writer)writer).write(graphQLObjectMapper.serializeResultAsJson(result));
                if (!executionInputIterator.hasNext()) continue;
                ((Writer)writer).write(",");
            }
            ((Writer)writer).write("]");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

