/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet.internal;

import graphql.ExecutionResult;
import graphql.servlet.internal.WsSessionSubscriptions;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.websocket.Session;
import javax.websocket.server.HandshakeRequest;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SubscriptionProtocolHandler {
    private static final Logger log = LoggerFactory.getLogger(SubscriptionProtocolHandler.class);

    public abstract void onMessage(HandshakeRequest var1, Session var2, WsSessionSubscriptions var3, String var4) throws Exception;

    protected abstract void sendDataMessage(Session var1, String var2, Object var3);

    protected abstract void sendErrorMessage(Session var1, String var2);

    protected abstract void sendCompleteMessage(Session var1, String var2);

    protected void subscribe(final Session session, ExecutionResult executionResult, final WsSessionSubscriptions subscriptions, final String id) {
        Object data = executionResult.getData();
        if (data instanceof Publisher) {
            Publisher publisher = (Publisher)data;
            final AtomicSubscriptionReference subscriptionReference = new AtomicSubscriptionReference();
            publisher.subscribe((Subscriber)new Subscriber<ExecutionResult>(){

                public void onSubscribe(Subscription subscription) {
                    subscriptionReference.set(subscription);
                    subscriptionReference.get().request(1L);
                    subscriptions.add(id, subscriptionReference.get());
                }

                public void onNext(ExecutionResult executionResult) {
                    subscriptionReference.get().request(1L);
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    result.put("data", executionResult.getData());
                    SubscriptionProtocolHandler.this.sendDataMessage(session, id, result);
                }

                public void onError(Throwable throwable) {
                    log.error("Subscription error", throwable);
                    SubscriptionProtocolHandler.this.unsubscribe(subscriptions, id);
                    SubscriptionProtocolHandler.this.sendErrorMessage(session, id);
                }

                public void onComplete() {
                    SubscriptionProtocolHandler.this.unsubscribe(subscriptions, id);
                    SubscriptionProtocolHandler.this.sendCompleteMessage(session, id);
                }
            });
        }
    }

    protected void unsubscribe(WsSessionSubscriptions subscriptions, String id) {
        subscriptions.cancel(id);
    }

    static class AtomicSubscriptionReference {
        private final AtomicReference<Subscription> reference = new AtomicReference<Object>(null);

        AtomicSubscriptionReference() {
        }

        public void set(Subscription subscription) {
            if (this.reference.get() != null) {
                throw new IllegalStateException("Cannot overwrite subscription!");
            }
            this.reference.set(subscription);
        }

        public Subscription get() {
            Subscription subscription = this.reference.get();
            if (subscription == null) {
                throw new IllegalStateException("Subscription has not been initialized yet!");
            }
            return subscription;
        }
    }
}

