/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet.internal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import graphql.ExecutionResult;
import graphql.servlet.ApolloSubscriptionConnectionListener;
import graphql.servlet.GraphQLSingleInvocationInput;
import graphql.servlet.SubscriptionException;
import graphql.servlet.internal.ApolloSubscriptionKeepAliveRunner;
import graphql.servlet.internal.GraphQLRequest;
import graphql.servlet.internal.SubscriptionHandlerInput;
import graphql.servlet.internal.SubscriptionProtocolHandler;
import graphql.servlet.internal.SubscriptionSender;
import graphql.servlet.internal.WsSessionSubscriptions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.websocket.CloseReason;
import javax.websocket.Session;
import javax.websocket.server.HandshakeRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApolloSubscriptionProtocolHandler
extends SubscriptionProtocolHandler {
    private static final Logger log = LoggerFactory.getLogger(ApolloSubscriptionProtocolHandler.class);
    private static final CloseReason TERMINATE_CLOSE_REASON = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "client requested " + OperationMessage.Type.GQL_CONNECTION_TERMINATE.getType());
    private final SubscriptionHandlerInput input;
    private final SubscriptionSender sender;
    private final ApolloSubscriptionKeepAliveRunner keepAliveRunner;
    private final ApolloSubscriptionConnectionListener connectionListener;

    public ApolloSubscriptionProtocolHandler(SubscriptionHandlerInput subscriptionHandlerInput, ApolloSubscriptionConnectionListener connectionListener, SubscriptionSender subscriptionSender, ApolloSubscriptionKeepAliveRunner keepAliveRunner) {
        this.input = subscriptionHandlerInput;
        this.connectionListener = connectionListener;
        this.sender = subscriptionSender;
        this.keepAliveRunner = keepAliveRunner;
    }

    @Override
    public void onMessage(HandshakeRequest request, Session session, WsSessionSubscriptions subscriptions, String text) {
        OperationMessage message;
        try {
            message = (OperationMessage)this.input.getGraphQLObjectMapper().getJacksonMapper().readValue(text, OperationMessage.class);
        }
        catch (Throwable t) {
            log.warn("Error parsing message", t);
            this.sendMessage(session, OperationMessage.Type.GQL_CONNECTION_ERROR, null);
            return;
        }
        switch (message.getType()) {
            case GQL_CONNECTION_INIT: {
                try {
                    Optional<Object> connectionResponse = this.connectionListener.onConnect(message.getPayload());
                    connectionResponse.ifPresent(it -> session.getUserProperties().put("CONNECT_RESULT", it));
                }
                catch (SubscriptionException e) {
                    this.sendMessage(session, OperationMessage.Type.GQL_CONNECTION_ERROR, message.getId(), e.getPayload());
                    return;
                }
                this.sendMessage(session, OperationMessage.Type.GQL_CONNECTION_ACK, message.getId());
                if (!this.connectionListener.isKeepAliveEnabled()) break;
                this.keepAliveRunner.keepAlive(session);
                break;
            }
            case GQL_START: {
                GraphQLSingleInvocationInput graphQLSingleInvocationInput = this.createInvocationInput(session, message);
                this.handleSubscriptionStart(session, subscriptions, message.id, this.input.getQueryInvoker().query(graphQLSingleInvocationInput));
                break;
            }
            case GQL_STOP: {
                this.unsubscribe(subscriptions, message.id);
                break;
            }
            case GQL_CONNECTION_TERMINATE: {
                this.keepAliveRunner.abort(session);
                try {
                    session.close(TERMINATE_CLOSE_REASON);
                }
                catch (IOException e) {
                    log.error("Error closing websocket session!", (Throwable)e);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown message type: " + (Object)((Object)message.getType()));
            }
        }
    }

    private GraphQLSingleInvocationInput createInvocationInput(Session session, OperationMessage message) {
        GraphQLRequest graphQLRequest = (GraphQLRequest)this.input.getGraphQLObjectMapper().getJacksonMapper().convertValue(message.getPayload(), GraphQLRequest.class);
        HandshakeRequest handshakeRequest = (HandshakeRequest)session.getUserProperties().get(HandshakeRequest.class.getName());
        return this.input.getInvocationInputFactory().create(graphQLRequest, session, handshakeRequest);
    }

    private void handleSubscriptionStart(Session session, WsSessionSubscriptions subscriptions, String id, ExecutionResult executionResult) {
        executionResult = this.input.getGraphQLObjectMapper().sanitizeErrors(executionResult);
        if (this.input.getGraphQLObjectMapper().areErrorsPresent(executionResult)) {
            this.sendMessage(session, OperationMessage.Type.GQL_ERROR, id, this.input.getGraphQLObjectMapper().convertSanitizedExecutionResult(executionResult, false));
            return;
        }
        this.subscribe(session, executionResult, subscriptions, id);
    }

    @Override
    protected void sendDataMessage(Session session, String id, Object payload) {
        this.sendMessage(session, OperationMessage.Type.GQL_DATA, id, payload);
    }

    @Override
    protected void sendErrorMessage(Session session, String id) {
        this.keepAliveRunner.abort(session);
        this.sendMessage(session, OperationMessage.Type.GQL_ERROR, id);
    }

    @Override
    protected void sendCompleteMessage(Session session, String id) {
        this.keepAliveRunner.abort(session);
        this.sendMessage(session, OperationMessage.Type.GQL_COMPLETE, id);
    }

    private void sendMessage(Session session, OperationMessage.Type type, String id) {
        this.sendMessage(session, type, id, null);
    }

    private void sendMessage(Session session, OperationMessage.Type type, String id, Object payload) {
        this.sender.send(session, new OperationMessage(type, id, payload));
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class OperationMessage {
        private Type type;
        private String id;
        private Object payload;

        public OperationMessage() {
        }

        public OperationMessage(Type type, String id, Object payload) {
            this.type = type;
            this.id = id;
            this.payload = payload;
        }

        static OperationMessage newKeepAliveMessage() {
            return new OperationMessage(Type.GQL_CONNECTION_KEEP_ALIVE, null, null);
        }

        public Type getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public Object getPayload() {
            return this.payload;
        }

        public static enum Type {
            GQL_CONNECTION_ACK("connection_ack"),
            GQL_CONNECTION_ERROR("connection_error"),
            GQL_CONNECTION_KEEP_ALIVE("ka"),
            GQL_DATA("data"),
            GQL_ERROR("error"),
            GQL_COMPLETE("complete"),
            GQL_CONNECTION_INIT("connection_init"),
            GQL_CONNECTION_TERMINATE("connection_terminate"),
            GQL_START("start"),
            GQL_STOP("stop");

            private static final Map<String, Type> reverseLookup;
            private final String type;

            private Type(String type) {
                this.type = type;
            }

            @JsonCreator
            public static Type findType(String type) {
                return reverseLookup.get(type);
            }

            @JsonValue
            public String getType() {
                return this.type;
            }

            static {
                reverseLookup = new HashMap<String, Type>();
                for (Type type : Type.values()) {
                    reverseLookup.put(type.getType(), type);
                }
            }
        }
    }
}

