/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import javax.websocket.Session;
import javax.websocket.server.HandshakeRequest;
import org.dataloader.DataLoaderRegistry;

public class GraphQLContext {
    private HttpServletRequest httpServletRequest;
    private HttpServletResponse httpServletResponse;
    private Session session;
    private HandshakeRequest handshakeRequest;
    private Subject subject;
    private Map<String, List<Part>> parts;
    private DataLoaderRegistry dataLoaderRegistry;

    public GraphQLContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Session session, HandshakeRequest handshakeRequest, Subject subject) {
        this.httpServletRequest = httpServletRequest;
        this.httpServletResponse = httpServletResponse;
        this.session = session;
        this.handshakeRequest = handshakeRequest;
        this.subject = subject;
    }

    public GraphQLContext(HttpServletRequest httpServletRequest) {
        this(httpServletRequest, null);
    }

    public GraphQLContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this(httpServletRequest, httpServletResponse, null, null, null);
    }

    public GraphQLContext(Session session, HandshakeRequest handshakeRequest) {
        this(null, null, session, handshakeRequest, null);
    }

    public GraphQLContext() {
        this(null, null, null, null, null);
    }

    public Optional<HttpServletRequest> getHttpServletRequest() {
        return Optional.ofNullable(this.httpServletRequest);
    }

    public Optional<HttpServletResponse> getHttpServletResponse() {
        return Optional.ofNullable(this.httpServletResponse);
    }

    public Optional<Subject> getSubject() {
        return Optional.ofNullable(this.subject);
    }

    public Optional<Session> getSession() {
        return Optional.ofNullable(this.session);
    }

    public Optional<Object> getConnectResult() {
        if (this.session != null) {
            return Optional.ofNullable(this.session.getUserProperties().get("CONNECT_RESULT"));
        }
        return Optional.empty();
    }

    public Optional<HandshakeRequest> getHandshakeRequest() {
        return Optional.ofNullable(this.handshakeRequest);
    }

    public List<Part> getFileParts() {
        return this.getParts().values().stream().flatMap(Collection::stream).filter(part -> part.getContentType() != null).collect(Collectors.toList());
    }

    @Deprecated
    public Optional<Map<String, List<Part>>> getFiles() {
        return Optional.ofNullable(this.parts);
    }

    public Map<String, List<Part>> getParts() {
        return this.parts != null ? this.parts : new HashMap<String, List<Part>>();
    }

    public void setParts(Map<String, List<Part>> parts) {
        this.parts = parts;
    }

    public Optional<DataLoaderRegistry> getDataLoaderRegistry() {
        return Optional.ofNullable(this.dataLoaderRegistry);
    }

    public void setDataLoaderRegistry(DataLoaderRegistry dataLoaderRegistry) {
        this.dataLoaderRegistry = dataLoaderRegistry;
    }
}

