/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.servlet;

import graphql.Scalars;
import graphql.execution.preparsed.NoOpPreparsedDocumentProvider;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.kickstart.execution.GraphQLObjectMapper;
import graphql.kickstart.execution.GraphQLQueryInvoker;
import graphql.kickstart.execution.config.DefaultExecutionStrategyProvider;
import graphql.kickstart.execution.config.ExecutionStrategyProvider;
import graphql.kickstart.execution.config.InstrumentationProvider;
import graphql.kickstart.execution.error.DefaultGraphQLErrorHandler;
import graphql.kickstart.execution.error.GraphQLErrorHandler;
import graphql.kickstart.execution.instrumentation.NoOpInstrumentationProvider;
import graphql.kickstart.servlet.GraphQLConfiguration;
import graphql.kickstart.servlet.config.DefaultGraphQLSchemaServletProvider;
import graphql.kickstart.servlet.config.GraphQLSchemaServletProvider;
import graphql.kickstart.servlet.context.DefaultGraphQLServletContextBuilder;
import graphql.kickstart.servlet.context.GraphQLServletContextBuilder;
import graphql.kickstart.servlet.core.DefaultGraphQLRootObjectBuilder;
import graphql.kickstart.servlet.core.GraphQLServletListener;
import graphql.kickstart.servlet.core.GraphQLServletRootObjectBuilder;
import graphql.kickstart.servlet.input.GraphQLInvocationInputFactory;
import graphql.kickstart.servlet.osgi.GraphQLCodeRegistryProvider;
import graphql.kickstart.servlet.osgi.GraphQLDirectiveProvider;
import graphql.kickstart.servlet.osgi.GraphQLFieldProvider;
import graphql.kickstart.servlet.osgi.GraphQLMutationProvider;
import graphql.kickstart.servlet.osgi.GraphQLQueryProvider;
import graphql.kickstart.servlet.osgi.GraphQLSubscriptionProvider;
import graphql.kickstart.servlet.osgi.GraphQLTypesProvider;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;

class OsgiSchemaBuilder {
    private final List<GraphQLQueryProvider> queryProviders = new ArrayList<GraphQLQueryProvider>();
    private final List<GraphQLMutationProvider> mutationProviders = new ArrayList<GraphQLMutationProvider>();
    private final List<GraphQLSubscriptionProvider> subscriptionProviders = new ArrayList<GraphQLSubscriptionProvider>();
    private final List<GraphQLTypesProvider> typesProviders = new ArrayList<GraphQLTypesProvider>();
    private final List<GraphQLDirectiveProvider> directiveProviders = new ArrayList<GraphQLDirectiveProvider>();
    private final List<GraphQLServletListener> listeners = new ArrayList<GraphQLServletListener>();
    private GraphQLServletContextBuilder contextBuilder = new DefaultGraphQLServletContextBuilder();
    private GraphQLServletRootObjectBuilder rootObjectBuilder = new DefaultGraphQLRootObjectBuilder();
    private ExecutionStrategyProvider executionStrategyProvider = new DefaultExecutionStrategyProvider();
    private InstrumentationProvider instrumentationProvider = new NoOpInstrumentationProvider();
    private GraphQLErrorHandler errorHandler = new DefaultGraphQLErrorHandler();
    private PreparsedDocumentProvider preparsedDocumentProvider = NoOpPreparsedDocumentProvider.INSTANCE;
    private GraphQLCodeRegistryProvider codeRegistryProvider = () -> GraphQLCodeRegistry.newCodeRegistry().build();
    private GraphQLSchemaServletProvider schemaProvider;
    private ScheduledExecutorService executor;
    private ScheduledFuture<?> updateFuture;
    private int schemaUpdateDelay;

    OsgiSchemaBuilder() {
    }

    void activate(int schemaUpdateDelay) {
        this.schemaUpdateDelay = schemaUpdateDelay;
        if (schemaUpdateDelay != 0) {
            this.executor = Executors.newSingleThreadScheduledExecutor();
        }
    }

    void deactivate() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    void updateSchema() {
        if (this.schemaUpdateDelay == 0) {
            this.doUpdateSchema();
        } else {
            if (this.updateFuture != null) {
                this.updateFuture.cancel(true);
            }
            this.updateFuture = this.executor.schedule(this::doUpdateSchema, (long)this.schemaUpdateDelay, TimeUnit.MILLISECONDS);
        }
    }

    private void doUpdateSchema() {
        this.schemaProvider = new DefaultGraphQLSchemaServletProvider(GraphQLSchema.newSchema().query(this.buildQueryType()).mutation(this.buildMutationType()).subscription(this.buildSubscriptionType()).additionalTypes(this.buildTypes()).additionalDirectives(this.buildDirectives()).codeRegistry(this.codeRegistryProvider.getCodeRegistry()).build());
    }

    private GraphQLObjectType buildQueryType() {
        GraphQLObjectType.Builder queryTypeBuilder = GraphQLObjectType.newObject().name("Query").description("Root query type");
        if (!this.queryProviders.isEmpty()) {
            for (GraphQLQueryProvider provider : this.queryProviders) {
                if (provider.getQueries() == null || provider.getQueries().isEmpty()) continue;
                provider.getQueries().forEach(arg_0 -> ((GraphQLObjectType.Builder)queryTypeBuilder).field(arg_0));
            }
        } else {
            queryTypeBuilder.field(GraphQLFieldDefinition.newFieldDefinition().name("_empty").type((GraphQLOutputType)Scalars.GraphQLBoolean).build());
        }
        return queryTypeBuilder.build();
    }

    private Set<GraphQLType> buildTypes() {
        return this.typesProviders.stream().map(GraphQLTypesProvider::getTypes).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private GraphQLObjectType buildMutationType() {
        return this.buildObjectType("Mutation", new ArrayList<GraphQLFieldProvider>(this.mutationProviders));
    }

    private GraphQLObjectType buildSubscriptionType() {
        return this.buildObjectType("Subscription", new ArrayList<GraphQLFieldProvider>(this.subscriptionProviders));
    }

    private GraphQLObjectType buildObjectType(String name, List<GraphQLFieldProvider> providers) {
        if (!providers.isEmpty()) {
            GraphQLObjectType.Builder typeBuilder = GraphQLObjectType.newObject().name(name).description("Root " + name.toLowerCase() + " type");
            for (GraphQLFieldProvider provider : providers) {
                provider.getFields().forEach(arg_0 -> ((GraphQLObjectType.Builder)typeBuilder).field(arg_0));
            }
            if (!typeBuilder.build().getFieldDefinitions().isEmpty()) {
                return typeBuilder.build();
            }
        }
        return null;
    }

    private Set<GraphQLDirective> buildDirectives() {
        return this.directiveProviders.stream().map(GraphQLDirectiveProvider::getDirectives).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    void add(GraphQLQueryProvider provider) {
        this.queryProviders.add(provider);
    }

    void add(GraphQLMutationProvider provider) {
        this.mutationProviders.add(provider);
    }

    void add(GraphQLSubscriptionProvider provider) {
        this.subscriptionProviders.add(provider);
    }

    void add(GraphQLTypesProvider provider) {
        this.typesProviders.add(provider);
    }

    void add(GraphQLDirectiveProvider provider) {
        this.directiveProviders.add(provider);
    }

    void remove(GraphQLQueryProvider provider) {
        this.queryProviders.remove(provider);
    }

    void remove(GraphQLMutationProvider provider) {
        this.mutationProviders.remove(provider);
    }

    void remove(GraphQLSubscriptionProvider provider) {
        this.subscriptionProviders.remove(provider);
    }

    void remove(GraphQLTypesProvider provider) {
        this.typesProviders.remove(provider);
    }

    void remove(GraphQLDirectiveProvider provider) {
        this.directiveProviders.remove(provider);
    }

    GraphQLSchemaServletProvider getSchemaProvider() {
        return this.schemaProvider;
    }

    GraphQLConfiguration buildConfiguration() {
        return GraphQLConfiguration.with(this.buildInvocationInputFactory()).with(this.buildQueryInvoker()).with(this.buildObjectMapper()).with(this.listeners).build();
    }

    private GraphQLInvocationInputFactory buildInvocationInputFactory() {
        return GraphQLInvocationInputFactory.newBuilder(this::getSchemaProvider).withGraphQLContextBuilder(this.contextBuilder).withGraphQLRootObjectBuilder(this.rootObjectBuilder).build();
    }

    private GraphQLQueryInvoker buildQueryInvoker() {
        return GraphQLQueryInvoker.newBuilder().withPreparsedDocumentProvider(this.preparsedDocumentProvider).withInstrumentation(() -> this.instrumentationProvider.getInstrumentation()).withExecutionStrategyProvider(this.executionStrategyProvider).build();
    }

    private GraphQLObjectMapper buildObjectMapper() {
        return GraphQLObjectMapper.newBuilder().withGraphQLErrorHandler(this.errorHandler).build();
    }

    void add(GraphQLServletListener listener) {
        this.listeners.add(listener);
    }

    void remove(GraphQLServletListener listener) {
        this.listeners.remove(listener);
    }

    @Generated
    public void setContextBuilder(GraphQLServletContextBuilder contextBuilder) {
        this.contextBuilder = contextBuilder;
    }

    @Generated
    public void setRootObjectBuilder(GraphQLServletRootObjectBuilder rootObjectBuilder) {
        this.rootObjectBuilder = rootObjectBuilder;
    }

    @Generated
    public void setExecutionStrategyProvider(ExecutionStrategyProvider executionStrategyProvider) {
        this.executionStrategyProvider = executionStrategyProvider;
    }

    @Generated
    public void setInstrumentationProvider(InstrumentationProvider instrumentationProvider) {
        this.instrumentationProvider = instrumentationProvider;
    }

    @Generated
    public void setErrorHandler(GraphQLErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Generated
    public void setPreparsedDocumentProvider(PreparsedDocumentProvider preparsedDocumentProvider) {
        this.preparsedDocumentProvider = preparsedDocumentProvider;
    }

    @Generated
    public void setCodeRegistryProvider(GraphQLCodeRegistryProvider codeRegistryProvider) {
        this.codeRegistryProvider = codeRegistryProvider;
    }

    @Generated
    public void setSchemaProvider(GraphQLSchemaServletProvider schemaProvider) {
        this.schemaProvider = schemaProvider;
    }

    @Generated
    public void setExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    @Generated
    public void setUpdateFuture(ScheduledFuture<?> updateFuture) {
        this.updateFuture = updateFuture;
    }

    @Generated
    public void setSchemaUpdateDelay(int schemaUpdateDelay) {
        this.schemaUpdateDelay = schemaUpdateDelay;
    }
}

