/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.distance;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.index.strtree.ItemBoundable;
import org.locationtech.jts.index.strtree.ItemDistance;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.operation.distance.FacetSequence;
import org.locationtech.jts.operation.distance.FacetSequenceTreeBuilder;

public class IndexedFacetDistance {
    private STRtree cachedTree;

    public static double distance(Geometry g1, Geometry g2) {
        IndexedFacetDistance dist = new IndexedFacetDistance(g1);
        return dist.getDistance(g2);
    }

    public IndexedFacetDistance(Geometry g1) {
        this.cachedTree = FacetSequenceTreeBuilder.build(g1);
    }

    public double getDistance(Geometry g2) {
        STRtree tree2 = FacetSequenceTreeBuilder.build(g2);
        Object[] obj = this.cachedTree.nearestNeighbour(tree2, new FacetSequenceDistance());
        return IndexedFacetDistance.facetDistance(obj);
    }

    private static double facetDistance(Object[] obj) {
        Object o1 = obj[0];
        Object o2 = obj[1];
        return ((FacetSequence)o1).distance((FacetSequence)o2);
    }

    private static class FacetSequenceDistance
    implements ItemDistance {
        private FacetSequenceDistance() {
        }

        @Override
        public double distance(ItemBoundable item1, ItemBoundable item2) {
            FacetSequence fs1 = (FacetSequence)item1.getItem();
            FacetSequence fs2 = (FacetSequence)item2.getItem();
            return fs1.distance(fs2);
        }
    }
}

