/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage.index;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.geohash.SpatialKeyAlgo;
import com.graphhopper.storage.index.PixelGridTraversal;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.shapes.BBox;
import java.util.Arrays;

public class IndexStructureInfo {
    private final int[] entries;
    private final byte[] shifts;
    private final PixelGridTraversal pixelGridTraversal;
    private final SpatialKeyAlgo keyAlgo;
    private final BBox bounds;
    private final int parts;

    public IndexStructureInfo(int[] entries, byte[] shifts, PixelGridTraversal pixelGridTraversal, SpatialKeyAlgo keyAlgo, BBox bounds, int parts) {
        this.entries = entries;
        this.shifts = shifts;
        this.pixelGridTraversal = pixelGridTraversal;
        this.keyAlgo = keyAlgo;
        this.bounds = bounds;
        this.parts = parts;
    }

    public static IndexStructureInfo create(BBox bounds, int minResolutionInMeter) {
        double lat = Math.min(Math.abs(bounds.maxLat), Math.abs(bounds.minLat));
        double maxDistInMeter = Math.max((bounds.maxLat - bounds.minLat) / 360.0 * 4.003017359204114E7, (bounds.maxLon - bounds.minLon) / 360.0 * DistanceCalcEarth.DIST_EARTH.calcCircumference(lat));
        double tmp = maxDistInMeter / (double)minResolutionInMeter;
        tmp *= tmp;
        IntArrayList tmpEntries = new IntArrayList();
        tmp /= 4.0;
        while (tmp > 1.0) {
            int tmpNo;
            if (tmp >= 16.0) {
                tmpNo = 16;
            } else {
                if (!(tmp >= 4.0)) break;
                tmpNo = 4;
            }
            tmpEntries.add(tmpNo);
            tmp /= (double)tmpNo;
        }
        tmpEntries.add(4);
        int[] entries = tmpEntries.toArray();
        if (entries.length < 1) {
            throw new IllegalStateException("depth needs to be at least 1");
        }
        int depth = entries.length;
        byte[] shifts = new byte[depth];
        int lastEntry = entries[0];
        for (int i1 = 0; i1 < depth; ++i1) {
            if (lastEntry < entries[i1]) {
                throw new IllegalStateException("entries should decrease or stay but was:" + Arrays.toString(entries));
            }
            lastEntry = entries[i1];
            shifts[i1] = IndexStructureInfo.getShift(entries[i1]);
        }
        int shiftSum = 0;
        long parts = 1L;
        for (int i = 0; i < shifts.length; ++i) {
            shiftSum += shifts[i];
            parts *= (long)entries[i];
        }
        if (shiftSum > 64) {
            throw new IllegalStateException("sum of all shifts does not fit into a long variable");
        }
        parts = (int)Math.round(Math.sqrt(parts));
        return new IndexStructureInfo(entries, shifts, new PixelGridTraversal((int)parts, bounds), new SpatialKeyAlgo(shiftSum, bounds), bounds, (int)parts);
    }

    private static byte getShift(int entries) {
        byte b = (byte)Math.round(Math.log(entries) / Math.log(2.0));
        if (b <= 0) {
            throw new IllegalStateException("invalid shift:" + b);
        }
        return b;
    }

    public int[] getEntries() {
        return this.entries;
    }

    public byte[] getShifts() {
        return this.shifts;
    }

    public PixelGridTraversal getPixelGridTraversal() {
        return this.pixelGridTraversal;
    }

    public SpatialKeyAlgo getKeyAlgo() {
        return this.keyAlgo;
    }

    public BBox getBounds() {
        return this.bounds;
    }

    public int getParts() {
        return this.parts;
    }

    public double getDeltaLat() {
        return (this.bounds.maxLat - this.bounds.minLat) / (double)this.parts;
    }

    public double getDeltaLon() {
        return (this.bounds.maxLon - this.bounds.minLon) / (double)this.parts;
    }
}

