/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.util.EdgeIterator;

public class DefaultTurnCostProvider
implements TurnCostProvider {
    private final DecimalEncodedValue turnCostEnc;
    private final TurnCostStorage turnCostStorage;
    private final int uTurnCostsInt;
    private final double uTurnCosts;

    public DefaultTurnCostProvider(FlagEncoder encoder, TurnCostStorage turnCostStorage) {
        this(encoder, turnCostStorage, -1);
    }

    public DefaultTurnCostProvider(FlagEncoder encoder, TurnCostStorage turnCostStorage, int uTurnCosts) {
        if (uTurnCosts < 0 && uTurnCosts != -1) {
            throw new IllegalArgumentException("u-turn costs must be positive, or equal to -1 (=infinite costs)");
        }
        this.uTurnCostsInt = uTurnCosts;
        double d = this.uTurnCosts = uTurnCosts < 0 ? Double.POSITIVE_INFINITY : (double)uTurnCosts;
        if (turnCostStorage == null) {
            throw new IllegalArgumentException("No storage set to calculate turn weight");
        }
        String key = TurnCost.key(encoder.toString());
        this.turnCostEnc = encoder.hasEncodedValue(key) ? encoder.getDecimalEncodedValue(key) : null;
        this.turnCostStorage = turnCostStorage;
    }

    @Override
    public double calcTurnWeight(int edgeFrom, int nodeVia, int edgeTo) {
        if (!EdgeIterator.Edge.isValid(edgeFrom) || !EdgeIterator.Edge.isValid(edgeTo)) {
            return 0.0;
        }
        double tCost = 0.0;
        if (edgeFrom == edgeTo) {
            tCost = this.uTurnCosts;
        } else if (this.turnCostEnc != null) {
            tCost = this.turnCostStorage.get(this.turnCostEnc, edgeFrom, nodeVia, edgeTo);
        }
        return tCost;
    }

    @Override
    public long calcTurnMillis(int inEdge, int viaNode, int outEdge) {
        return (long)(1000.0 * this.calcTurnWeight(inEdge, viaNode, outEdge));
    }

    public String toString() {
        return "default_tcp_" + this.uTurnCostsInt;
    }
}

