/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.Surface;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import java.util.List;

public class OSMSurfaceParser
implements TagParser {
    private final EnumEncodedValue<Surface> surfaceEnc;

    public OSMSurfaceParser() {
        this(new EnumEncodedValue<Surface>("surface", Surface.class));
    }

    public OSMSurfaceParser(EnumEncodedValue<Surface> surfaceEnc) {
        this.surfaceEnc = surfaceEnc;
    }

    @Override
    public void createEncodedValues(EncodedValueLookup lookup, List<EncodedValue> list) {
        list.add(this.surfaceEnc);
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay readerWay, boolean ferry, IntsRef relationFlags) {
        String surfaceTag = readerWay.getTag("surface");
        Surface surface = Surface.find(surfaceTag);
        if (surface == Surface.MISSING) {
            return edgeFlags;
        }
        if (surfaceTag.equals("metal")) {
            surface = Surface.PAVED;
        } else if (surfaceTag.equals("sett")) {
            surface = Surface.COBBLESTONE;
        } else if (surfaceTag.equals("wood")) {
            surface = Surface.UNPAVED;
        } else if (surfaceTag.equals("earth")) {
            surface = Surface.DIRT;
        }
        this.surfaceEnc.setEnum(false, edgeFlags, surface);
        return edgeFlags;
    }
}

