/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

class OnFlyStatisticsCalculator {
    private long count;
    private double mean;
    private double varianceHelper;

    OnFlyStatisticsCalculator() {
    }

    void addObservation(long value) {
        ++this.count;
        double delta = (double)value - this.mean;
        this.mean += delta / (double)this.count;
        double newDelta = (double)value - this.mean;
        this.varianceHelper += delta * newDelta;
    }

    public long getCount() {
        return this.count;
    }

    double getMean() {
        return this.mean;
    }

    double getVariance() {
        return this.varianceHelper / (double)this.count;
    }

    void reset() {
        this.count = 0L;
        this.mean = 0.0;
        this.varianceHelper = 0.0;
    }
}

