/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.navigation;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.graphhopper.GHResponse;
import com.graphhopper.ResponsePath;
import com.graphhopper.jackson.ResponsePathSerializer;
import com.graphhopper.navigation.DistanceConfig;
import com.graphhopper.navigation.VoiceInstructionConfig;
import com.graphhopper.util.Helper;
import com.graphhopper.util.Instruction;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.PointList;
import com.graphhopper.util.RoundaboutInstruction;
import com.graphhopper.util.TranslationMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public class NavigateResponseConverter {
    private static final int VOICE_INSTRUCTION_MERGE_TRESHHOLD = 100;

    public static ObjectNode convertFromGHResponse(GHResponse ghResponse, TranslationMap translationMap, Locale locale, DistanceConfig distanceConfig) {
        ObjectNode json = JsonNodeFactory.instance.objectNode();
        if (ghResponse.hasErrors()) {
            throw new IllegalStateException("If the response has errors, you should use the method NavigateResponseConverter#convertFromGHResponseError");
        }
        PointList waypoints = ghResponse.getBest().getWaypoints();
        ArrayNode routesJson = json.putArray("routes");
        List<ResponsePath> paths = ghResponse.getAll();
        for (int i = 0; i < paths.size(); ++i) {
            ResponsePath path = paths.get(i);
            ObjectNode pathJson = routesJson.addObject();
            NavigateResponseConverter.putRouteInformation(pathJson, path, i, translationMap, locale, distanceConfig);
        }
        ArrayNode waypointsJson = json.putArray("waypoints");
        for (int i = 0; i < waypoints.size(); ++i) {
            ObjectNode waypointJson = waypointsJson.addObject();
            waypointJson.put("name", "");
            NavigateResponseConverter.putLocation(waypoints.getLat(i), waypoints.getLon(i), waypointJson);
        }
        json.put("code", "Ok");
        json.put("uuid", UUID.randomUUID().toString().replaceAll("-", ""));
        return json;
    }

    private static void putRouteInformation(ObjectNode pathJson, ResponsePath path, int routeNr, TranslationMap translationMap, Locale locale, DistanceConfig distanceConfig) {
        InstructionList instructions = path.getInstructions();
        pathJson.put("geometry", ResponsePathSerializer.encodePolyline(path.getPoints(), false, 1000000.0));
        ArrayNode legsJson = pathJson.putArray("legs");
        ObjectNode legJson = legsJson.addObject();
        ArrayNode steps = legJson.putArray("steps");
        long time = 0L;
        double distance = 0.0;
        boolean isFirstInstructionOfLeg = true;
        for (int i = 0; i < instructions.size(); ++i) {
            ObjectNode instructionJson = steps.addObject();
            NavigateResponseConverter.putInstruction(instructions, i, locale, translationMap, instructionJson, isFirstInstructionOfLeg, distanceConfig);
            Instruction instruction = instructions.get(i);
            time += instruction.getTime();
            distance += instruction.getDistance();
            isFirstInstructionOfLeg = false;
            if (instruction.getSign() != 5 && instruction.getSign() != 4) continue;
            NavigateResponseConverter.putLegInformation(legJson, path, routeNr, time, distance);
            isFirstInstructionOfLeg = true;
            time = 0L;
            distance = 0.0;
            if (instruction.getSign() != 5) continue;
            legJson = legsJson.addObject();
            steps = legJson.putArray("steps");
        }
        pathJson.put("weight_name", "routability");
        pathJson.put("weight", Helper.round(path.getRouteWeight(), 1));
        pathJson.put("duration", NavigateResponseConverter.convertToSeconds(path.getTime()));
        pathJson.put("distance", Helper.round(path.getDistance(), 1));
        pathJson.put("voiceLocale", locale.toLanguageTag());
    }

    private static void putLegInformation(ObjectNode legJson, ResponsePath path, int i, long time, double distance) {
        String summary = !path.getDescription().isEmpty() ? String.join((CharSequence)",", path.getDescription()) : "GraphHopper Route " + i;
        legJson.put("summary", summary);
        legJson.put("weight", NavigateResponseConverter.convertToSeconds(time));
        legJson.put("duration", NavigateResponseConverter.convertToSeconds(time));
        legJson.put("distance", Helper.round(distance, 1));
    }

    private static ObjectNode putInstruction(InstructionList instructions, int index, Locale locale, TranslationMap translationMap, ObjectNode instructionJson, boolean isFirstInstructionOfLeg, DistanceConfig distanceConfig) {
        Instruction instruction = instructions.get(index);
        ArrayNode intersections = instructionJson.putArray("intersections");
        ObjectNode intersection = intersections.addObject();
        intersection.putArray("entry");
        intersection.putArray("bearings");
        PointList pointList = instruction.getPoints().clone(false);
        if (index + 2 < instructions.size()) {
            PointList nextPoints = instructions.get(index + 1).getPoints();
            pointList.add(nextPoints.getLat(0), nextPoints.getLon(0), nextPoints.getEle(0));
        } else if (pointList.size() == 1) {
            pointList.add(pointList.getLat(0), pointList.getLon(0), pointList.getEle(0));
        }
        NavigateResponseConverter.putLocation(pointList.getLat(0), pointList.getLon(0), intersection);
        instructionJson.put("driving_side", "right");
        instructionJson.put("geometry", ResponsePathSerializer.encodePolyline(pointList, false, 1000000.0));
        instructionJson.put("mode", "driving");
        NavigateResponseConverter.putManeuver(instruction, instructionJson, locale, translationMap, isFirstInstructionOfLeg);
        double distance = Helper.round(instruction.getDistance(), 1);
        instructionJson.put("weight", distance);
        instructionJson.put("duration", NavigateResponseConverter.convertToSeconds(instruction.getTime()));
        instructionJson.put("name", instruction.getName());
        instructionJson.put("distance", distance);
        ArrayNode voiceInstructions = instructionJson.putArray("voiceInstructions");
        ArrayNode bannerInstructions = instructionJson.putArray("bannerInstructions");
        if (index + 1 < instructions.size()) {
            NavigateResponseConverter.putVoiceInstructions(instructions, distance, index, locale, translationMap, voiceInstructions, distanceConfig);
            NavigateResponseConverter.putBannerInstructions(instructions, distance, index, locale, translationMap, bannerInstructions);
        }
        return instructionJson;
    }

    private static void putVoiceInstructions(InstructionList instructions, double distance, int index, Locale locale, TranslationMap translationMap, ArrayNode voiceInstructions, DistanceConfig distanceConfig) {
        Instruction nextInstruction = instructions.get(index + 1);
        String turnDescription = nextInstruction.getTurnDescription(translationMap.getWithFallBack(locale));
        String thenVoiceInstruction = NavigateResponseConverter.getThenVoiceInstructionpart(instructions, index, locale, translationMap);
        List<VoiceInstructionConfig.VoiceInstructionValue> voiceValues = distanceConfig.getVoiceInstructionsForDistance(distance, turnDescription, thenVoiceInstruction);
        for (VoiceInstructionConfig.VoiceInstructionValue voiceValue : voiceValues) {
            NavigateResponseConverter.putSingleVoiceInstruction(voiceValue.spokenDistance, voiceValue.turnDescription, voiceInstructions);
        }
        double distanceAlongGeometry = Helper.round(Math.min(distance, 80.0), 1);
        if (index + 2 == instructions.size()) {
            distanceAlongGeometry = Helper.round(Math.min(distance, 25.0), 1);
        }
        NavigateResponseConverter.putSingleVoiceInstruction(distanceAlongGeometry, turnDescription + thenVoiceInstruction, voiceInstructions);
    }

    private static void putSingleVoiceInstruction(double distanceAlongGeometry, String turnDescription, ArrayNode voiceInstructions) {
        ObjectNode voiceInstruction = voiceInstructions.addObject();
        voiceInstruction.put("distanceAlongGeometry", distanceAlongGeometry);
        voiceInstruction.put("announcement", turnDescription);
        voiceInstruction.put("ssmlAnnouncement", "<speak><amazon:effect name=\"drc\"><prosody rate=\"1.08\">" + turnDescription + "</prosody></amazon:effect></speak>");
    }

    private static String getThenVoiceInstructionpart(InstructionList instructions, int index, Locale locale, TranslationMap translationMap) {
        Instruction secondInstruction;
        Instruction firstInstruction;
        if (instructions.size() > index + 2 && (firstInstruction = instructions.get(index + 1)).getDistance() < 100.0 && (secondInstruction = instructions.get(index + 2)).getSign() != 5) {
            return ", " + translationMap.getWithFallBack(locale).tr("navigate.then", new Object[0]) + " " + secondInstruction.getTurnDescription(translationMap.getWithFallBack(locale));
        }
        return "";
    }

    private static void putBannerInstructions(InstructionList instructions, double distance, int index, Locale locale, TranslationMap translationMap, ArrayNode bannerInstructions) {
        ObjectNode bannerInstruction = bannerInstructions.addObject();
        bannerInstruction.put("distanceAlongGeometry", distance);
        ObjectNode primary = bannerInstruction.putObject("primary");
        NavigateResponseConverter.putSingleBannerInstruction(instructions.get(index + 1), locale, translationMap, primary);
        bannerInstruction.putNull("secondary");
        if (instructions.size() > index + 2 && instructions.get(index + 2).getSign() != 5) {
            ObjectNode sub = bannerInstruction.putObject("sub");
            NavigateResponseConverter.putSingleBannerInstruction(instructions.get(index + 2), locale, translationMap, sub);
        }
    }

    private static void putSingleBannerInstruction(Instruction instruction, Locale locale, TranslationMap translationMap, ObjectNode singleBannerInstruction) {
        String bannerInstructionName = instruction.getName();
        if (bannerInstructionName == null || bannerInstructionName.isEmpty()) {
            bannerInstructionName = instruction.getTurnDescription(translationMap.getWithFallBack(locale));
            bannerInstructionName = Helper.firstBig(bannerInstructionName);
        }
        singleBannerInstruction.put("text", bannerInstructionName);
        ArrayNode components = singleBannerInstruction.putArray("components");
        ObjectNode component = components.addObject();
        component.put("text", bannerInstructionName);
        component.put("type", "text");
        singleBannerInstruction.put("type", NavigateResponseConverter.getTurnType(instruction, false));
        String modifier = NavigateResponseConverter.getModifier(instruction);
        if (modifier != null) {
            singleBannerInstruction.put("modifier", modifier);
        }
        if (instruction.getSign() == 6 && instruction instanceof RoundaboutInstruction) {
            double turnAngle = ((RoundaboutInstruction)instruction).getTurnAngle();
            if (Double.isNaN(turnAngle)) {
                singleBannerInstruction.putNull("degrees");
            } else {
                double degree = Math.abs(turnAngle) * 180.0 / Math.PI;
                singleBannerInstruction.put("degrees", degree);
            }
        }
    }

    private static void putManeuver(Instruction instruction, ObjectNode instructionJson, Locale locale, TranslationMap translationMap, boolean isFirstInstructionOfLeg) {
        ObjectNode maneuver = instructionJson.putObject("maneuver");
        maneuver.put("bearing_after", 0);
        maneuver.put("bearing_before", 0);
        PointList points = instruction.getPoints();
        NavigateResponseConverter.putLocation(points.getLat(0), points.getLon(0), maneuver);
        String modifier = NavigateResponseConverter.getModifier(instruction);
        if (modifier != null) {
            maneuver.put("modifier", modifier);
        }
        maneuver.put("type", NavigateResponseConverter.getTurnType(instruction, isFirstInstructionOfLeg));
        if (instruction instanceof RoundaboutInstruction) {
            maneuver.put("exit", ((RoundaboutInstruction)instruction).getExitNumber());
        }
        maneuver.put("instruction", instruction.getTurnDescription(translationMap.getWithFallBack(locale)));
    }

    private static String getTurnType(Instruction instruction, boolean isFirstInstructionOfLeg) {
        if (isFirstInstructionOfLeg) {
            return "depart";
        }
        switch (instruction.getSign()) {
            case 4: 
            case 5: {
                return "arrive";
            }
            case 6: {
                return "roundabout";
            }
        }
        return "turn";
    }

    private static String getModifier(Instruction instruction) {
        switch (instruction.getSign()) {
            case 0: {
                return "straight";
            }
            case -98: 
            case -8: 
            case 8: {
                return "uturn";
            }
            case -7: 
            case -1: {
                return "slight left";
            }
            case -2: {
                return "left";
            }
            case -3: {
                return "sharp left";
            }
            case 1: 
            case 7: {
                return "slight right";
            }
            case 2: {
                return "right";
            }
            case 3: {
                return "sharp right";
            }
            case 6: {
                return "right";
            }
        }
        return null;
    }

    private static ObjectNode putLocation(double lat, double lon, ObjectNode node) {
        ArrayNode location = node.putArray("location");
        location.add(Helper.round6(lon));
        location.add(Helper.round6(lat));
        return node;
    }

    private static double convertToSeconds(double milliSeconds) {
        return Helper.round(milliSeconds / 1000.0, 1);
    }

    public static ObjectNode convertFromGHResponseError(GHResponse ghResponse) {
        ObjectNode json = JsonNodeFactory.instance.objectNode();
        json.put("code", "InvalidInput");
        json.put("message", ghResponse.getErrors().get(0).getMessage());
        return json;
    }
}

