/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.isochrone.algorithm;

import com.graphhopper.isochrone.algorithm.ReadableQuadEdge;
import com.graphhopper.isochrone.algorithm.ReadableTriangulation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.locationtech.jts.algorithm.CGAlgorithms;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.prep.PreparedPolygon;
import org.locationtech.jts.triangulate.quadedge.Vertex;

public class ContourBuilder {
    private static final double EPSILON = 1.0E-6;
    private final GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(1.0E8));
    private final ReadableTriangulation triangulation;

    public ContourBuilder(ReadableTriangulation triangulation) {
        this.triangulation = triangulation;
    }

    public MultiPolygon computeIsoline(double z0, Collection<ReadableQuadEdge> seedEdges) {
        HashSet<ReadableQuadEdge> processed = new HashSet<ReadableQuadEdge>();
        ArrayList<LinearRing> rings = new ArrayList<LinearRing>();
        for (ReadableQuadEdge f : seedEdges) {
            boolean ccw;
            ReadableQuadEdge e = f.getPrimary();
            if (processed.contains(e)) continue;
            processed.add(e);
            int cut = this.cut(e.orig().getZ(), e.dest().getZ(), z0);
            if (cut == 0) continue;
            ArrayList<Coordinate> polyPoints = new ArrayList<Coordinate>();
            boolean bl = ccw = cut > 0;
            while (true) {
                boolean ok2;
                Coordinate cC = this.isFrameVertex(e.orig()) ? this.moveEpsilonTowards(e.dest().getCoordinate(), e.orig().getCoordinate()) : (this.isFrameVertex(e.dest()) ? this.moveEpsilonTowards(e.orig().getCoordinate(), e.dest().getCoordinate()) : e.orig().midPoint(e.dest()).getCoordinate());
                polyPoints.add(new Coordinate(cC.x, cC.y));
                processed.add(e);
                ReadableQuadEdge E1 = ccw ? e.oNext().getPrimary() : e.oPrev().getPrimary();
                ReadableQuadEdge E2 = ccw ? e.dPrev().getPrimary() : e.dNext().getPrimary();
                int cut1 = E1 == null ? 0 : this.cut(E1.orig().getZ(), E1.dest().getZ(), z0);
                int cut2 = E2 == null ? 0 : this.cut(E2.orig().getZ(), E2.dest().getZ(), z0);
                boolean ok1 = cut1 != 0 && !processed.contains(E1);
                boolean bl2 = ok2 = cut2 != 0 && !processed.contains(E2);
                if (ok1) {
                    e = E1;
                    ccw = cut1 > 0;
                    continue;
                }
                if (!ok2) break;
                e = E2;
                ccw = cut2 > 0;
            }
            polyPoints.add((Coordinate)polyPoints.get(0));
            if (polyPoints.size() < 4) continue;
            LinearRing ring = this.geometryFactory.createLinearRing(polyPoints.toArray(new Coordinate[polyPoints.size()]));
            rings.add(ring);
        }
        List<Polygon> isolinePolygons = this.punchHoles(rings);
        return this.geometryFactory.createMultiPolygon(isolinePolygons.toArray(new Polygon[isolinePolygons.size()]));
    }

    private boolean isFrameVertex(Vertex v) {
        return v.getZ() == Double.MAX_VALUE;
    }

    private Coordinate moveEpsilonTowards(Coordinate coordinate, Coordinate distantFrameCoordinate) {
        return new Coordinate(coordinate.x + 1.0E-6 * (distantFrameCoordinate.x - coordinate.x), coordinate.y + 1.0E-6 * (distantFrameCoordinate.y - coordinate.y));
    }

    private int cut(double za, double zb, double z0) {
        if (za <= z0 && zb > z0) {
            return 1;
        }
        if (za > z0 && zb <= z0) {
            return -1;
        }
        return 0;
    }

    private List<Polygon> punchHoles(List<LinearRing> rings) {
        ArrayList<PreparedPolygon> shells = new ArrayList<PreparedPolygon>(rings.size());
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>(rings.size() / 2);
        for (LinearRing ring : rings) {
            if (CGAlgorithms.signedArea(ring.getCoordinateSequence()) > 0.0) {
                holes.add(ring);
                continue;
            }
            shells.add(new PreparedPolygon(this.geometryFactory.createPolygon(ring)));
        }
        shells.sort((o1, o2) -> o2.getGeometry().getNumPoints() - o1.getGeometry().getNumPoints());
        for (PreparedPolygon shell : shells) {
            shell.getGeometry().setUserData(new ArrayList());
        }
        block2: for (LinearRing hole : holes) {
            for (PreparedPolygon shell : shells) {
                if (!shell.contains(hole)) continue;
                ((List)shell.getGeometry().getUserData()).add(hole);
                continue block2;
            }
            throw new RuntimeException("Found a hole without a shell.");
        }
        ArrayList<Polygon> punched = new ArrayList<Polygon>(shells.size());
        for (PreparedPolygon shell : shells) {
            List shellHoles = (List)shell.getGeometry().getUserData();
            punched.add(this.geometryFactory.createPolygon((LinearRing)((Polygon)shell.getGeometry()).getExteriorRing(), shellHoles.toArray(new LinearRing[shellHoles.size()])));
        }
        return punched;
    }
}

