/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import com.conveyal.gtfs.GTFSFeed;
import com.google.transit.realtime.GtfsRealtime;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopper;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.ResponsePath;
import com.graphhopper.config.Profile;
import com.graphhopper.gtfs.GHLocation;
import com.graphhopper.gtfs.GHPointLocation;
import com.graphhopper.gtfs.GHStationLocation;
import com.graphhopper.gtfs.GraphExplorer;
import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.Label;
import com.graphhopper.gtfs.MultiCriteriaLabelSetting;
import com.graphhopper.gtfs.PtEncodedValues;
import com.graphhopper.gtfs.PtRouter;
import com.graphhopper.gtfs.RealtimeFeed;
import com.graphhopper.gtfs.Request;
import com.graphhopper.gtfs.Transfers;
import com.graphhopper.gtfs.TripFromLabel;
import com.graphhopper.gtfs.WrapperGraph;
import com.graphhopper.routing.DefaultWeightingFactory;
import com.graphhopper.routing.WeightingFactory;
import com.graphhopper.routing.ev.Subnetwork;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.querygraph.VirtualEdgeIteratorState;
import com.graphhopper.routing.util.DefaultSnapFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.weighting.FastestWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.PMap;
import com.graphhopper.util.PointList;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.Translation;
import com.graphhopper.util.TranslationMap;
import com.graphhopper.util.details.PathDetailsBuilderFactory;
import com.graphhopper.util.exceptions.PointNotFoundException;
import com.graphhopper.util.shapes.GHPoint;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;

public final class PtRouterFreeWalkImpl
implements PtRouter {
    private final GraphHopperConfig config;
    private final TranslationMap translationMap;
    private final PtEncodedValues ptEncodedValues;
    private final Weighting accessEgressWeighting;
    private final GraphHopperStorage graphHopperStorage;
    private final LocationIndex locationIndex;
    private final GtfsStorage gtfsStorage;
    private final RealtimeFeed realtimeFeed;
    private final TripFromLabel tripFromLabel;
    private final WeightingFactory weightingFactory;

    @Inject
    public PtRouterFreeWalkImpl(GraphHopperConfig config, TranslationMap translationMap, GraphHopperStorage graphHopperStorage, LocationIndex locationIndex, GtfsStorage gtfsStorage, RealtimeFeed realtimeFeed, PathDetailsBuilderFactory pathDetailsBuilderFactory) {
        this.config = config;
        this.ptEncodedValues = PtEncodedValues.fromEncodingManager(graphHopperStorage.getEncodingManager());
        this.weightingFactory = new DefaultWeightingFactory(graphHopperStorage, graphHopperStorage.getEncodingManager());
        this.accessEgressWeighting = new FastestWeighting(graphHopperStorage.getEncodingManager().getEncoder("foot"));
        this.translationMap = translationMap;
        this.graphHopperStorage = graphHopperStorage;
        this.locationIndex = locationIndex;
        this.gtfsStorage = gtfsStorage;
        this.realtimeFeed = realtimeFeed;
        this.tripFromLabel = new TripFromLabel(this.graphHopperStorage, this.gtfsStorage, this.realtimeFeed, pathDetailsBuilderFactory);
    }

    public static Factory createFactory(GraphHopperConfig config, TranslationMap translationMap, GraphHopper graphHopperStorage, LocationIndex locationIndex, GtfsStorage gtfsStorage) {
        return new Factory(config, translationMap, graphHopperStorage.getGraphHopperStorage(), locationIndex, gtfsStorage);
    }

    @Override
    public GHResponse route(Request request) {
        return new RequestHandler(request).route();
    }

    private class RequestHandler {
        private final int maxVisitedNodesForRequest;
        private final int limitSolutions;
        private final long maxProfileDuration;
        private final Instant initialTime;
        private final boolean profileQuery;
        private final boolean arriveBy;
        private final boolean ignoreTransfers;
        private final double betaTransfers;
        private final double betaStreetTime;
        private final double walkSpeedKmH;
        private final int blockedRouteTypes;
        private final GHLocation enter;
        private final GHLocation exit;
        private final Translation translation;
        private final List<String> requestedPathDetails;
        private final List<VirtualEdgeIteratorState> extraEdges;
        private final GHResponse response;
        private final Graph graphWithExtraEdges;
        private final long limitTripTime;
        private final long limitStreetTime;
        private QueryGraph queryGraph;
        private int visitedNodes;
        private MultiCriteriaLabelSetting router;
        private final Profile accessProfile;
        private final EdgeFilter accessSnapFilter;
        private final Weighting accessWeighting;
        private final Profile egressProfile;
        private final EdgeFilter egressSnapFilter;
        private final Weighting egressWeighting;

        RequestHandler(Request request) {
            this.extraEdges = new ArrayList<VirtualEdgeIteratorState>(PtRouterFreeWalkImpl.this.realtimeFeed.getAdditionalEdges());
            this.response = new GHResponse();
            this.graphWithExtraEdges = new WrapperGraph(PtRouterFreeWalkImpl.this.graphHopperStorage, this.extraEdges);
            this.maxVisitedNodesForRequest = request.getMaxVisitedNodes();
            this.profileQuery = request.isProfileQuery();
            this.ignoreTransfers = Optional.ofNullable(request.getIgnoreTransfers()).orElse(request.isProfileQuery());
            this.betaTransfers = request.getBetaTransfers();
            this.betaStreetTime = request.getBetaStreetTime();
            this.limitSolutions = Optional.ofNullable(request.getLimitSolutions()).orElse(this.profileQuery ? 50 : (this.ignoreTransfers ? 1 : Integer.MAX_VALUE));
            this.initialTime = request.getEarliestDepartureTime();
            this.maxProfileDuration = request.getMaxProfileDuration().toMillis();
            this.arriveBy = request.isArriveBy();
            this.walkSpeedKmH = request.getWalkSpeedKmH();
            this.blockedRouteTypes = request.getBlockedRouteTypes();
            this.translation = PtRouterFreeWalkImpl.this.translationMap.getWithFallBack(request.getLocale());
            this.enter = request.getPoints().get(0);
            this.exit = request.getPoints().get(1);
            this.limitTripTime = request.getLimitTripTime() != null ? request.getLimitTripTime().toMillis() : Long.MAX_VALUE;
            this.limitStreetTime = request.getLimitStreetTime() != null ? request.getLimitStreetTime().toMillis() : Long.MAX_VALUE;
            this.requestedPathDetails = request.getPathDetails();
            this.accessProfile = PtRouterFreeWalkImpl.this.config.getProfiles().stream().filter(p -> p.getName().equals(request.getAccessProfile())).findFirst().get();
            this.accessWeighting = PtRouterFreeWalkImpl.this.weightingFactory.createWeighting(this.accessProfile, new PMap(), false);
            this.accessSnapFilter = new DefaultSnapFilter(new FastestWeighting(PtRouterFreeWalkImpl.this.graphHopperStorage.getEncodingManager().getEncoder(this.accessProfile.getVehicle())), PtRouterFreeWalkImpl.this.graphHopperStorage.getEncodingManager().getBooleanEncodedValue(Subnetwork.key(this.accessProfile.getVehicle())));
            this.egressProfile = PtRouterFreeWalkImpl.this.config.getProfiles().stream().filter(p -> p.getName().equals(request.getEgressProfile())).findFirst().get();
            this.egressWeighting = PtRouterFreeWalkImpl.this.weightingFactory.createWeighting(this.egressProfile, new PMap(), false);
            this.egressSnapFilter = new DefaultSnapFilter(new FastestWeighting(PtRouterFreeWalkImpl.this.graphHopperStorage.getEncodingManager().getEncoder(this.egressProfile.getVehicle())), PtRouterFreeWalkImpl.this.graphHopperStorage.getEncodingManager().getBooleanEncodedValue(Subnetwork.key(this.egressProfile.getVehicle())));
        }

        GHResponse route() {
            int destNode;
            int startNode;
            StopWatch stopWatch = new StopWatch().start();
            ArrayList<Snap> pointSnaps = new ArrayList<Snap>();
            ArrayList<Snap> allSnaps = new ArrayList<Snap>();
            PointList points = new PointList(2, false);
            List<GHLocation> locations = Arrays.asList(this.enter, this.exit);
            for (int i = 0; i < locations.size(); ++i) {
                GHLocation location = locations.get(i);
                if (location instanceof GHPointLocation) {
                    Snap closest = this.findByPoint(((GHPointLocation)location).ghPoint, i, i == 0 ? this.accessSnapFilter : this.egressSnapFilter);
                    pointSnaps.add(closest);
                    allSnaps.add(closest);
                    points.add(closest.getSnappedPoint());
                    continue;
                }
                if (!(location instanceof GHStationLocation)) continue;
                Snap station = this.findByStationId((GHStationLocation)location, i);
                allSnaps.add(station);
                points.add(PtRouterFreeWalkImpl.this.graphHopperStorage.getNodeAccess().getLat(station.getClosestNode()), PtRouterFreeWalkImpl.this.graphHopperStorage.getNodeAccess().getLon(station.getClosestNode()));
            }
            this.queryGraph = QueryGraph.create(this.graphWithExtraEdges, pointSnaps);
            this.response.addDebugInfo("idLookup:" + stopWatch.stop().getSeconds() + "s");
            if (this.arriveBy) {
                startNode = ((Snap)allSnaps.get(1)).getClosestNode();
                destNode = ((Snap)allSnaps.get(0)).getClosestNode();
            } else {
                startNode = ((Snap)allSnaps.get(0)).getClosestNode();
                destNode = ((Snap)allSnaps.get(1)).getClosestNode();
            }
            List<List<Label.Transition>> solutions = this.findPaths(startNode, destNode);
            this.parseSolutionsAndAddToResponse(solutions, points);
            return this.response;
        }

        private Snap findByPoint(GHPoint point, int indexForErrorMessage, EdgeFilter snapFilter) {
            Snap source = PtRouterFreeWalkImpl.this.locationIndex.findClosest(point.lat, point.lon, snapFilter);
            if (!source.isValid()) {
                throw new PointNotFoundException("Cannot find point: " + point, indexForErrorMessage);
            }
            if (source.getClosestEdge().get(PtRouterFreeWalkImpl.this.ptEncodedValues.getTypeEnc()) != GtfsStorage.EdgeType.HIGHWAY) {
                throw new RuntimeException(source.getClosestEdge().get(PtRouterFreeWalkImpl.this.ptEncodedValues.getTypeEnc()).name());
            }
            return source;
        }

        private Snap findByStationId(GHStationLocation exit, int indexForErrorMessage) {
            for (Map.Entry<String, GTFSFeed> entry : PtRouterFreeWalkImpl.this.gtfsStorage.getGtfsFeeds().entrySet()) {
                Integer node = PtRouterFreeWalkImpl.this.gtfsStorage.getStationNodes().get(new GtfsStorage.FeedIdWithStopId(entry.getKey(), exit.stop_id));
                if (node == null) continue;
                Snap station = new Snap(PtRouterFreeWalkImpl.this.graphHopperStorage.getNodeAccess().getLat(node), PtRouterFreeWalkImpl.this.graphHopperStorage.getNodeAccess().getLon(node));
                station.setClosestNode(node);
                return station;
            }
            throw new PointNotFoundException("Cannot find station: " + exit.stop_id, indexForErrorMessage);
        }

        private void parseSolutionsAndAddToResponse(List<List<Label.Transition>> solutions, PointList waypoints) {
            for (List<Label.Transition> solution : solutions) {
                ResponsePath responsePath = PtRouterFreeWalkImpl.this.tripFromLabel.createResponsePath(this.translation, waypoints, this.queryGraph, this.accessWeighting, this.egressWeighting, solution, this.requestedPathDetails);
                responsePath.setImpossible(solution.stream().anyMatch(t -> t.label.impossible));
                responsePath.setTime(solution.get((int)(solution.size() - 1)).label.currentTime - solution.get((int)0).label.currentTime);
                responsePath.setRouteWeight(this.router.weight(solution.get((int)(solution.size() - 1)).label));
                this.response.add(responsePath);
            }
            Comparator<ResponsePath> c = Comparator.comparingInt(p -> p.isImpossible() ? 1 : 0);
            Comparator<ResponsePath> d = Comparator.comparingDouble(ResponsePath::getTime);
            this.response.getAll().sort(c.thenComparing(d));
        }

        private List<List<Label.Transition>> findPaths(int startNode, int destNode) {
            StopWatch stopWatch = new StopWatch().start();
            GraphExplorer graphExplorer = new GraphExplorer(this.queryGraph, PtRouterFreeWalkImpl.this.accessEgressWeighting, PtRouterFreeWalkImpl.this.ptEncodedValues, PtRouterFreeWalkImpl.this.gtfsStorage, PtRouterFreeWalkImpl.this.realtimeFeed, this.arriveBy, false, false, this.walkSpeedKmH, false, this.blockedRouteTypes);
            ArrayList<Label> discoveredSolutions = new ArrayList<Label>();
            this.router = new MultiCriteriaLabelSetting(graphExplorer, PtRouterFreeWalkImpl.this.ptEncodedValues, this.arriveBy, !this.ignoreTransfers, this.profileQuery, this.maxProfileDuration, discoveredSolutions);
            this.router.setBetaTransfers(this.betaTransfers);
            this.router.setBetaStreetTime(this.betaStreetTime);
            this.router.setLimitStreetTime(this.limitStreetTime);
            Iterator iterator = this.router.calcLabels(startNode, this.initialTime).iterator();
            while (iterator.hasNext()) {
                Label label = (Label)iterator.next();
                ++this.visitedNodes;
                if (this.visitedNodes >= this.maxVisitedNodesForRequest) break;
                if (label.adjNode != destNode) continue;
                discoveredSolutions.add(label);
                if (discoveredSolutions.size() < this.limitSolutions) continue;
                break;
            }
            discoveredSolutions.sort(Comparator.comparingLong(s2 -> Optional.ofNullable(s2.departureTime).orElse(0L)));
            ArrayList<List<Label.Transition>> paths = new ArrayList<List<Label.Transition>>();
            for (Label discoveredSolution : discoveredSolutions) {
                List<Label.Transition> path = Label.getTransitions(discoveredSolution, this.arriveBy, PtRouterFreeWalkImpl.this.ptEncodedValues, this.queryGraph, PtRouterFreeWalkImpl.this.realtimeFeed);
                paths.add(path);
            }
            this.response.addDebugInfo("routing:" + stopWatch.stop().getSeconds() + "s");
            if (discoveredSolutions.isEmpty() && this.visitedNodes >= this.maxVisitedNodesForRequest) {
                this.response.addError(new IllegalArgumentException("No path found - maximum number of nodes exceeded: " + this.maxVisitedNodesForRequest));
            }
            this.response.getHints().putObject("visited_nodes.sum", this.visitedNodes);
            this.response.getHints().putObject("visited_nodes.average", this.visitedNodes);
            if (discoveredSolutions.isEmpty()) {
                this.response.addError(new RuntimeException("No route found"));
            }
            return paths;
        }
    }

    public static class Factory {
        private final GraphHopperConfig config;
        private final TranslationMap translationMap;
        private final GraphHopperStorage graphHopperStorage;
        private final LocationIndex locationIndex;
        private final GtfsStorage gtfsStorage;
        private final Map<String, Transfers> transfers;

        private Factory(GraphHopperConfig config, TranslationMap translationMap, GraphHopperStorage graphHopperStorage, LocationIndex locationIndex, GtfsStorage gtfsStorage) {
            this.config = config;
            this.translationMap = translationMap;
            this.graphHopperStorage = graphHopperStorage;
            this.locationIndex = locationIndex;
            this.gtfsStorage = gtfsStorage;
            this.transfers = new HashMap<String, Transfers>();
            for (Map.Entry<String, GTFSFeed> entry : this.gtfsStorage.getGtfsFeeds().entrySet()) {
                this.transfers.put(entry.getKey(), new Transfers(entry.getValue()));
            }
        }

        public PtRouter createWith(GtfsRealtime.FeedMessage realtimeFeed) {
            HashMap<String, GtfsRealtime.FeedMessage> realtimeFeeds = new HashMap<String, GtfsRealtime.FeedMessage>();
            realtimeFeeds.put("gtfs_0", realtimeFeed);
            return new PtRouterFreeWalkImpl(this.config, this.translationMap, this.graphHopperStorage, this.locationIndex, this.gtfsStorage, RealtimeFeed.fromProtobuf(this.graphHopperStorage, this.gtfsStorage, this.transfers, realtimeFeeds), new PathDetailsBuilderFactory());
        }

        public PtRouter createWithoutRealtimeFeed() {
            return new PtRouterFreeWalkImpl(this.config, this.translationMap, this.graphHopperStorage, this.locationIndex, this.gtfsStorage, RealtimeFeed.empty(this.gtfsStorage), new PathDetailsBuilderFactory());
        }
    }
}

