/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import com.carrotsearch.hppc.IntArrayList;
import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Entity;
import com.conveyal.gtfs.model.Frequency;
import com.conveyal.gtfs.model.Route;
import com.conveyal.gtfs.model.Service;
import com.conveyal.gtfs.model.Stop;
import com.conveyal.gtfs.model.StopTime;
import com.conveyal.gtfs.model.Transfer;
import com.conveyal.gtfs.model.Trip;
import com.google.common.collect.HashMultimap;
import com.google.transit.realtime.GtfsRealtime;
import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.GtfsStorageI;
import com.graphhopper.gtfs.PtEncodedValues;
import com.graphhopper.gtfs.Transfers;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.ev.Subnetwork;
import com.graphhopper.routing.util.AccessFilter;
import com.graphhopper.routing.util.DefaultSnapFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.weighting.FastestWeighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.mapdb.Fun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GtfsReader {
    private LocalDate startDate;
    private LocalDate endDate;
    private static final Logger LOGGER = LoggerFactory.getLogger(GtfsReader.class);
    private final Graph graph;
    private final LocationIndex walkNetworkIndex;
    private final GtfsStorageI gtfsStorage;
    private final DistanceCalc distCalc = DistanceCalcEarth.DIST_EARTH;
    private final Transfers transfers;
    private final NodeAccess nodeAccess;
    private final String id;
    private int i;
    private GTFSFeed feed;
    private final Map<String, Map<GtfsStorageI.PlatformDescriptor, NavigableMap<Integer, Integer>>> departureTimelinesByStop = new HashMap<String, Map<GtfsStorageI.PlatformDescriptor, NavigableMap<Integer, Integer>>>();
    private final Map<String, Map<GtfsStorageI.PlatformDescriptor, NavigableMap<Integer, Integer>>> arrivalTimelinesByStop = new HashMap<String, Map<GtfsStorageI.PlatformDescriptor, NavigableMap<Integer, Integer>>>();
    private final PtEncodedValues ptEncodedValues;
    private final BooleanEncodedValue accessEnc;
    private final IntEncodedValue timeEnc;
    private final IntEncodedValue validityIdEnc;

    GtfsReader(String id, Graph graph, EncodingManager encodingManager, GtfsStorageI gtfsStorage, LocationIndex walkNetworkIndex, Transfers transfers) {
        this.id = id;
        this.graph = graph;
        this.gtfsStorage = gtfsStorage;
        this.nodeAccess = graph.getNodeAccess();
        this.walkNetworkIndex = walkNetworkIndex;
        this.ptEncodedValues = PtEncodedValues.fromEncodingManager(encodingManager);
        this.accessEnc = this.ptEncodedValues.getAccessEnc();
        this.timeEnc = this.ptEncodedValues.getTimeEnc();
        this.validityIdEnc = this.ptEncodedValues.getValidityIdEnc();
        this.feed = this.gtfsStorage.getGtfsFeeds().get(id);
        this.transfers = transfers;
        this.i = graph.getNodes();
        this.startDate = this.feed.getStartDate();
        this.endDate = this.feed.getEndDate();
    }

    void connectStopsToStreetNetwork() {
        EncodingManager em = ((GraphHopperStorage)this.graph).getEncodingManager();
        FlagEncoder footEncoder = em.getEncoder("foot");
        DefaultSnapFilter filter = new DefaultSnapFilter(new FastestWeighting(footEncoder), em.getBooleanEncodedValue(Subnetwork.key("foot")));
        for (Stop stop : this.feed.stops.values()) {
            Integer prev;
            int streetNode;
            if (stop.location_type != 0) continue;
            Snap locationSnap = this.walkNetworkIndex.findClosest(stop.stop_lat, stop.stop_lon, filter);
            if (!locationSnap.isValid()) {
                ++this.i;
                this.nodeAccess.setNode(streetNode, stop.stop_lat, stop.stop_lon);
                EdgeIteratorState edge = this.graph.edge(streetNode, streetNode);
                edge.set(this.accessEnc, true).setReverse(this.accessEnc, false);
                edge.set(footEncoder.getAccessEnc(), true).setReverse(footEncoder.getAccessEnc(), false);
                edge.set(footEncoder.getAverageSpeedEnc(), 5.0);
            } else {
                streetNode = locationSnap.getClosestNode();
            }
            if ((prev = this.gtfsStorage.getStationNodes().put(new GtfsStorage.FeedIdWithStopId(this.id, stop.stop_id), streetNode)) == null) continue;
            throw new RuntimeException("Duplicate stop id: " + stop.stop_id);
        }
    }

    void buildPtNetwork() {
        this.createTrips();
        this.wireUpStops();
        this.insertGtfsTransfers();
    }

    private void createTrips() {
        HashMultimap blockTrips = HashMultimap.create();
        for (Trip trip : this.feed.trips.values()) {
            if (trip.block_id != null) {
                blockTrips.put(trip.block_id, trip);
                continue;
            }
            blockTrips.put("non-block-trip" + trip.trip_id, trip);
        }
        blockTrips.asMap().values().forEach(unsortedTrips -> {
            List<TripWithStopTimes> trips = unsortedTrips.stream().map(trip -> {
                Service service = this.feed.services.get(trip.service_id);
                BitSet validOnDay = new BitSet((int)ChronoUnit.DAYS.between(this.startDate, this.endDate));
                LocalDate date = this.startDate;
                while (!date.isAfter(this.endDate)) {
                    if (service.activeOn(date)) {
                        validOnDay.set((int)ChronoUnit.DAYS.between(this.startDate, date));
                    }
                    date = date.plusDays(1L);
                }
                ArrayList<StopTime> stopTimes = new ArrayList<StopTime>();
                this.feed.getInterpolatedStopTimesForTrip(trip.trip_id).forEach(stopTimes::add);
                return new TripWithStopTimes((Trip)trip, (List<StopTime>)stopTimes, validOnDay, Collections.emptySet(), Collections.emptySet());
            }).sorted(Comparator.comparingInt(trip -> trip.stopTimes.iterator().next().departure_time)).collect(Collectors.toList());
            if (trips.stream().map(trip -> this.feed.getFrequencies(trip.trip.trip_id)).distinct().count() != 1L) {
                throw new RuntimeException("Found a block with frequency-based trips. Not supported.");
            }
            ZoneId zoneId = ZoneId.of(this.feed.agency.get((Object)this.feed.routes.get((Object)((TripWithStopTimes)trips.iterator().next()).trip.route_id).agency_id).agency_timezone);
            Collection<Frequency> frequencies = this.feed.getFrequencies(((TripWithStopTimes)trips.iterator().next()).trip.trip_id);
            if (frequencies.isEmpty()) {
                this.addTrips(zoneId, trips, 0, false);
            } else {
                for (Frequency frequency : frequencies) {
                    for (int time = frequency.start_time; time < frequency.end_time; time += frequency.headway_secs) {
                        this.addTrips(zoneId, trips, time, true);
                    }
                }
            }
        });
    }

    private void wireUpStops() {
        this.arrivalTimelinesByStop.forEach((stopId, arrivalTimelines) -> {
            int streetNode = this.gtfsStorage.getStationNodes().get(new GtfsStorage.FeedIdWithStopId(this.id, (String)stopId));
            Stop stop = this.feed.stops.get(stopId);
            arrivalTimelines.forEach((platformDescriptor, arrivalTimeline) -> this.wireUpArrivalTimeline(streetNode, stop, (NavigableMap<Integer, Integer>)arrivalTimeline, this.routeType((GtfsStorageI.PlatformDescriptor)platformDescriptor), (GtfsStorageI.PlatformDescriptor)platformDescriptor));
        });
        this.departureTimelinesByStop.forEach((stopId, departureTimelines) -> {
            int streetNode = this.gtfsStorage.getStationNodes().get(new GtfsStorage.FeedIdWithStopId(this.id, (String)stopId));
            Stop stop = this.feed.stops.get(stopId);
            departureTimelines.forEach((platformDescriptor, departureTimeline) -> this.wireUpDepartureTimeline(streetNode, stop, (NavigableMap<Integer, Integer>)departureTimeline, this.routeType((GtfsStorageI.PlatformDescriptor)platformDescriptor), (GtfsStorageI.PlatformDescriptor)platformDescriptor));
        });
    }

    private void insertGtfsTransfers() {
        this.departureTimelinesByStop.forEach((toStopId, departureTimelines) -> departureTimelines.forEach(this::insertInboundTransfers));
    }

    private void insertInboundTransfers(GtfsStorageI.PlatformDescriptor toPlatformDescriptor, NavigableMap<Integer, Integer> departureTimeline) {
        LOGGER.debug("Creating transfers to stop {}, platform {}", (Object)toPlatformDescriptor.stop_id, (Object)toPlatformDescriptor);
        List<Transfer> transfersToPlatform = this.transfers.getTransfersToStop(toPlatformDescriptor.stop_id, this.routeIdOrNull(toPlatformDescriptor));
        transfersToPlatform.forEach(transfer -> {
            int stationNode = this.gtfsStorage.getStationNodes().get(new GtfsStorage.FeedIdWithStopId(this.id, transfer.from_stop_id));
            EdgeIterator i = this.graph.createEdgeExplorer().setBaseNode(stationNode);
            while (i.next()) {
                if (i.get(this.ptEncodedValues.getTypeEnc()) != GtfsStorage.EdgeType.EXIT_PT) continue;
                GtfsStorageI.PlatformDescriptor fromPlatformDescriptor = this.gtfsStorage.getPlatformDescriptorByEdge().get(i.getEdge());
                if (!fromPlatformDescriptor.stop_id.equals(transfer.from_stop_id) || (transfer.from_route_id != null || !(fromPlatformDescriptor instanceof GtfsStorageI.RouteTypePlatform)) && (transfer.from_route_id == null || !GtfsStorageI.PlatformDescriptor.route(this.id, transfer.from_stop_id, transfer.from_route_id).equals(fromPlatformDescriptor))) continue;
                LOGGER.debug("  Creating transfers from stop {}, platform {}", (Object)transfer.from_stop_id, (Object)fromPlatformDescriptor);
                this.insertTransferEdges(i.getAdjNode(), transfer.min_transfer_time, departureTimeline, toPlatformDescriptor);
            }
        });
    }

    public void insertTransferEdges(int arrivalPlatformNode, int minTransferTime, GtfsStorageI.PlatformDescriptor departurePlatform) {
        this.insertTransferEdges(arrivalPlatformNode, minTransferTime, this.departureTimelinesByStop.get(departurePlatform.stop_id).get(departurePlatform), departurePlatform);
    }

    private void insertTransferEdges(int arrivalPlatformNode, int minTransferTime, NavigableMap<Integer, Integer> departureTimeline, GtfsStorageI.PlatformDescriptor departurePlatform) {
        EdgeIterator j = this.graph.createEdgeExplorer().setBaseNode(arrivalPlatformNode);
        while (j.next()) {
            int arrivalTime;
            SortedMap<Integer, Integer> tailSet;
            if (j.get(this.ptEncodedValues.getTypeEnc()) != GtfsStorage.EdgeType.LEAVE_TIME_EXPANDED_NETWORK || (tailSet = departureTimeline.tailMap((arrivalTime = j.get(this.timeEnc)) + minTransferTime)).isEmpty()) continue;
            EdgeIteratorState edge = this.graph.edge(j.getAdjNode(), (Integer)tailSet.get(tailSet.firstKey()));
            edge.set(this.accessEnc, true).setReverse(this.accessEnc, false);
            this.setEdgeTypeAndClearDistance(edge, GtfsStorage.EdgeType.TRANSFER);
            edge.set(this.timeEnc, tailSet.firstKey() - arrivalTime);
            this.gtfsStorage.getPlatformDescriptorByEdge().put(edge.getEdge(), departurePlatform);
        }
    }

    void wireUpAdditionalDeparturesAndArrivals(ZoneId zoneId) {
        this.departureTimelinesByStop.forEach((stopId, departureTimelines) -> {
            int stationNode = this.gtfsStorage.getStationNodes().get(new GtfsStorage.FeedIdWithStopId(this.id, (String)stopId));
            Stop stop = this.feed.stops.get(stopId);
            departureTimelines.forEach((platformDescriptor, timeline) -> this.wireUpOrPatchDepartureTimeline(zoneId, stationNode, stop, (NavigableMap<Integer, Integer>)timeline, (GtfsStorageI.PlatformDescriptor)platformDescriptor));
        });
        this.arrivalTimelinesByStop.forEach((stopId, arrivalTimelines) -> {
            int stationNode = this.gtfsStorage.getStationNodes().get(new GtfsStorage.FeedIdWithStopId(this.id, (String)stopId));
            Stop stop = this.feed.stops.get(stopId);
            arrivalTimelines.forEach((platformDescriptor, timeline) -> this.wireUpOrPatchArrivalTimeline(zoneId, stationNode, stop, this.routeIdOrNull((GtfsStorageI.PlatformDescriptor)platformDescriptor), (NavigableMap<Integer, Integer>)timeline, (GtfsStorageI.PlatformDescriptor)platformDescriptor));
        });
    }

    private void addTrips(ZoneId zoneId, List<TripWithStopTimes> trips, int time, boolean frequencyBased) {
        ArrayList<TripWithStopTimeAndArrivalNode> arrivalNodes = new ArrayList<TripWithStopTimeAndArrivalNode>();
        for (TripWithStopTimes trip : trips) {
            GtfsRealtime.TripDescriptor.Builder tripDescriptor = GtfsRealtime.TripDescriptor.newBuilder().setTripId(trip.trip.trip_id).setRouteId(trip.trip.route_id);
            if (frequencyBased) {
                tripDescriptor = tripDescriptor.setStartTime(Entity.Writer.convertToGtfsTime(time));
            }
            this.addTrip(zoneId, time, arrivalNodes, trip, tripDescriptor.build(), frequencyBased);
        }
    }

    void addTrip(ZoneId zoneId, int time, List<TripWithStopTimeAndArrivalNode> arrivalNodes, TripWithStopTimes trip, GtfsRealtime.TripDescriptor tripDescriptor, boolean frequencyBased) {
        IntArrayList boardEdges = new IntArrayList();
        IntArrayList alightEdges = new IntArrayList();
        StopTime prev = null;
        int arrivalNode = -1;
        int arrivalTime = -1;
        int departureNode = -1;
        for (StopTime stopTime : trip.stopTimes) {
            int validityId;
            Stop stop = this.feed.stops.get(stopTime.stop_id);
            ++this.i;
            this.nodeAccess.setNode(arrivalNode, stop.stop_lat, stop.stop_lon);
            arrivalTime = stopTime.arrival_time + time;
            if (prev != null) {
                Stop fromStop = this.feed.stops.get(prev.stop_id);
                double distance = this.distCalc.calcDist(fromStop.stop_lat, fromStop.stop_lon, stop.stop_lat, stop.stop_lon);
                EdgeIteratorState edge = this.graph.edge(departureNode, arrivalNode);
                edge.setDistance(distance);
                edge.set(this.accessEnc, true).setReverse(this.accessEnc, false);
                edge.setName(stop.stop_name);
                this.setEdgeTypeAndClearDistance(edge, GtfsStorage.EdgeType.HOP);
                edge.set(this.timeEnc, stopTime.arrival_time - prev.departure_time);
                this.gtfsStorage.getStopSequences().put(edge.getEdge(), stopTime.stop_sequence);
            }
            Route route = this.feed.routes.get(trip.trip.route_id);
            GtfsStorageI.PlatformDescriptor platform = this.transfers.hasNoRouteSpecificDepartureTransferRules(stopTime.stop_id) ? GtfsStorageI.PlatformDescriptor.routeType(this.id, stopTime.stop_id, route.route_type) : GtfsStorageI.PlatformDescriptor.route(this.id, stopTime.stop_id, route.route_id);
            Map departureTimelines = this.departureTimelinesByStop.computeIfAbsent(stopTime.stop_id, s2 -> new HashMap());
            NavigableMap departureTimeline = departureTimelines.computeIfAbsent(platform, s2 -> new TreeMap());
            int departureTimelineNode = departureTimeline.computeIfAbsent((stopTime.departure_time + time) % 86400, t -> {
                int _departureTimelineNode = this.i++;
                this.nodeAccess.setNode(_departureTimelineNode, stop.stop_lat, stop.stop_lon);
                return _departureTimelineNode;
            });
            Map arrivalTimelines = this.arrivalTimelinesByStop.computeIfAbsent(stopTime.stop_id, s2 -> new HashMap());
            NavigableMap arrivalTimeline = arrivalTimelines.computeIfAbsent(platform, s2 -> new TreeMap());
            int arrivalTimelineNode = arrivalTimeline.computeIfAbsent((stopTime.arrival_time + time) % 86400, t -> {
                int _arrivalTimelineNode = this.i++;
                this.nodeAccess.setNode(_arrivalTimelineNode, stop.stop_lat, stop.stop_lon);
                return _arrivalTimelineNode;
            });
            ++this.i;
            this.nodeAccess.setNode(departureNode, stop.stop_lat, stop.stop_lon);
            int dayShift = stopTime.departure_time / 86400;
            GtfsStorage.Validity validOn = new GtfsStorage.Validity(this.getValidOn(trip.validOnDay, dayShift), zoneId, this.startDate);
            if (this.gtfsStorage.getOperatingDayPatterns().containsKey(validOn)) {
                validityId = this.gtfsStorage.getOperatingDayPatterns().get(validOn);
            } else {
                validityId = this.gtfsStorage.getOperatingDayPatterns().size();
                this.gtfsStorage.getOperatingDayPatterns().put(validOn, validityId);
            }
            EdgeIteratorState boardEdge = this.graph.edge(departureTimelineNode, departureNode);
            boardEdge.setName(this.getRouteName(this.feed, trip.trip));
            this.setEdgeTypeAndClearDistance(boardEdge, GtfsStorage.EdgeType.BOARD);
            boardEdge.set(this.accessEnc, true).setReverse(this.accessEnc, false);
            while (boardEdges.size() < stopTime.stop_sequence) {
                boardEdges.add(-1);
            }
            boardEdges.add(boardEdge.getEdge());
            this.gtfsStorage.getStopSequences().put(boardEdge.getEdge(), stopTime.stop_sequence);
            this.gtfsStorage.getTripDescriptors().put(boardEdge.getEdge(), tripDescriptor.toByteArray());
            boardEdge.set(this.validityIdEnc, validityId);
            boardEdge.set(this.ptEncodedValues.getTransfersEnc(), 1);
            EdgeIteratorState alightEdge = this.graph.edge(arrivalNode, arrivalTimelineNode);
            alightEdge.setName(this.getRouteName(this.feed, trip.trip));
            this.setEdgeTypeAndClearDistance(alightEdge, GtfsStorage.EdgeType.ALIGHT);
            alightEdge.set(this.accessEnc, true).setReverse(this.accessEnc, false);
            while (alightEdges.size() < stopTime.stop_sequence) {
                alightEdges.add(-1);
            }
            alightEdges.add(alightEdge.getEdge());
            this.gtfsStorage.getStopSequences().put(alightEdge.getEdge(), stopTime.stop_sequence);
            this.gtfsStorage.getTripDescriptors().put(alightEdge.getEdge(), tripDescriptor.toByteArray());
            alightEdge.set(this.validityIdEnc, validityId);
            EdgeIteratorState dwellEdge = this.graph.edge(arrivalNode, departureNode);
            dwellEdge.set(this.accessEnc, true).setReverse(this.accessEnc, false);
            dwellEdge.setName(this.getRouteName(this.feed, trip.trip));
            this.setEdgeTypeAndClearDistance(dwellEdge, GtfsStorage.EdgeType.DWELL);
            dwellEdge.set(this.timeEnc, stopTime.departure_time - stopTime.arrival_time);
            if (prev == null) {
                this.insertInboundBlockTransfers(arrivalNodes, tripDescriptor, departureNode, stopTime.departure_time + time, stopTime, stop, validOn, zoneId, platform);
            }
            prev = stopTime;
        }
        this.gtfsStorage.getBoardEdgesForTrip().put(GtfsStorage.tripKey(tripDescriptor, frequencyBased), boardEdges.toArray());
        this.gtfsStorage.getAlightEdgesForTrip().put(GtfsStorage.tripKey(tripDescriptor, frequencyBased), alightEdges.toArray());
        TripWithStopTimeAndArrivalNode tripWithStopTimeAndArrivalNode = new TripWithStopTimeAndArrivalNode();
        tripWithStopTimeAndArrivalNode.tripWithStopTimes = trip;
        tripWithStopTimeAndArrivalNode.arrivalNode = arrivalNode;
        tripWithStopTimeAndArrivalNode.arrivalTime = arrivalTime;
        arrivalNodes.add(tripWithStopTimeAndArrivalNode);
    }

    private void wireUpDepartureTimeline(int streetNode, Stop stop, NavigableMap<Integer, Integer> departureTimeline, int route_type, GtfsStorageI.PlatformDescriptor platformDescriptor) {
        LOGGER.debug("Creating timeline at stop {} for departure platform {}", (Object)stop.stop_id, (Object)platformDescriptor);
        this.nodeAccess.setNode(this.i++, stop.stop_lat, stop.stop_lon);
        int platformEnterNode = this.i - 1;
        EdgeIteratorState entryEdge = this.graph.edge(streetNode, platformEnterNode);
        entryEdge.set(this.accessEnc, true).setReverse(this.accessEnc, false);
        this.setEdgeTypeAndClearDistance(entryEdge, GtfsStorage.EdgeType.ENTER_PT);
        entryEdge.set(this.ptEncodedValues.getValidityIdEnc(), route_type);
        entryEdge.setName(stop.stop_name);
        this.gtfsStorage.getPlatformDescriptorByEdge().put(entryEdge.getEdge(), platformDescriptor);
        this.wireUpAndConnectTimeline(stop, platformEnterNode, departureTimeline, GtfsStorage.EdgeType.ENTER_TIME_EXPANDED_NETWORK, GtfsStorage.EdgeType.WAIT);
    }

    private void wireUpArrivalTimeline(int streetNode, Stop stop, NavigableMap<Integer, Integer> arrivalTimeline, int route_type, GtfsStorageI.PlatformDescriptor platformDescriptorIfStatic) {
        LOGGER.debug("Creating timeline at stop {} for arrival platform {}", (Object)stop.stop_id, (Object)platformDescriptorIfStatic);
        this.nodeAccess.setNode(this.i++, stop.stop_lat, stop.stop_lon);
        int platformExitNode = this.i - 1;
        EdgeIteratorState exitEdge = this.graph.edge(platformExitNode, streetNode);
        exitEdge.set(this.accessEnc, true).setReverse(this.accessEnc, false);
        this.setEdgeTypeAndClearDistance(exitEdge, GtfsStorage.EdgeType.EXIT_PT);
        exitEdge.set(this.ptEncodedValues.getValidityIdEnc(), route_type);
        exitEdge.setName(stop.stop_name);
        if (platformDescriptorIfStatic != null) {
            this.gtfsStorage.getPlatformDescriptorByEdge().put(exitEdge.getEdge(), platformDescriptorIfStatic);
        }
        this.wireUpAndConnectTimeline(stop, platformExitNode, arrivalTimeline, GtfsStorage.EdgeType.LEAVE_TIME_EXPANDED_NETWORK, GtfsStorage.EdgeType.WAIT_ARRIVAL);
    }

    private void wireUpOrPatchDepartureTimeline(ZoneId zoneId, int stationNode, Stop stop, NavigableMap<Integer, Integer> timeline, GtfsStorageI.PlatformDescriptor route) {
        int platformEnterNode = this.findPlatformNode(stationNode, route, GtfsStorage.EdgeType.ENTER_PT);
        if (platformEnterNode != -1) {
            this.patchDepartureTimeline(zoneId, timeline, platformEnterNode);
        } else {
            this.wireUpDepartureTimeline(stationNode, stop, timeline, 0, route);
        }
    }

    private void wireUpOrPatchArrivalTimeline(ZoneId zoneId, int stationNode, Stop stop, String routeId, NavigableMap<Integer, Integer> timeline, GtfsStorageI.PlatformDescriptor route) {
        int platformExitNode = this.findPlatformNode(stationNode, route, GtfsStorage.EdgeType.EXIT_PT);
        if (platformExitNode != -1) {
            this.patchArrivalTimeline(zoneId, timeline, platformExitNode);
        } else {
            this.wireUpArrivalTimeline(stationNode, stop, timeline, 0, null);
        }
        Optional<Transfer> withinStationTransfer = this.transfers.getTransfersFromStop(stop.stop_id, routeId).stream().filter(t -> t.from_stop_id.equals(stop.stop_id)).findAny();
        if (!withinStationTransfer.isPresent()) {
            this.insertOutboundTransfers(stop.stop_id, null, 0, timeline);
        }
        this.transfers.getTransfersFromStop(stop.stop_id, routeId).forEach(transfer -> this.insertOutboundTransfers(transfer.from_stop_id, transfer.from_route_id, transfer.min_transfer_time, timeline));
    }

    private void patchDepartureTimeline(ZoneId zoneId, NavigableMap<Integer, Integer> timeline, int platformNode) {
        NavigableMap<Integer, Integer> staticDepartureTimelineForRoute = this.findDepartureTimelineForPlatform(platformNode);
        timeline.forEach((time, node) -> {
            EdgeIteratorState edge;
            SortedMap tailMap;
            SortedMap headMap = staticDepartureTimelineForRoute.headMap((Integer)time);
            if (!headMap.isEmpty()) {
                EdgeIteratorState edge2 = this.graph.edge((Integer)headMap.get(headMap.lastKey()), (int)node);
                edge2.set(this.accessEnc, true).setReverse(this.accessEnc, false);
                this.setEdgeTypeAndClearDistance(edge2, GtfsStorage.EdgeType.WAIT);
                edge2.set(this.timeEnc, time - headMap.lastKey());
            }
            if (!(tailMap = staticDepartureTimelineForRoute.tailMap((Integer)time)).isEmpty()) {
                edge = this.graph.edge((int)node, (Integer)tailMap.get(tailMap.firstKey()));
                edge.set(this.accessEnc, true).setReverse(this.accessEnc, false);
                this.setEdgeTypeAndClearDistance(edge, GtfsStorage.EdgeType.WAIT);
                edge.set(this.timeEnc, tailMap.firstKey() - time);
            }
            edge = this.graph.edge(platformNode, (int)node);
            edge.set(this.accessEnc, true).setReverse(this.accessEnc, false);
            this.setEdgeTypeAndClearDistance(edge, GtfsStorage.EdgeType.ENTER_TIME_EXPANDED_NETWORK);
            edge.set(this.timeEnc, (int)time);
            this.setFeedIdWithTimezone(edge, new GtfsStorage.FeedIdWithTimezone(this.id, zoneId));
        });
    }

    private void patchArrivalTimeline(ZoneId zoneId, NavigableMap<Integer, Integer> timeline, int platformExitNode) {
        timeline.forEach((time, node) -> {
            EdgeIteratorState edge = this.graph.edge((int)node, platformExitNode);
            edge.set(this.accessEnc, true).setReverse(this.accessEnc, false);
            this.setEdgeTypeAndClearDistance(edge, GtfsStorage.EdgeType.LEAVE_TIME_EXPANDED_NETWORK);
            edge.set(this.timeEnc, (int)time);
            this.setFeedIdWithTimezone(edge, new GtfsStorage.FeedIdWithTimezone(this.id, zoneId));
        });
    }

    private NavigableMap<Integer, Integer> findDepartureTimelineForPlatform(int platformEnterNode) {
        TreeMap<Integer, Integer> result = new TreeMap<Integer, Integer>();
        if (platformEnterNode == -1) {
            return result;
        }
        EdgeIterator edge = this.graph.getBaseGraph().createEdgeExplorer(AccessFilter.outEdges(this.accessEnc)).setBaseNode(platformEnterNode);
        while (edge.next()) {
            if (edge.get(this.ptEncodedValues.getTypeEnc()) != GtfsStorage.EdgeType.ENTER_TIME_EXPANDED_NETWORK) continue;
            result.put(edge.get(this.timeEnc), edge.getAdjNode());
        }
        return result;
    }

    private int findPlatformNode(int stationNode, GtfsStorageI.PlatformDescriptor platformDescriptor, GtfsStorage.EdgeType edgeType) {
        AccessFilter filter;
        if (edgeType == GtfsStorage.EdgeType.ENTER_PT) {
            filter = AccessFilter.outEdges(this.accessEnc);
        } else if (edgeType == GtfsStorage.EdgeType.EXIT_PT) {
            filter = AccessFilter.inEdges(this.accessEnc);
        } else {
            throw new RuntimeException();
        }
        EdgeIterator i = this.graph.getBaseGraph().createEdgeExplorer(filter).setBaseNode(stationNode);
        while (i.next()) {
            if (i.get(this.ptEncodedValues.getTypeEnc()) != edgeType || !platformDescriptor.equals(this.gtfsStorage.getPlatformDescriptorByEdge().get(i.getEdge()))) continue;
            return i.getAdjNode();
        }
        return -1;
    }

    int addDelayedBoardEdge(ZoneId zoneId, GtfsRealtime.TripDescriptor tripDescriptor, int stopSequence, int departureTime, int departureNode, BitSet validOnDay) {
        int validityId;
        Trip trip = this.feed.trips.get(tripDescriptor.getTripId());
        StopTime stopTime = this.feed.stop_times.get(new Fun.Tuple2<String, Integer>(tripDescriptor.getTripId(), stopSequence));
        Stop stop = this.feed.stops.get(stopTime.stop_id);
        Map departureTimelineNodesByRoute = this.departureTimelinesByStop.computeIfAbsent(stopTime.stop_id, s2 -> new HashMap());
        NavigableMap departureTimelineNodes = departureTimelineNodesByRoute.computeIfAbsent(GtfsStorageI.PlatformDescriptor.route(this.id, stopTime.stop_id, trip.route_id), s2 -> new TreeMap());
        int departureTimelineNode = departureTimelineNodes.computeIfAbsent(departureTime % 86400, t -> {
            int _departureTimelineNode = this.i++;
            this.nodeAccess.setNode(_departureTimelineNode, stop.stop_lat, stop.stop_lon);
            return _departureTimelineNode;
        });
        int dayShift = departureTime / 86400;
        GtfsStorage.Validity validOn = new GtfsStorage.Validity(this.getValidOn(validOnDay, dayShift), zoneId, this.startDate);
        if (this.gtfsStorage.getOperatingDayPatterns().containsKey(validOn)) {
            validityId = this.gtfsStorage.getOperatingDayPatterns().get(validOn);
        } else {
            validityId = this.gtfsStorage.getOperatingDayPatterns().size();
            this.gtfsStorage.getOperatingDayPatterns().put(validOn, validityId);
        }
        EdgeIteratorState boardEdge = this.graph.edge(departureTimelineNode, departureNode);
        boardEdge.set(this.accessEnc, true).setReverse(this.accessEnc, false);
        boardEdge.setName(this.getRouteName(this.feed, trip));
        this.setEdgeTypeAndClearDistance(boardEdge, GtfsStorage.EdgeType.BOARD);
        this.gtfsStorage.getStopSequences().put(boardEdge.getEdge(), stopSequence);
        this.gtfsStorage.getTripDescriptors().put(boardEdge.getEdge(), tripDescriptor.toByteArray());
        boardEdge.set(this.validityIdEnc, validityId);
        boardEdge.set(this.ptEncodedValues.getTransfersEnc(), 1);
        return boardEdge.getEdge();
    }

    private void wireUpAndConnectTimeline(Stop toStop, int platformNode, NavigableMap<Integer, Integer> timeNodes, GtfsStorage.EdgeType timeExpandedNetworkEdgeType, GtfsStorage.EdgeType waitEdgeType) {
        ZoneId zoneId = ZoneId.of(this.feed.agency.values().iterator().next().agency_timezone);
        int time = 0;
        int prev = -1;
        for (Map.Entry e : timeNodes.descendingMap().entrySet()) {
            EdgeIteratorState timeExpandedNetworkEdge;
            if (timeExpandedNetworkEdgeType == GtfsStorage.EdgeType.LEAVE_TIME_EXPANDED_NETWORK) {
                timeExpandedNetworkEdge = this.graph.edge((Integer)e.getValue(), platformNode);
            } else if (timeExpandedNetworkEdgeType == GtfsStorage.EdgeType.ENTER_TIME_EXPANDED_NETWORK) {
                timeExpandedNetworkEdge = this.graph.edge(platformNode, (Integer)e.getValue());
            } else {
                throw new RuntimeException();
            }
            timeExpandedNetworkEdge.set(this.accessEnc, true).setReverse(this.accessEnc, false);
            timeExpandedNetworkEdge.setName(toStop.stop_name);
            this.setEdgeTypeAndClearDistance(timeExpandedNetworkEdge, timeExpandedNetworkEdgeType);
            timeExpandedNetworkEdge.set(this.timeEnc, (Integer)e.getKey());
            this.setFeedIdWithTimezone(timeExpandedNetworkEdge, new GtfsStorage.FeedIdWithTimezone(this.id, zoneId));
            if (prev != -1) {
                EdgeIteratorState waitEdge = this.graph.edge((Integer)e.getValue(), prev);
                waitEdge.set(this.accessEnc, true).setReverse(this.accessEnc, false);
                this.setEdgeTypeAndClearDistance(waitEdge, waitEdgeType);
                waitEdge.setName(toStop.stop_name);
                waitEdge.set(this.timeEnc, time - (Integer)e.getKey());
            }
            time = (Integer)e.getKey();
            prev = (Integer)e.getValue();
        }
        if (!timeNodes.isEmpty()) {
            EdgeIteratorState edge = this.graph.edge((Integer)timeNodes.get(timeNodes.lastKey()), (Integer)timeNodes.get(timeNodes.firstKey()));
            edge.set(this.accessEnc, true).setReverse(this.accessEnc, false);
            int rolloverTime = 86400 - (Integer)timeNodes.lastKey() + (Integer)timeNodes.firstKey();
            this.setEdgeTypeAndClearDistance(edge, GtfsStorage.EdgeType.OVERNIGHT);
            edge.setName(toStop.stop_name);
            edge.set(this.timeEnc, rolloverTime);
        }
    }

    private void setFeedIdWithTimezone(EdgeIteratorState leaveTimeExpandedNetworkEdge, GtfsStorage.FeedIdWithTimezone validOn) {
        int validityId;
        if (this.gtfsStorage.getWritableTimeZones().containsKey(validOn)) {
            validityId = this.gtfsStorage.getWritableTimeZones().get(validOn);
        } else {
            validityId = this.gtfsStorage.getWritableTimeZones().size();
            this.gtfsStorage.getWritableTimeZones().put(validOn, validityId);
        }
        leaveTimeExpandedNetworkEdge.set(this.validityIdEnc, validityId);
    }

    private void insertInboundBlockTransfers(List<TripWithStopTimeAndArrivalNode> arrivalNodes, GtfsRealtime.TripDescriptor tripDescriptor, int departureNode, int departureTime, StopTime stopTime, Stop stop, GtfsStorage.Validity validOn, ZoneId zoneId, GtfsStorageI.PlatformDescriptor platform) {
        BitSet accumulatorValidity = new BitSet(validOn.validity.size());
        accumulatorValidity.or(validOn.validity);
        ListIterator<TripWithStopTimeAndArrivalNode> li = arrivalNodes.listIterator(arrivalNodes.size());
        while (li.hasPrevious() && accumulatorValidity.cardinality() > 0) {
            int blockTransferValidityId;
            TripWithStopTimeAndArrivalNode lastTrip = li.previous();
            int dwellTime = departureTime - lastTrip.arrivalTime;
            if (dwellTime < 0 || !accumulatorValidity.intersects(lastTrip.tripWithStopTimes.validOnDay)) continue;
            BitSet blockTransferValidity = new BitSet(validOn.validity.size());
            blockTransferValidity.or(validOn.validity);
            blockTransferValidity.and(accumulatorValidity);
            GtfsStorage.Validity blockTransferValidOn = new GtfsStorage.Validity(blockTransferValidity, zoneId, this.startDate);
            if (this.gtfsStorage.getOperatingDayPatterns().containsKey(blockTransferValidOn)) {
                blockTransferValidityId = this.gtfsStorage.getOperatingDayPatterns().get(blockTransferValidOn);
            } else {
                blockTransferValidityId = this.gtfsStorage.getOperatingDayPatterns().size();
                this.gtfsStorage.getOperatingDayPatterns().put(blockTransferValidOn, blockTransferValidityId);
            }
            this.nodeAccess.setNode(this.i++, stop.stop_lat, stop.stop_lon);
            EdgeIteratorState transferEdge = this.graph.edge(lastTrip.arrivalNode, this.i - 1);
            transferEdge.set(this.accessEnc, true).setReverse(this.accessEnc, false);
            this.setEdgeTypeAndClearDistance(transferEdge, GtfsStorage.EdgeType.TRANSFER);
            transferEdge.set(this.timeEnc, dwellTime);
            this.gtfsStorage.getPlatformDescriptorByEdge().put(transferEdge.getEdge(), platform);
            EdgeIteratorState boardEdge = this.graph.edge(this.i - 1, departureNode);
            boardEdge.set(this.accessEnc, true).setReverse(this.accessEnc, false);
            this.setEdgeTypeAndClearDistance(boardEdge, GtfsStorage.EdgeType.BOARD);
            boardEdge.set(this.validityIdEnc, blockTransferValidityId);
            this.gtfsStorage.getStopSequences().put(boardEdge.getEdge(), stopTime.stop_sequence);
            this.gtfsStorage.getTripDescriptors().put(boardEdge.getEdge(), tripDescriptor.toByteArray());
            accumulatorValidity.andNot(lastTrip.tripWithStopTimes.validOnDay);
        }
    }

    private void insertOutboundTransfers(String toStopId, String toRouteId, int minimumTransferTime, NavigableMap<Integer, Integer> fromStopTimelineNodes) {
        int stationNode = this.gtfsStorage.getStationNodes().get(new GtfsStorage.FeedIdWithStopId(this.id, toStopId));
        EdgeIterator i = this.graph.getBaseGraph().createEdgeExplorer().setBaseNode(stationNode);
        while (i.next()) {
            GtfsStorage.EdgeType edgeType = i.get(this.ptEncodedValues.getTypeEnc());
            if (edgeType != GtfsStorage.EdgeType.ENTER_PT) continue;
            GtfsStorageI.PlatformDescriptor toPlatform = this.gtfsStorage.getPlatformDescriptorByEdge().get(i.getEdge());
            if (toRouteId != null && !(toPlatform instanceof GtfsStorageI.RouteTypePlatform) && !GtfsStorageI.PlatformDescriptor.route(this.id, toStopId, toRouteId).equals(toPlatform)) continue;
            fromStopTimelineNodes.forEach((time, e) -> {
                EdgeIterator j = this.graph.getBaseGraph().createEdgeExplorer().setBaseNode(i.getAdjNode());
                while (j.next()) {
                    int departureTime;
                    GtfsStorage.EdgeType edgeType2 = j.get(this.ptEncodedValues.getTypeEnc());
                    if (edgeType2 != GtfsStorage.EdgeType.ENTER_TIME_EXPANDED_NETWORK || (departureTime = j.get(this.timeEnc)) < time + minimumTransferTime) continue;
                    EdgeIteratorState edge = this.graph.edge((int)e, j.getAdjNode());
                    edge.set(this.accessEnc, true).setReverse(this.accessEnc, false);
                    this.setEdgeTypeAndClearDistance(edge, GtfsStorage.EdgeType.TRANSFER);
                    edge.set(this.timeEnc, departureTime - time);
                    this.gtfsStorage.getPlatformDescriptorByEdge().put(edge.getEdge(), toPlatform);
                    break;
                }
            });
        }
    }

    private String getRouteName(GTFSFeed feed, Trip trip) {
        Route route = feed.routes.get(trip.route_id);
        String routePart = route != null ? (route.route_long_name != null ? route.route_long_name : route.route_short_name) : "extra";
        return routePart + " " + trip.trip_headsign;
    }

    private void setEdgeTypeAndClearDistance(EdgeIteratorState edge, GtfsStorage.EdgeType edgeType) {
        edge.setDistance(0.0);
        edge.set(this.ptEncodedValues.getTypeEnc(), edgeType);
    }

    private BitSet getValidOn(BitSet validOnDay, int dayShift) {
        if (dayShift == 0) {
            return validOnDay;
        }
        BitSet bitSet = new BitSet(validOnDay.length() + 1);
        for (int i = 0; i < validOnDay.length(); ++i) {
            if (!validOnDay.get(i)) continue;
            bitSet.set(i + 1);
        }
        return bitSet;
    }

    private int routeType(GtfsStorageI.PlatformDescriptor platformDescriptor) {
        if (platformDescriptor instanceof GtfsStorageI.RouteTypePlatform) {
            return ((GtfsStorageI.RouteTypePlatform)platformDescriptor).route_type;
        }
        return this.feed.routes.get((Object)((GtfsStorageI.RoutePlatform)platformDescriptor).route_id).route_type;
    }

    private String routeIdOrNull(GtfsStorageI.PlatformDescriptor platformDescriptor) {
        if (platformDescriptor instanceof GtfsStorageI.RouteTypePlatform) {
            return null;
        }
        return ((GtfsStorageI.RoutePlatform)platformDescriptor).route_id;
    }

    private static class TripWithStopTimeAndArrivalNode {
        TripWithStopTimes tripWithStopTimes;
        int arrivalNode;
        int arrivalTime;

        private TripWithStopTimeAndArrivalNode() {
        }
    }

    static class TripWithStopTimes {
        Trip trip;
        List<StopTime> stopTimes;
        BitSet validOnDay;
        Set<Integer> cancelledArrivals;
        Set<Integer> cancelledDeparture;

        TripWithStopTimes(Trip trip, List<StopTime> stopTimes, BitSet validOnDay, Set<Integer> cancelledArrivals, Set<Integer> cancelledDepartures) {
            this.trip = trip;
            this.stopTimes = stopTimes;
            this.validOnDay = validOnDay;
            this.cancelledArrivals = cancelledArrivals;
            this.cancelledDeparture = cancelledDepartures;
        }
    }
}

