/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Transfer;
import com.graphhopper.GraphHopper;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.gtfs.GraphExplorer;
import com.graphhopper.gtfs.GtfsReader;
import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.GtfsStorageI;
import com.graphhopper.gtfs.Label;
import com.graphhopper.gtfs.MultiCriteriaLabelSetting;
import com.graphhopper.gtfs.PtEncodedValues;
import com.graphhopper.gtfs.RealtimeFeed;
import com.graphhopper.gtfs.Transfers;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.util.AccessFilter;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.RAMDirectory;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PMap;
import com.graphhopper.util.PointList;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphHopperGtfs
extends GraphHopper {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphHopperGtfs.class);
    private final GraphHopperConfig ghConfig;
    private GtfsStorage gtfsStorage;

    public GraphHopperGtfs(GraphHopperConfig ghConfig) {
        this.ghConfig = ghConfig;
        PtEncodedValues.createAndAddEncodedValues(this.getEncodingManagerBuilder());
    }

    @Override
    protected void importOSM() {
        if (this.ghConfig.has("datareader.file")) {
            super.importOSM();
        } else {
            this.getGraphHopperStorage().create(1000L);
        }
    }

    @Override
    protected LocationIndex createLocationIndex(Directory dir) {
        LocationIndexTree tmpIndex = new LocationIndexTree(this.getGraphHopperStorage(), dir);
        if (tmpIndex.loadExisting()) {
            return tmpIndex;
        }
        LocationIndexTree locationIndexTree = new LocationIndexTree(this.getGraphHopperStorage(), new RAMDirectory());
        if (!locationIndexTree.loadExisting()) {
            locationIndexTree.prepareIndex();
        }
        return locationIndexTree;
    }

    @Override
    protected void importPublicTransit() {
        this.gtfsStorage = new GtfsStorage(this.getGraphHopperStorage().getDirectory());
        if (!this.getGtfsStorage().loadExisting()) {
            this.ensureWriteAccess();
            this.getGtfsStorage().create();
            GraphHopperStorage graphHopperStorage = this.getGraphHopperStorage();
            LocationIndex streetNetworkIndex = this.getLocationIndex();
            try {
                int idx = 0;
                List<String> gtfsFiles = this.ghConfig.has("gtfs.file") ? Arrays.asList(this.ghConfig.getString("gtfs.file", "").split(",")) : Collections.emptyList();
                for (String gtfsFile : gtfsFiles) {
                    try {
                        this.getGtfsStorage().loadGtfsFromZipFile("gtfs_" + idx++, new ZipFile(gtfsFile));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.getGtfsStorage().postInit();
                HashMap<String, Transfers> allTransfers = new HashMap<String, Transfers>();
                HashMap<String, GtfsReader> allReaders = new HashMap<String, GtfsReader>();
                this.getGtfsStorage().getGtfsFeeds().forEach((id, gtfsFeed) -> {
                    Transfers transfers = new Transfers((GTFSFeed)gtfsFeed);
                    allTransfers.put((String)id, transfers);
                    GtfsReader gtfsReader = new GtfsReader((String)id, graphHopperStorage, graphHopperStorage.getEncodingManager(), this.getGtfsStorage(), streetNetworkIndex, transfers);
                    gtfsReader.connectStopsToStreetNetwork();
                    this.getType0TransferWithTimes((String)id, (GTFSFeed)gtfsFeed).forEach(t -> {
                        t.transfer.transfer_type = 2;
                        t.transfer.min_transfer_time = (int)(t.time / 1000L);
                        gtfsFeed.transfers.put(t.id, t.transfer);
                    });
                    LOGGER.info("Building transit graph for feed {}", (Object)gtfsFeed.feedId);
                    gtfsReader.buildPtNetwork();
                    allReaders.put((String)id, gtfsReader);
                });
                this.interpolateTransfers(allReaders, allTransfers);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while constructing transit network. Is your GTFS file valid? Please check log for possible causes.", e);
            }
            streetNetworkIndex.close();
            LocationIndexTree locationIndex = new LocationIndexTree(this.getGraphHopperStorage(), this.getGraphHopperStorage().getDirectory());
            PtEncodedValues ptEncodedValues = PtEncodedValues.fromEncodingManager(this.getEncodingManager());
            EnumEncodedValue<GtfsStorage.EdgeType> typeEnc = ptEncodedValues.getTypeEnc();
            locationIndex.prepareIndex(edgeState -> edgeState.get(typeEnc) == GtfsStorage.EdgeType.HIGHWAY);
            this.setLocationIndex(locationIndex);
        }
    }

    private void interpolateTransfers(HashMap<String, GtfsReader> readers, Map<String, Transfers> allTransfers) {
        LOGGER.info("Looking for transfers");
        int maxTransferWalkTimeSeconds = this.ghConfig.getInt("gtfs.max_transfer_interpolation_walk_time_seconds", 120);
        GraphHopperStorage graphHopperStorage = this.getGraphHopperStorage();
        QueryGraph queryGraph = QueryGraph.create((Graph)graphHopperStorage, Collections.emptyList());
        Weighting transferWeighting = this.createWeighting(this.getProfile("foot"), new PMap());
        PtEncodedValues ptEncodedValues = PtEncodedValues.fromEncodingManager(graphHopperStorage.getEncodingManager());
        GraphExplorer graphExplorer = new GraphExplorer(queryGraph, transferWeighting, ptEncodedValues, this.getGtfsStorage(), RealtimeFeed.empty(this.getGtfsStorage()), true, true, false, 5.0, false, 0);
        this.getGtfsStorage().getStationNodes().values().stream().distinct().forEach(stationNode -> {
            MultiCriteriaLabelSetting router = new MultiCriteriaLabelSetting(graphExplorer, ptEncodedValues, true, false, false, 0L, new ArrayList<Label>());
            router.setLimitStreetTime(Duration.ofSeconds(maxTransferWalkTimeSeconds).toMillis());
            Iterator iterator = router.calcLabels((int)stationNode, Instant.ofEpochMilli(0L)).iterator();
            while (iterator.hasNext()) {
                EdgeIteratorState edgeIteratorState;
                Label label = (Label)iterator.next();
                if (label.parent == null || (edgeIteratorState = graphHopperStorage.getEdgeIteratorState(label.edge, label.adjNode)).get(ptEncodedValues.getTypeEnc()) != GtfsStorage.EdgeType.EXIT_PT) continue;
                GtfsStorageI.PlatformDescriptor fromPlatformDescriptor = this.getGtfsStorage().getPlatformDescriptorByEdge().get(label.edge);
                Transfers transfers = (Transfers)allTransfers.get(fromPlatformDescriptor.feed_id);
                AccessFilter filter = AccessFilter.outEdges(ptEncodedValues.getAccessEnc());
                EdgeExplorer edgeExplorer = graphHopperStorage.createEdgeExplorer(filter);
                EdgeIterator edgeIterator = edgeExplorer.setBaseNode((int)stationNode);
                while (edgeIterator.next()) {
                    if (edgeIterator.get(ptEncodedValues.getTypeEnc()) != GtfsStorage.EdgeType.ENTER_PT) continue;
                    GtfsStorageI.PlatformDescriptor toPlatformDescriptor = this.getGtfsStorage().getPlatformDescriptorByEdge().get(edgeIterator.getEdge());
                    LOGGER.debug(fromPlatformDescriptor + " -> " + toPlatformDescriptor);
                    if (!toPlatformDescriptor.feed_id.equals(fromPlatformDescriptor.feed_id)) {
                        LOGGER.debug(" Different feed. Inserting transfer with " + (int)(label.streetTime / 1000L) + " s.");
                        GtfsReader toFeedReader = (GtfsReader)readers.get(toPlatformDescriptor.feed_id);
                        toFeedReader.insertTransferEdges(label.adjNode, (int)(label.streetTime / 1000L), toPlatformDescriptor);
                        continue;
                    }
                    List<Transfer> transfersToStop = transfers.getTransfersToStop(toPlatformDescriptor.stop_id, this.routeIdOrNull(toPlatformDescriptor));
                    if (!transfersToStop.stream().noneMatch(t -> t.from_stop_id.equals(fromPlatformDescriptor.stop_id))) continue;
                    GtfsReader toFeedReader = (GtfsReader)readers.get(toPlatformDescriptor.feed_id);
                    toFeedReader.insertTransferEdges(label.adjNode, (int)(label.streetTime / 1000L), toPlatformDescriptor);
                    LOGGER.debug("  Inserting transfer with " + (int)(label.streetTime / 1000L) + " s.");
                }
            }
        });
    }

    private String routeIdOrNull(GtfsStorageI.PlatformDescriptor platformDescriptor) {
        if (platformDescriptor instanceof GtfsStorageI.RouteTypePlatform) {
            return null;
        }
        return ((GtfsStorageI.RoutePlatform)platformDescriptor).route_id;
    }

    private Stream<TransferWithTime> getType0TransferWithTimes(String id, GTFSFeed gtfsFeed) {
        GraphHopperStorage graphHopperStorage = this.getGraphHopperStorage();
        RealtimeFeed realtimeFeed = RealtimeFeed.empty(this.getGtfsStorage());
        PtEncodedValues ptEncodedValues = PtEncodedValues.fromEncodingManager(graphHopperStorage.getEncodingManager());
        Weighting transferWeighting = this.createWeighting(this.getProfile("foot"), new PMap());
        return gtfsFeed.transfers.entrySet().parallelStream().filter(e -> ((Transfer)e.getValue()).transfer_type == 0).map(e -> {
            PointList points = new PointList(2, false);
            int fromnode = this.getGtfsStorage().getStationNodes().get(new GtfsStorage.FeedIdWithStopId(id, ((Transfer)e.getValue()).from_stop_id));
            Snap fromstation = new Snap(graphHopperStorage.getNodeAccess().getLat(fromnode), graphHopperStorage.getNodeAccess().getLon(fromnode));
            fromstation.setClosestNode(fromnode);
            points.add(graphHopperStorage.getNodeAccess().getLat(fromnode), graphHopperStorage.getNodeAccess().getLon(fromnode));
            int tonode = this.getGtfsStorage().getStationNodes().get(new GtfsStorage.FeedIdWithStopId(id, ((Transfer)e.getValue()).to_stop_id));
            Snap tostation = new Snap(graphHopperStorage.getNodeAccess().getLat(tonode), graphHopperStorage.getNodeAccess().getLon(tonode));
            tostation.setClosestNode(tonode);
            points.add(graphHopperStorage.getNodeAccess().getLat(tonode), graphHopperStorage.getNodeAccess().getLon(tonode));
            QueryGraph queryGraph = QueryGraph.create((Graph)graphHopperStorage, Collections.emptyList());
            GraphExplorer graphExplorer = new GraphExplorer(queryGraph, transferWeighting, ptEncodedValues, this.getGtfsStorage(), realtimeFeed, false, true, false, 5.0, false, 0);
            MultiCriteriaLabelSetting router = new MultiCriteriaLabelSetting(graphExplorer, ptEncodedValues, false, false, false, 0L, new ArrayList<Label>());
            Iterator iterator = router.calcLabels(fromnode, Instant.ofEpochMilli(0L)).iterator();
            Label solution = null;
            while (iterator.hasNext()) {
                Label label = (Label)iterator.next();
                if (tonode != label.adjNode) continue;
                solution = label;
                break;
            }
            if (solution == null) {
                throw new RuntimeException("Can't find a transfer walk route.");
            }
            TransferWithTime transferWithTime = new TransferWithTime();
            transferWithTime.id = (String)e.getKey();
            transferWithTime.transfer = (Transfer)e.getValue();
            transferWithTime.time = solution.currentTime;
            return transferWithTime;
        });
    }

    @Override
    public void close() {
        this.getGtfsStorage().close();
        super.close();
    }

    public GtfsStorage getGtfsStorage() {
        return this.gtfsStorage;
    }

    static class TransferWithTime {
        public String id;
        Transfer transfer;
        long time;

        TransferWithTime() {
        }
    }
}

