/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper;

import com.bedatadriven.jackson.datatype.jts.JtsModule;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.config.CHProfile;
import com.graphhopper.config.LMProfile;
import com.graphhopper.config.Profile;
import com.graphhopper.reader.dem.CGIARProvider;
import com.graphhopper.reader.dem.EdgeElevationInterpolator;
import com.graphhopper.reader.dem.ElevationProvider;
import com.graphhopper.reader.dem.GMTEDProvider;
import com.graphhopper.reader.dem.MultiSourceElevationProvider;
import com.graphhopper.reader.dem.SRTMGL1Provider;
import com.graphhopper.reader.dem.SRTMProvider;
import com.graphhopper.reader.dem.SkadiProvider;
import com.graphhopper.reader.dem.TileBasedElevationProvider;
import com.graphhopper.reader.osm.OSMReader;
import com.graphhopper.reader.osm.conditional.DateRangeParser;
import com.graphhopper.routing.DefaultWeightingFactory;
import com.graphhopper.routing.Router;
import com.graphhopper.routing.RouterConfig;
import com.graphhopper.routing.WeightingFactory;
import com.graphhopper.routing.ch.CHPreparationHandler;
import com.graphhopper.routing.ev.DefaultEncodedValueFactory;
import com.graphhopper.routing.ev.EncodedValueFactory;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RoadEnvironment;
import com.graphhopper.routing.ev.Subnetwork;
import com.graphhopper.routing.lm.LMConfig;
import com.graphhopper.routing.lm.LMPreparationHandler;
import com.graphhopper.routing.lm.LandmarkStorage;
import com.graphhopper.routing.subnetwork.PrepareRoutingSubnetworks;
import com.graphhopper.routing.util.AreaIndex;
import com.graphhopper.routing.util.CustomArea;
import com.graphhopper.routing.util.DefaultFlagEncoderFactory;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.FlagEncoderFactory;
import com.graphhopper.routing.util.countryrules.CountryRuleFactory;
import com.graphhopper.routing.util.parsers.DefaultTagParserFactory;
import com.graphhopper.routing.util.parsers.TagParserFactory;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.routing.weighting.custom.CustomProfile;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.DAType;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.GHDirectory;
import com.graphhopper.storage.GHLock;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.LockFactory;
import com.graphhopper.storage.NativeFSLockFactory;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.storage.SimpleFSLockFactory;
import com.graphhopper.storage.StorableProperties;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.util.Constants;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.JsonFeatureCollection;
import com.graphhopper.util.PMap;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.TranslationMap;
import com.graphhopper.util.Unzipper;
import com.graphhopper.util.details.PathDetailsBuilderFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphHopper {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Profile> profilesByName = new LinkedHashMap<String, Profile>();
    private final String fileLockName = "gh.lock";
    private final TranslationMap trMap = new TranslationMap().doImport();
    boolean removeZipped = true;
    private CountryRuleFactory countryRuleFactory = null;
    private String customAreasDirectory = "";
    private GraphHopperStorage ghStorage;
    private final EncodingManager.Builder emBuilder = new EncodingManager.Builder();
    private EncodingManager encodingManager;
    private int defaultSegmentSize = -1;
    private String ghLocation = "";
    private DAType dataAccessType = DAType.RAM_STORE;
    private boolean sortGraph = false;
    private boolean elevation = false;
    private LockFactory lockFactory = new NativeFSLockFactory();
    private boolean allowWrites = true;
    private boolean fullyLoaded = false;
    private boolean smoothElevation = false;
    private double longEdgeSamplingDistance = Double.MAX_VALUE;
    private final RouterConfig routerConfig = new RouterConfig();
    private LocationIndex locationIndex;
    private int preciseIndexResolution = 300;
    private int maxRegionSearch = 4;
    private int minNetworkSize = 200;
    private final LMPreparationHandler lmPreparationHandler = new LMPreparationHandler();
    private final CHPreparationHandler chPreparationHandler = new CHPreparationHandler();
    private String osmFile;
    private double dataReaderWayPointMaxDistance = 1.0;
    private int dataReaderWorkerThreads = 2;
    private ElevationProvider eleProvider = ElevationProvider.NOOP;
    private FlagEncoderFactory flagEncoderFactory = new DefaultFlagEncoderFactory();
    private EncodedValueFactory encodedValueFactory = new DefaultEncodedValueFactory();
    private TagParserFactory tagParserFactory = new DefaultTagParserFactory();
    private PathDetailsBuilderFactory pathBuilderFactory = new PathDetailsBuilderFactory();
    private static final String INTERPOLATION_KEY = "prepare.elevation_interpolation.done";

    public EncodingManager.Builder getEncodingManagerBuilder() {
        return this.emBuilder;
    }

    public EncodingManager getEncodingManager() {
        if (this.encodingManager == null) {
            throw new IllegalStateException("EncodingManager not yet build");
        }
        return this.encodingManager;
    }

    public ElevationProvider getElevationProvider() {
        return this.eleProvider;
    }

    public GraphHopper setElevationProvider(ElevationProvider eleProvider) {
        if (eleProvider == null || eleProvider == ElevationProvider.NOOP) {
            this.setElevation(false);
        } else {
            this.setElevation(true);
        }
        this.eleProvider = eleProvider;
        return this;
    }

    protected int getWorkerThreads() {
        return this.dataReaderWorkerThreads;
    }

    protected double getWayPointMaxDistance() {
        return this.dataReaderWayPointMaxDistance;
    }

    public GraphHopper setWayPointMaxDistance(double wayPointMaxDistance) {
        this.dataReaderWayPointMaxDistance = wayPointMaxDistance;
        return this;
    }

    public GraphHopper setPathDetailsBuilderFactory(PathDetailsBuilderFactory pathBuilderFactory) {
        this.pathBuilderFactory = pathBuilderFactory;
        return this;
    }

    public PathDetailsBuilderFactory getPathDetailsBuilderFactory() {
        return this.pathBuilderFactory;
    }

    public GraphHopper setPreciseIndexResolution(int precision) {
        this.ensureNotLoaded();
        this.preciseIndexResolution = precision;
        return this;
    }

    public GraphHopper setMinNetworkSize(int minNetworkSize) {
        this.ensureNotLoaded();
        this.minNetworkSize = minNetworkSize;
        return this;
    }

    public GraphHopper setStoreOnFlush(boolean storeOnFlush) {
        this.ensureNotLoaded();
        this.dataAccessType = storeOnFlush ? DAType.RAM_STORE : DAType.RAM;
        return this;
    }

    public GraphHopper setProfiles(Profile ... profiles) {
        return this.setProfiles(Arrays.asList(profiles));
    }

    public GraphHopper setProfiles(List<Profile> profiles) {
        if (!this.profilesByName.isEmpty()) {
            throw new IllegalArgumentException("Cannot initialize profiles multiple times");
        }
        if (this.encodingManager != null) {
            throw new IllegalArgumentException("Cannot set profiles after EncodingManager was built");
        }
        for (Profile profile : profiles) {
            Profile previous = this.profilesByName.put(profile.getName(), profile);
            if (previous == null) continue;
            throw new IllegalArgumentException("Profile names must be unique. Duplicate name: '" + profile.getName() + "'");
        }
        return this;
    }

    public List<Profile> getProfiles() {
        return new ArrayList<Profile>(this.profilesByName.values());
    }

    public Profile getProfile(String profileName) {
        return this.profilesByName.get(profileName);
    }

    public boolean hasElevation() {
        return this.elevation;
    }

    public GraphHopper setElevation(boolean includeElevation) {
        this.elevation = includeElevation;
        return this;
    }

    public GraphHopper setLongEdgeSamplingDistance(double longEdgeSamplingDistance) {
        this.longEdgeSamplingDistance = longEdgeSamplingDistance;
        return this;
    }

    public GraphHopper setElevationWayPointMaxDistance(double elevationWayPointMaxDistance) {
        this.routerConfig.setElevationWayPointMaxDistance(elevationWayPointMaxDistance);
        return this;
    }

    public String getGraphHopperLocation() {
        return this.ghLocation;
    }

    public GraphHopper setGraphHopperLocation(String ghLocation) {
        this.ensureNotLoaded();
        if (ghLocation == null) {
            throw new IllegalArgumentException("graphhopper location cannot be null");
        }
        this.ghLocation = ghLocation;
        return this;
    }

    public String getOSMFile() {
        return this.osmFile;
    }

    public GraphHopper setOSMFile(String osmFile) {
        this.ensureNotLoaded();
        if (Helper.isEmpty(osmFile)) {
            throw new IllegalArgumentException("OSM file cannot be empty.");
        }
        this.osmFile = osmFile;
        return this;
    }

    public GraphHopperStorage getGraphHopperStorage() {
        if (this.ghStorage == null) {
            throw new IllegalStateException("GraphHopper storage not initialized");
        }
        return this.ghStorage;
    }

    public void setGraphHopperStorage(GraphHopperStorage ghStorage) {
        this.ghStorage = ghStorage;
        this.setFullyLoaded();
    }

    public LocationIndex getLocationIndex() {
        if (this.locationIndex == null) {
            throw new IllegalStateException("LocationIndex not initialized");
        }
        return this.locationIndex;
    }

    protected void setLocationIndex(LocationIndex locationIndex) {
        this.locationIndex = locationIndex;
    }

    public GraphHopper setSortGraph(boolean sortGraph) {
        this.ensureNotLoaded();
        this.sortGraph = sortGraph;
        return this;
    }

    public boolean isAllowWrites() {
        return this.allowWrites;
    }

    public GraphHopper setAllowWrites(boolean allowWrites) {
        this.allowWrites = allowWrites;
        return this;
    }

    public TranslationMap getTranslationMap() {
        return this.trMap;
    }

    public GraphHopper setFlagEncoderFactory(FlagEncoderFactory factory) {
        this.flagEncoderFactory = factory;
        return this;
    }

    public EncodedValueFactory getEncodedValueFactory() {
        return this.encodedValueFactory;
    }

    public GraphHopper setEncodedValueFactory(EncodedValueFactory factory) {
        this.encodedValueFactory = factory;
        return this;
    }

    public TagParserFactory getTagParserFactory() {
        return this.tagParserFactory;
    }

    public GraphHopper setTagParserFactory(TagParserFactory factory) {
        this.tagParserFactory = factory;
        return this;
    }

    public GraphHopper setCustomAreasDirectory(String customAreasDirectory) {
        this.customAreasDirectory = customAreasDirectory;
        return this;
    }

    public String getCustomAreasDirectory() {
        return this.customAreasDirectory;
    }

    public GraphHopper setCountryRuleFactory(CountryRuleFactory countryRuleFactory) {
        this.countryRuleFactory = countryRuleFactory;
        return this;
    }

    public CountryRuleFactory getCountryRuleFactory() {
        return this.countryRuleFactory;
    }

    public GraphHopper init(GraphHopperConfig ghConfig) {
        String graphHopperFolder;
        if (ghConfig.has("routing.ch.disabling_allowed")) {
            throw new IllegalArgumentException("The 'routing.ch.disabling_allowed' configuration option is no longer supported");
        }
        if (ghConfig.has("routing.lm.disabling_allowed")) {
            throw new IllegalArgumentException("The 'routing.lm.disabling_allowed' configuration option is no longer supported");
        }
        if (ghConfig.has("osmreader.osm")) {
            throw new IllegalArgumentException("Instead of osmreader.osm use datareader.file, for other changes see CHANGELOG.md");
        }
        String tmpOsmFile = ghConfig.getString("datareader.file", "");
        if (!Helper.isEmpty(tmpOsmFile)) {
            this.osmFile = tmpOsmFile;
        }
        if (Helper.isEmpty(graphHopperFolder = ghConfig.getString("graph.location", "")) && Helper.isEmpty(this.ghLocation)) {
            if (Helper.isEmpty(this.osmFile)) {
                throw new IllegalArgumentException("If no graph.location is provided you need to specify an OSM file.");
            }
            graphHopperFolder = Helper.pruneFileEnd(this.osmFile) + "-gh";
        }
        if (ghConfig.has("country_rules.enabled")) {
            boolean countryRulesEnabled = ghConfig.getBool("country_rules.enabled", false);
            this.countryRuleFactory = countryRulesEnabled ? new CountryRuleFactory() : null;
        }
        this.customAreasDirectory = ghConfig.getString("custom_areas.directory", this.customAreasDirectory);
        this.setGraphHopperLocation(graphHopperFolder);
        this.defaultSegmentSize = ghConfig.getInt("graph.dataaccess.segment_size", this.defaultSegmentSize);
        String graphDATypeStr = ghConfig.getString("graph.dataaccess", "RAM_STORE");
        this.dataAccessType = DAType.fromString(graphDATypeStr);
        this.sortGraph = ghConfig.getBool("graph.do_sort", this.sortGraph);
        this.removeZipped = ghConfig.getBool("graph.remove_zipped", this.removeZipped);
        if (!ghConfig.getString("spatial_rules.location", "").isEmpty()) {
            throw new IllegalArgumentException("spatial_rules.location has been deprecated. Please use custom_areas.directory instead and read the documentation for custom areas.");
        }
        if (!ghConfig.getString("spatial_rules.borders_directory", "").isEmpty()) {
            throw new IllegalArgumentException("spatial_rules.borders_directory has been deprecated. Please use custom_areas.directory instead and read the documentation for custom areas.");
        }
        if (!ghConfig.getString("spatial_rules.max_bbox", "").isEmpty()) {
            throw new IllegalArgumentException("spatial_rules.max_bbox has been deprecated. There is no replacement, all custom areas will be considered.");
        }
        if (this.encodingManager != null) {
            throw new IllegalStateException("Cannot call init twice. EncodingManager was already initialized.");
        }
        this.emBuilder.setEnableInstructions(ghConfig.getBool("datareader.instructions", true));
        this.emBuilder.setPreferredLanguage(ghConfig.getString("datareader.preferred_language", ""));
        this.emBuilder.setDateRangeParser(DateRangeParser.createInstance(ghConfig.getString("datareader.date_range_parser_day", "")));
        this.setProfiles(ghConfig.getProfiles());
        this.encodingManager = this.buildEncodingManager(ghConfig);
        this.lockFactory = ghConfig.getString("graph.locktype", "native").equals("simple") ? new SimpleFSLockFactory() : new NativeFSLockFactory();
        this.smoothElevation = ghConfig.getBool("graph.elevation.smoothing", false);
        this.longEdgeSamplingDistance = ghConfig.getDouble("graph.elevation.long_edge_sampling_distance", Double.MAX_VALUE);
        this.setElevationWayPointMaxDistance(ghConfig.getDouble("graph.elevation.way_point_max_distance", Double.MAX_VALUE));
        ElevationProvider elevationProvider = GraphHopper.createElevationProvider(ghConfig);
        this.setElevationProvider(elevationProvider);
        if (this.longEdgeSamplingDistance < Double.MAX_VALUE && !elevationProvider.canInterpolate()) {
            this.logger.warn("Long edge sampling enabled, but bilinear interpolation disabled. See #1953");
        }
        this.minNetworkSize = ghConfig.getInt("prepare.min_network_size", this.minNetworkSize);
        this.chPreparationHandler.init(ghConfig);
        this.lmPreparationHandler.init(ghConfig);
        this.dataReaderWayPointMaxDistance = ghConfig.getDouble("routing.way_point_max_distance", this.dataReaderWayPointMaxDistance);
        this.dataReaderWorkerThreads = ghConfig.getInt("datareader.worker_threads", this.dataReaderWorkerThreads);
        this.preciseIndexResolution = ghConfig.getInt("index.high_resolution", this.preciseIndexResolution);
        this.maxRegionSearch = ghConfig.getInt("index.max_region_search", this.maxRegionSearch);
        this.routerConfig.setMaxVisitedNodes(ghConfig.getInt("routing.max_visited_nodes", this.routerConfig.getMaxVisitedNodes()));
        this.routerConfig.setMaxRoundTripRetries(ghConfig.getInt("routing.round_trip.max_retries", this.routerConfig.getMaxRoundTripRetries()));
        this.routerConfig.setNonChMaxWaypointDistance(ghConfig.getInt("routing.non_ch.max_waypoint_distance", this.routerConfig.getNonChMaxWaypointDistance()));
        int activeLandmarkCount = ghConfig.getInt("routing.lm.active_landmarks", Math.min(8, this.lmPreparationHandler.getLandmarks()));
        if (activeLandmarkCount > this.lmPreparationHandler.getLandmarks()) {
            throw new IllegalArgumentException("Default value for active landmarks " + activeLandmarkCount + " should be less or equal to landmark count of " + this.lmPreparationHandler.getLandmarks());
        }
        this.routerConfig.setActiveLandmarkCount(activeLandmarkCount);
        return this;
    }

    private EncodingManager buildEncodingManager(GraphHopperConfig ghConfig) {
        String flagEncodersStr = ghConfig.getString("graph.flag_encoders", "");
        String encodedValueStr = ghConfig.getString("graph.encoded_values", "");
        LinkedHashMap<String, String> flagEncoderMap = new LinkedHashMap<String, String>();
        HashMap<String, String> implicitFlagEncoderMap = new HashMap<String, String>();
        for (String encoderStr : Arrays.asList(flagEncodersStr.split(","))) {
            String key = encoderStr.split("\\|")[0];
            if (key.isEmpty()) continue;
            if (flagEncoderMap.containsKey(key)) {
                throw new IllegalArgumentException("FlagEncoder " + key + " needs to be unique");
            }
            flagEncoderMap.put(key, encoderStr);
        }
        if (this.profilesByName.isEmpty()) {
            throw new IllegalStateException("no profiles exist but assumed to create EncodingManager. E.g. provide them in GraphHopperConfig when calling GraphHopper.init");
        }
        for (Profile profile : this.profilesByName.values()) {
            this.emBuilder.add(Subnetwork.create(profile.getName()));
            if (flagEncoderMap.containsKey(profile.getVehicle()) || implicitFlagEncoderMap.containsKey(profile.getVehicle()) && !profile.isTurnCosts()) continue;
            implicitFlagEncoderMap.put(profile.getVehicle(), profile.getVehicle() + (profile.isTurnCosts() ? "|turn_costs=true" : ""));
        }
        flagEncoderMap.putAll(implicitFlagEncoderMap);
        flagEncoderMap.values().stream().forEach(s2 -> this.emBuilder.addIfAbsent(this.flagEncoderFactory, (String)s2));
        for (Iterator<Object> iterator : encodedValueStr.split(",")) {
            if (((String)((Object)iterator)).isEmpty()) continue;
            this.emBuilder.addIfAbsent(this.tagParserFactory, (String)((Object)iterator));
        }
        return this.emBuilder.build();
    }

    private static ElevationProvider createElevationProvider(GraphHopperConfig ghConfig) {
        String eleProviderStr = Helper.toLowerCase(ghConfig.getString("graph.elevation.provider", "noop"));
        if (ghConfig.has("graph.elevation.calcmean")) {
            throw new IllegalArgumentException("graph.elevation.calcmean is deprecated, use graph.elevation.interpolate");
        }
        String cacheDirStr = ghConfig.getString("graph.elevation.cache_dir", "");
        if (cacheDirStr.isEmpty() && ghConfig.has("graph.elevation.cachedir")) {
            throw new IllegalArgumentException("use graph.elevation.cache_dir not cachedir in configuration");
        }
        ElevationProvider elevationProvider = ElevationProvider.NOOP;
        if (eleProviderStr.equalsIgnoreCase("srtm")) {
            elevationProvider = new SRTMProvider(cacheDirStr);
        } else if (eleProviderStr.equalsIgnoreCase("cgiar")) {
            elevationProvider = new CGIARProvider(cacheDirStr);
        } else if (eleProviderStr.equalsIgnoreCase("gmted")) {
            elevationProvider = new GMTEDProvider(cacheDirStr);
        } else if (eleProviderStr.equalsIgnoreCase("srtmgl1")) {
            elevationProvider = new SRTMGL1Provider(cacheDirStr);
        } else if (eleProviderStr.equalsIgnoreCase("multi")) {
            elevationProvider = new MultiSourceElevationProvider(cacheDirStr);
        } else if (eleProviderStr.equalsIgnoreCase("skadi")) {
            elevationProvider = new SkadiProvider(cacheDirStr);
        }
        if (elevationProvider instanceof TileBasedElevationProvider) {
            TileBasedElevationProvider provider = (TileBasedElevationProvider)elevationProvider;
            String baseURL = ghConfig.getString("graph.elevation.base_url", "");
            if (baseURL.isEmpty() && ghConfig.has("graph.elevation.baseurl")) {
                throw new IllegalArgumentException("use graph.elevation.base_url not baseurl in configuration");
            }
            DAType elevationDAType = DAType.fromString(ghConfig.getString("graph.elevation.dataaccess", "MMAP"));
            boolean interpolate = ghConfig.has("graph.elevation.interpolate") ? "bilinear".equals(ghConfig.getString("graph.elevation.interpolate", "none")) : ghConfig.getBool("graph.elevation.calc_mean", false);
            boolean removeTempElevationFiles = ghConfig.getBool("graph.elevation.cgiar.clear", true);
            removeTempElevationFiles = ghConfig.getBool("graph.elevation.clear", removeTempElevationFiles);
            provider.setAutoRemoveTemporaryFiles(removeTempElevationFiles).setInterpolate(interpolate).setDAType(elevationDAType);
            if (!baseURL.isEmpty()) {
                provider.setBaseURL(baseURL);
            }
        }
        return elevationProvider;
    }

    private void printInfo() {
        this.logger.info("version " + Constants.VERSION + "|" + Constants.BUILD_DATE + " (" + Constants.getVersions() + ")");
        if (this.ghStorage != null) {
            this.logger.info("graph " + this.ghStorage.toString() + ", details:" + this.ghStorage.toDetailsString());
        }
    }

    public GraphHopper importOrLoad() {
        if (!this.load(this.ghLocation)) {
            this.printInfo();
            this.process(this.ghLocation, false);
        } else {
            this.printInfo();
        }
        return this;
    }

    public void importAndClose() {
        if (!this.load(this.ghLocation)) {
            this.printInfo();
            this.process(this.ghLocation, true);
        } else {
            this.printInfo();
            this.logger.info("Graph already imported into " + this.ghLocation);
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(String graphHopperLocation, boolean closeEarly) {
        this.setGraphHopperLocation(graphHopperLocation);
        GHLock lock = null;
        try {
            if (this.ghStorage == null) {
                throw new IllegalStateException("GraphHopperStorage must be initialized before starting the import");
            }
            if (this.ghStorage.getDirectory().getDefaultType().isStoring()) {
                this.lockFactory.setLockDir(new File(graphHopperLocation));
                lock = this.lockFactory.create("gh.lock", true);
                if (!lock.tryLock()) {
                    throw new RuntimeException("To avoid multiple writers we need to obtain a write lock but it failed. In " + graphHopperLocation, lock.getObtainFailedReason());
                }
            }
            this.ensureWriteAccess();
            this.importOSM();
            this.cleanUp();
            this.postProcessing(closeEarly);
            this.flush();
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
    }

    protected void importOSM() {
        if (this.osmFile == null) {
            throw new IllegalStateException("Couldn't load from existing folder: " + this.ghLocation + " but also cannot use file for DataReader as it wasn't specified!");
        }
        List<CustomArea> customAreas = GHUtility.readCountries();
        if (Helper.isEmpty(this.customAreasDirectory)) {
            this.logger.info("No custom areas are used, custom_areas.directory not given");
        } else {
            this.logger.info("Creating custom area index, reading custom areas from: '" + this.customAreasDirectory + "'");
            customAreas.addAll(this.readCustomAreas());
        }
        AreaIndex<CustomArea> areaIndex = new AreaIndex<CustomArea>(customAreas);
        this.logger.info("start creating graph from " + this.osmFile);
        OSMReader reader = new OSMReader(this.ghStorage).setFile(this._getOSMFile()).setAreaIndex(areaIndex).setElevationProvider(this.eleProvider).setWorkerThreads(this.dataReaderWorkerThreads).setWayPointMaxDistance(this.dataReaderWayPointMaxDistance).setWayPointElevationMaxDistance(this.routerConfig.getElevationWayPointMaxDistance()).setSmoothElevation(this.smoothElevation).setLongEdgeSamplingDistance(this.longEdgeSamplingDistance).setCountryRuleFactory(this.countryRuleFactory);
        this.logger.info("using " + this.ghStorage.toString() + ", memory:" + Helper.getMemInfo());
        try {
            reader.readGraph();
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot read file " + this.getOSMFile(), ex);
        }
        DateFormat f = Helper.createFormatter();
        this.ghStorage.getProperties().put("datareader.import.date", f.format(new Date()));
        if (reader.getDataDate() != null) {
            this.ghStorage.getProperties().put("datareader.data.date", f.format(reader.getDataDate()));
        }
    }

    private List<CustomArea> readCustomAreas() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JtsModule());
        Path bordersDirectory = Paths.get(this.customAreasDirectory, new String[0]);
        ArrayList<JsonFeatureCollection> jsonFeatureCollections = new ArrayList<JsonFeatureCollection>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(bordersDirectory, "*.{geojson,json}");){
            for (Path borderFile : stream) {
                BufferedReader reader = Files.newBufferedReader(borderFile, StandardCharsets.UTF_8);
                Throwable throwable = null;
                try {
                    JsonFeatureCollection jsonFeatureCollection = objectMapper.readValue((Reader)reader, JsonFeatureCollection.class);
                    jsonFeatureCollections.add(jsonFeatureCollection);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return jsonFeatureCollections.stream().flatMap(j -> j.getFeatures().stream()).map(CustomArea::fromJsonFeature).collect(Collectors.toList());
    }

    protected File _getOSMFile() {
        return new File(this.osmFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(String graphHopperFolder) {
        List<CHConfig> chConfigs;
        if (Helper.isEmpty(graphHopperFolder)) {
            throw new IllegalStateException("GraphHopperLocation is not specified. Call setGraphHopperLocation or init before");
        }
        if (this.fullyLoaded) {
            throw new IllegalStateException("graph is already successfully loaded");
        }
        File tmpFileOrFolder = new File(graphHopperFolder);
        if (!tmpFileOrFolder.isDirectory() && tmpFileOrFolder.exists()) {
            throw new IllegalArgumentException("GraphHopperLocation cannot be an existing file. Has to be either non-existing or a folder.");
        }
        File compressed = new File(graphHopperFolder + ".ghz");
        if (compressed.exists() && !compressed.isDirectory()) {
            try {
                new Unzipper().unzip(compressed.getAbsolutePath(), graphHopperFolder, this.removeZipped);
            }
            catch (IOException ex) {
                throw new RuntimeException("Couldn't extract file " + compressed.getAbsolutePath() + " to " + graphHopperFolder, ex);
            }
        }
        this.setGraphHopperLocation(graphHopperFolder);
        if (!this.allowWrites && this.dataAccessType.isMMap()) {
            this.dataAccessType = DAType.MMAP_RO;
        }
        if (this.encodingManager == null) {
            StorableProperties properties = new StorableProperties(new GHDirectory(this.ghLocation, this.dataAccessType));
            this.encodingManager = properties.loadExisting() ? EncodingManager.create(this.emBuilder, this.encodedValueFactory, this.flagEncoderFactory, properties) : this.buildEncodingManager(new GraphHopperConfig());
        }
        GHDirectory dir = new GHDirectory(this.ghLocation, this.dataAccessType);
        this.ghStorage = new GraphHopperStorage(dir, this.encodingManager, this.hasElevation(), this.encodingManager.needsTurnCostsSupport(), this.defaultSegmentSize);
        this.checkProfilesConsistency();
        if (this.lmPreparationHandler.isEnabled()) {
            this.initLMPreparationHandler();
        }
        if (this.chPreparationHandler.isEnabled()) {
            this.initCHPreparationHandler();
            chConfigs = this.chPreparationHandler.getCHConfigs();
        } else {
            chConfigs = Collections.emptyList();
        }
        this.ghStorage.addCHGraphs(chConfigs);
        if (!new File(graphHopperFolder).exists()) {
            return false;
        }
        GHLock lock = null;
        try {
            if (this.ghStorage.getDirectory().getDefaultType().isStoring() && this.isAllowWrites()) {
                this.lockFactory.setLockDir(new File(this.ghLocation));
                lock = this.lockFactory.create("gh.lock", false);
                if (!lock.tryLock()) {
                    throw new RuntimeException("To avoid reading partial data we need to obtain the read lock but it failed. In " + this.ghLocation, lock.getObtainFailedReason());
                }
            }
            if (!this.ghStorage.loadExisting()) {
                boolean bl = false;
                return bl;
            }
            this.postProcessing(false);
            this.setFullyLoaded();
            boolean bl = true;
            return bl;
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
    }

    private void checkProfilesConsistency() {
        EncodingManager encodingManager = this.getEncodingManager();
        for (Profile profile : this.profilesByName.values()) {
            if (!encodingManager.hasEncoder(profile.getVehicle())) {
                throw new IllegalArgumentException("Unknown vehicle '" + profile.getVehicle() + "' in profile: " + profile + ". Make sure all vehicles used in 'profiles' exist in 'graph.flag_encoders'");
            }
            FlagEncoder encoder = encodingManager.getEncoder(profile.getVehicle());
            if (profile.isTurnCosts() && !encoder.supportsTurnCosts()) {
                throw new IllegalArgumentException("The profile '" + profile.getName() + "' was configured with 'turn_costs=true', but the corresponding vehicle '" + profile.getVehicle() + "' does not support turn costs.\nYou need to add `|turn_costs=true` to the vehicle in `graph.flag_encoders`");
            }
            try {
                this.createWeighting(profile, new PMap());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Could not create weighting for profile: '" + profile.getName() + "'.\nProfile: " + profile + "\nError: " + e.getMessage());
            }
            if (!(profile instanceof CustomProfile)) continue;
            CustomModel customModel = ((CustomProfile)profile).getCustomModel();
            if (customModel == null) {
                throw new IllegalArgumentException("custom model for profile '" + profile.getName() + "' was empty");
            }
            if ("custom".equals(profile.getWeighting())) continue;
            throw new IllegalArgumentException("profile '" + profile.getName() + "' has a custom model but weighting=" + profile.getWeighting() + " was defined");
        }
        LinkedHashSet<String> chProfileSet = new LinkedHashSet<String>(this.chPreparationHandler.getCHProfiles().size());
        for (CHProfile chProfile : this.chPreparationHandler.getCHProfiles()) {
            boolean added = chProfileSet.add(chProfile.getProfile());
            if (!added) {
                throw new IllegalArgumentException("Duplicate CH reference to profile '" + chProfile.getProfile() + "'");
            }
            if (this.profilesByName.containsKey(chProfile.getProfile())) continue;
            throw new IllegalArgumentException("CH profile references unknown profile '" + chProfile.getProfile() + "'");
        }
        LinkedHashMap<String, LMProfile> linkedHashMap = new LinkedHashMap<String, LMProfile>(this.lmPreparationHandler.getLMProfiles().size());
        for (LMProfile lmProfile : this.lmPreparationHandler.getLMProfiles()) {
            LMProfile previous = linkedHashMap.put(lmProfile.getProfile(), lmProfile);
            if (previous != null) {
                throw new IllegalArgumentException("Multiple LM profiles are using the same profile '" + lmProfile.getProfile() + "'");
            }
            if (!this.profilesByName.containsKey(lmProfile.getProfile())) {
                throw new IllegalArgumentException("LM profile references unknown profile '" + lmProfile.getProfile() + "'");
            }
            if (!lmProfile.usesOtherPreparation() || this.profilesByName.containsKey(lmProfile.getPreparationProfile())) continue;
            throw new IllegalArgumentException("LM profile references unknown preparation profile '" + lmProfile.getPreparationProfile() + "'");
        }
        for (LMProfile lmProfile : this.lmPreparationHandler.getLMProfiles()) {
            if (lmProfile.usesOtherPreparation() && !linkedHashMap.containsKey(lmProfile.getPreparationProfile())) {
                throw new IllegalArgumentException("Unknown LM preparation profile '" + lmProfile.getPreparationProfile() + "' in LM profile '" + lmProfile.getProfile() + "' cannot be used as preparation_profile");
            }
            if (!lmProfile.usesOtherPreparation() || !((LMProfile)linkedHashMap.get(lmProfile.getPreparationProfile())).usesOtherPreparation()) continue;
            throw new IllegalArgumentException("Cannot use '" + lmProfile.getPreparationProfile() + "' as preparation_profile for LM profile '" + lmProfile.getProfile() + "', because it uses another profile for preparation itself.");
        }
    }

    public final CHPreparationHandler getCHPreparationHandler() {
        return this.chPreparationHandler;
    }

    private void initCHPreparationHandler() {
        if (this.chPreparationHandler.hasCHConfigs()) {
            return;
        }
        for (CHProfile chProfile : this.chPreparationHandler.getCHProfiles()) {
            Profile profile = this.profilesByName.get(chProfile.getProfile());
            if (profile.isTurnCosts()) {
                this.chPreparationHandler.addCHConfig(CHConfig.edgeBased(profile.getName(), this.createWeighting(profile, new PMap())));
                continue;
            }
            this.chPreparationHandler.addCHConfig(CHConfig.nodeBased(profile.getName(), this.createWeighting(profile, new PMap())));
        }
    }

    public final LMPreparationHandler getLMPreparationHandler() {
        return this.lmPreparationHandler;
    }

    private void initLMPreparationHandler() {
        if (this.lmPreparationHandler.hasLMProfiles()) {
            return;
        }
        for (LMProfile lmProfile : this.lmPreparationHandler.getLMProfiles()) {
            if (lmProfile.usesOtherPreparation()) continue;
            Profile profile = this.profilesByName.get(lmProfile.getProfile());
            Weighting weighting = this.createWeighting(profile, new PMap(), true);
            this.lmPreparationHandler.addLMConfig(new LMConfig(profile.getName(), weighting));
        }
    }

    public final void postProcessing() {
        this.postProcessing(false);
    }

    protected void postProcessing(boolean closeEarly) {
        if (this.sortGraph) {
            if (this.ghStorage.isCHPossible() && this.isCHPrepared()) {
                throw new IllegalArgumentException("Sorting a prepared CH is not possible yet. See #12");
            }
            GraphHopperStorage newGraph = GHUtility.newStorage(this.ghStorage);
            GHUtility.sortDFS(this.ghStorage, newGraph);
            this.logger.info("graph sorted (" + Helper.getMemInfo() + ")");
            this.ghStorage = newGraph;
        }
        if (!this.hasInterpolated() && this.hasElevation()) {
            this.interpolateBridgesTunnelsAndFerries();
        }
        this.initLocationIndex();
        this.importPublicTransit();
        if (this.lmPreparationHandler.isEnabled()) {
            this.lmPreparationHandler.createPreparations(this.ghStorage, this.locationIndex);
        }
        this.loadOrPrepareLM(closeEarly);
        if (this.chPreparationHandler.isEnabled()) {
            this.chPreparationHandler.createPreparations(this.ghStorage);
        }
        if (this.isCHPrepared()) {
            for (CHProfile profile : this.chPreparationHandler.getCHProfiles()) {
                if (this.getProfileVersion(profile.getProfile()).equals("" + this.profilesByName.get(profile.getProfile()).getVersion())) continue;
                throw new IllegalArgumentException("CH preparation of " + profile.getProfile() + " already exists in storage and doesn't match configuration");
            }
        } else {
            this.prepareCH(closeEarly);
        }
    }

    protected void importPublicTransit() {
    }

    private boolean hasInterpolated() {
        return "true".equals(this.ghStorage.getProperties().get(INTERPOLATION_KEY));
    }

    void interpolateBridgesTunnelsAndFerries() {
        if (this.ghStorage.getEncodingManager().hasEncodedValue("road_environment")) {
            EnumEncodedValue<RoadEnvironment> roadEnvEnc = this.ghStorage.getEncodingManager().getEnumEncodedValue("road_environment", RoadEnvironment.class);
            StopWatch sw = new StopWatch().start();
            new EdgeElevationInterpolator(this.ghStorage, roadEnvEnc, RoadEnvironment.TUNNEL).execute();
            float tunnel = sw.stop().getSeconds();
            sw = new StopWatch().start();
            new EdgeElevationInterpolator(this.ghStorage, roadEnvEnc, RoadEnvironment.BRIDGE).execute();
            float bridge = sw.stop().getSeconds();
            sw = new StopWatch().start();
            new EdgeElevationInterpolator(this.ghStorage, roadEnvEnc, RoadEnvironment.FERRY).execute();
            this.ghStorage.getProperties().put(INTERPOLATION_KEY, true);
            this.logger.info("Bridge interpolation " + (int)bridge + "s, tunnel interpolation " + (int)tunnel + "s, ferry interpolation " + (int)sw.stop().getSeconds() + "s");
        }
    }

    public final Weighting createWeighting(Profile profile, PMap hints) {
        return this.createWeighting(profile, hints, false);
    }

    public final Weighting createWeighting(Profile profile, PMap hints, boolean disableTurnCosts) {
        return this.createWeightingFactory().createWeighting(profile, hints, disableTurnCosts);
    }

    protected WeightingFactory createWeightingFactory() {
        return new DefaultWeightingFactory(this.ghStorage, this.getEncodingManager());
    }

    public GHResponse route(GHRequest request) {
        return this.createRouter().route(request);
    }

    private Router createRouter() {
        if (this.ghStorage == null || !this.fullyLoaded) {
            throw new IllegalStateException("Do a successful call to load or importOrLoad before routing");
        }
        if (this.ghStorage.isClosed()) {
            throw new IllegalStateException("You need to create a new GraphHopper instance as it is already closed");
        }
        if (this.locationIndex == null) {
            throw new IllegalStateException("Location index not initialized");
        }
        LinkedHashMap<String, RoutingCHGraph> chGraphs = new LinkedHashMap<String, RoutingCHGraph>();
        for (CHProfile chProfile : this.chPreparationHandler.getCHProfiles()) {
            String chGraphName = this.chPreparationHandler.getPreparation(chProfile.getProfile()).getCHConfig().getName();
            chGraphs.put(chProfile.getProfile(), this.ghStorage.getRoutingCHGraph(chGraphName));
        }
        LinkedHashMap<String, LandmarkStorage> landmarks = new LinkedHashMap<String, LandmarkStorage>();
        for (LMProfile lmp : this.lmPreparationHandler.getLMProfiles()) {
            landmarks.put(lmp.getProfile(), lmp.usesOtherPreparation() ? this.lmPreparationHandler.getPreparation(lmp.getPreparationProfile()).getLandmarkStorage() : this.lmPreparationHandler.getPreparation(lmp.getProfile()).getLandmarkStorage());
        }
        return this.doCreateRouter(this.ghStorage, this.locationIndex, this.profilesByName, this.pathBuilderFactory, this.trMap, this.routerConfig, this.createWeightingFactory(), chGraphs, landmarks);
    }

    protected Router doCreateRouter(GraphHopperStorage ghStorage, LocationIndex locationIndex, Map<String, Profile> profilesByName, PathDetailsBuilderFactory pathBuilderFactory, TranslationMap trMap, RouterConfig routerConfig, WeightingFactory weightingFactory, Map<String, RoutingCHGraph> chGraphs, Map<String, LandmarkStorage> landmarks) {
        return new Router(ghStorage, locationIndex, profilesByName, pathBuilderFactory, trMap, routerConfig, weightingFactory, chGraphs, landmarks);
    }

    protected LocationIndex createLocationIndex(Directory dir) {
        LocationIndexTree tmpIndex = new LocationIndexTree(this.ghStorage, dir);
        tmpIndex.setResolution(this.preciseIndexResolution);
        tmpIndex.setMaxRegionSearch(this.maxRegionSearch);
        if (!tmpIndex.loadExisting()) {
            this.ensureWriteAccess();
            tmpIndex.prepareIndex();
        }
        return tmpIndex;
    }

    protected void initLocationIndex() {
        if (this.locationIndex != null) {
            throw new IllegalStateException("Cannot initialize locationIndex twice!");
        }
        this.locationIndex = this.createLocationIndex(this.ghStorage.getDirectory());
    }

    private boolean isCHPrepared() {
        return "true".equals(this.ghStorage.getProperties().get("prepare.ch.done"));
    }

    private String getProfileVersion(String profile) {
        return this.ghStorage.getProperties().get("graph.profiles." + profile + ".version");
    }

    private void setProfileVersion(String profile, int version) {
        this.ghStorage.getProperties().put("graph.profiles." + profile + ".version", version);
    }

    protected void prepareCH(boolean closeEarly) {
        for (CHProfile profile : this.chPreparationHandler.getCHProfiles()) {
            if (this.getProfileVersion(profile.getProfile()).isEmpty() || this.getProfileVersion(profile.getProfile()).equals("" + this.profilesByName.get(profile.getProfile()).getVersion())) continue;
            throw new IllegalArgumentException("CH preparation of " + profile.getProfile() + " already exists in storage and doesn't match configuration");
        }
        boolean chEnabled = this.chPreparationHandler.isEnabled();
        if (chEnabled) {
            this.ensureWriteAccess();
            if (closeEarly) {
                this.locationIndex.close();
                boolean includesCustomProfiles = this.getProfiles().stream().anyMatch(p -> p instanceof CustomProfile);
                if (!includesCustomProfiles) {
                    this.ghStorage.flushAndCloseEarly();
                }
            }
            this.ghStorage.freeze();
            this.chPreparationHandler.prepare(this.ghStorage.getProperties(), closeEarly);
            this.ghStorage.getProperties().put("prepare.ch.done", true);
            for (CHProfile profile : this.chPreparationHandler.getCHProfiles()) {
                this.setProfileVersion(profile.getProfile(), this.profilesByName.get(profile.getProfile()).getVersion());
            }
        }
    }

    protected void loadOrPrepareLM(boolean closeEarly) {
        if (!this.lmPreparationHandler.isEnabled() || this.lmPreparationHandler.getPreparations().isEmpty()) {
            return;
        }
        for (LMProfile profile : this.lmPreparationHandler.getLMProfiles()) {
            if (this.getProfileVersion(profile.getProfile()).isEmpty() || this.getProfileVersion(profile.getProfile()).equals("" + this.profilesByName.get(profile.getProfile()).getVersion())) continue;
            throw new IllegalArgumentException("LM preparation of " + profile.getProfile() + " already exists in storage and doesn't match configuration");
        }
        this.ensureWriteAccess();
        this.ghStorage.freeze();
        if (this.lmPreparationHandler.loadOrDoWork(this.ghStorage.getProperties(), closeEarly)) {
            this.ghStorage.getProperties().put("prepare.lm.done", true);
            for (LMProfile profile : this.lmPreparationHandler.getLMProfiles()) {
                this.setProfileVersion(profile.getProfile(), this.profilesByName.get(profile.getProfile()).getVersion());
            }
        }
    }

    protected void cleanUp() {
        PrepareRoutingSubnetworks preparation = new PrepareRoutingSubnetworks(this.ghStorage, this.buildSubnetworkRemovalJobs());
        preparation.setMinNetworkSize(this.minNetworkSize);
        preparation.doWork();
        this.logger.info("nodes: " + Helper.nf(this.ghStorage.getNodes()) + ", edges: " + Helper.nf(this.ghStorage.getEdges()));
    }

    private List<PrepareRoutingSubnetworks.PrepareJob> buildSubnetworkRemovalJobs() {
        ArrayList<PrepareRoutingSubnetworks.PrepareJob> jobs = new ArrayList<PrepareRoutingSubnetworks.PrepareJob>();
        for (Profile profile : this.profilesByName.values()) {
            Weighting weighting = this.createWeighting(profile, new PMap().putObject("u_turn_costs", 0));
            jobs.add(new PrepareRoutingSubnetworks.PrepareJob(this.encodingManager.getBooleanEncodedValue(Subnetwork.key(profile.getName())), weighting));
        }
        return jobs;
    }

    protected void flush() {
        this.logger.info("flushing graph " + this.ghStorage.toString() + ", details:" + this.ghStorage.toDetailsString() + ", " + Helper.getMemInfo() + ")");
        this.ghStorage.flush();
        this.logger.info("flushed graph " + Helper.getMemInfo() + ")");
        this.setFullyLoaded();
    }

    public void close() {
        if (this.ghStorage != null) {
            this.ghStorage.close();
        }
        if (this.locationIndex != null) {
            this.locationIndex.close();
        }
        try {
            this.lockFactory.forceRemove("gh.lock", true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clean() {
        if (this.getGraphHopperLocation().isEmpty()) {
            throw new IllegalStateException("Cannot clean GraphHopper without specified graphHopperLocation");
        }
        File folder = new File(this.getGraphHopperLocation());
        Helper.removeDir(folder);
    }

    protected void ensureNotLoaded() {
        if (this.fullyLoaded) {
            throw new IllegalStateException("No configuration changes are possible after loading the graph");
        }
    }

    protected void ensureWriteAccess() {
        if (!this.allowWrites) {
            throw new IllegalStateException("Writes are not allowed!");
        }
    }

    private void setFullyLoaded() {
        this.fullyLoaded = true;
    }

    public boolean getFullyLoaded() {
        return this.fullyLoaded;
    }

    public RouterConfig getRouterConfig() {
        return this.routerConfig;
    }
}

