/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.Helper;
import com.graphhopper.util.PointAccess;
import com.graphhopper.util.ShallowImmutablePointList;
import com.graphhopper.util.shapes.GHPoint;
import com.graphhopper.util.shapes.GHPoint3D;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;

public class PointList
implements Iterable<GHPoint3D>,
PointAccess {
    private static final GeometryFactory factory = new GeometryFactory();
    public static final PointList EMPTY = new PointList(0, true){

        @Override
        public void set(int index, double lat, double lon, double ele) {
            throw new RuntimeException("cannot change EMPTY PointList");
        }

        @Override
        public void add(double lat, double lon, double ele) {
            throw new RuntimeException("cannot change EMPTY PointList");
        }

        @Override
        public void removeLastPoint() {
            throw new RuntimeException("cannot change EMPTY PointList");
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void clear() {
            throw new RuntimeException("cannot change EMPTY PointList");
        }

        @Override
        public void setElevation(int index, double ele) {
            throw new RuntimeException("cannot change EMPTY PointList");
        }

        @Override
        public void trimToSize(int newSize) {
            throw new RuntimeException("cannot change EMPTY PointList");
        }

        @Override
        public void parse2DJSON(String str) {
            throw new RuntimeException("cannot change EMPTY PointList");
        }

        @Override
        public PointList copy(int from, int end) {
            throw new RuntimeException("cannot copy EMPTY PointList");
        }

        @Override
        public PointList clone(boolean reverse) {
            throw new UnsupportedOperationException("cannot access EMPTY PointList");
        }

        @Override
        public double getLat(int index) {
            throw new UnsupportedOperationException("cannot access EMPTY PointList");
        }

        @Override
        public double getLon(int index) {
            throw new UnsupportedOperationException("cannot access EMPTY PointList");
        }

        @Override
        public double getEle(int index) {
            throw new UnsupportedOperationException("cannot access EMPTY PointList");
        }

        @Override
        public void reverse() {
            throw new UnsupportedOperationException("cannot change EMPTY PointList");
        }

        @Override
        public int getSize() {
            return 0;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public GHPoint3D get(int index) {
            throw new UnsupportedOperationException("cannot access EMPTY PointList");
        }

        @Override
        public boolean is3D() {
            throw new UnsupportedOperationException("cannot access EMPTY PointList");
        }
    };
    static final String ERR_MSG = "Tried to access PointList with too big index!";
    protected int size = 0;
    protected boolean is3D;
    private double[] latitudes;
    private double[] longitudes;
    private double[] elevations;
    private boolean isImmutable = false;
    private LineString cachedLineString;
    private static final double DEFAULT_PRECISION = 1.0E-6;

    public PointList() {
        this(10, false);
    }

    public PointList(int cap, boolean is3D) {
        this.latitudes = new double[cap];
        this.longitudes = new double[cap];
        this.is3D = is3D;
        if (is3D) {
            this.elevations = new double[cap];
        }
    }

    @Override
    public boolean is3D() {
        return this.is3D;
    }

    @Override
    public int getDimension() {
        if (this.is3D) {
            return 3;
        }
        return 2;
    }

    @Override
    public void ensureNode(int nodeId) {
        this.incCap(nodeId + 1);
    }

    @Override
    public void setNode(int nodeId, double lat, double lon, double ele) {
        this.set(nodeId, lat, lon, ele);
    }

    public void set(int index, double lat, double lon, double ele) {
        this.ensureMutability();
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException("index has to be smaller than size " + this.size);
        }
        this.latitudes[index] = lat;
        this.longitudes[index] = lon;
        if (this.is3D) {
            this.elevations[index] = ele;
        } else if (!Double.isNaN(ele)) {
            throw new IllegalStateException("This is a 2D list we cannot store elevation: " + ele);
        }
    }

    private void incCap(int newSize) {
        if (newSize <= this.latitudes.length) {
            return;
        }
        int cap = newSize * 2;
        if (cap < 15) {
            cap = 15;
        }
        this.latitudes = Arrays.copyOf(this.latitudes, cap);
        this.longitudes = Arrays.copyOf(this.longitudes, cap);
        if (this.is3D) {
            this.elevations = Arrays.copyOf(this.elevations, cap);
        }
    }

    public void add(double lat, double lon) {
        if (this.is3D) {
            throw new IllegalStateException("Cannot add point without elevation data in 3D mode");
        }
        this.add(lat, lon, Double.NaN);
    }

    public void add(double lat, double lon, double ele) {
        this.ensureMutability();
        int newSize = this.size + 1;
        this.incCap(newSize);
        this.latitudes[this.size] = lat;
        this.longitudes[this.size] = lon;
        if (this.is3D) {
            this.elevations[this.size] = ele;
        } else if (!Double.isNaN(ele)) {
            throw new IllegalStateException("This is a 2D list we cannot store elevation: " + ele);
        }
        this.size = newSize;
    }

    public void add(PointAccess nodeAccess, int index) {
        if (this.is3D) {
            this.add(nodeAccess.getLat(index), nodeAccess.getLon(index), nodeAccess.getEle(index));
        } else {
            this.add(nodeAccess.getLat(index), nodeAccess.getLon(index));
        }
    }

    public void add(GHPoint point) {
        if (this.is3D) {
            this.add(point.lat, point.lon, ((GHPoint3D)point).ele);
        } else {
            this.add(point.lat, point.lon);
        }
    }

    public void add(PointList points) {
        this.ensureMutability();
        int newSize = this.size + points.getSize();
        this.incCap(newSize);
        for (int i = 0; i < points.getSize(); ++i) {
            int tmp = this.size + i;
            this.latitudes[tmp] = points.getLat(i);
            this.longitudes[tmp] = points.getLon(i);
            if (!this.is3D) continue;
            this.elevations[tmp] = points.getEle(i);
        }
        this.size = newSize;
    }

    public void removeLastPoint() {
        if (this.size == 0) {
            throw new IllegalStateException("Cannot remove last point from empty PointList");
        }
        --this.size;
    }

    public int size() {
        return this.size;
    }

    public int getSize() {
        return this.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public double getLat(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException("Tried to access PointList with too big index! index:" + index + ", size:" + this.size);
        }
        return this.latitudes[index];
    }

    @Override
    public double getLon(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException("Tried to access PointList with too big index! index:" + index + ", size:" + this.size);
        }
        return this.longitudes[index];
    }

    @Override
    public double getEle(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException("Tried to access PointList with too big index! index:" + index + ", size:" + this.size);
        }
        if (!this.is3D) {
            return Double.NaN;
        }
        return this.elevations[index];
    }

    public void setElevation(int index, double ele) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException("Tried to access PointList with too big index! index:" + index + ", size:" + this.size);
        }
        if (!this.is3D) {
            throw new IllegalStateException("This is a 2D PointList, you cannot set it's elevation");
        }
        this.elevations[index] = ele;
    }

    public void reverse() {
        this.ensureMutability();
        int max = this.size / 2;
        for (int i = 0; i < max; ++i) {
            int swapIndex = this.size - i - 1;
            double tmp = this.latitudes[i];
            this.latitudes[i] = this.latitudes[swapIndex];
            this.latitudes[swapIndex] = tmp;
            tmp = this.longitudes[i];
            this.longitudes[i] = this.longitudes[swapIndex];
            this.longitudes[swapIndex] = tmp;
            if (!this.is3D) continue;
            tmp = this.elevations[i];
            this.elevations[i] = this.elevations[swapIndex];
            this.elevations[swapIndex] = tmp;
        }
    }

    public void clear() {
        this.ensureMutability();
        this.size = 0;
    }

    public void trimToSize(int newSize) {
        this.ensureMutability();
        if (newSize > this.size) {
            throw new IllegalArgumentException("new size needs be smaller than old size");
        }
        this.size = newSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.getSize(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append('(');
            sb.append(this.getLat(i));
            sb.append(',');
            sb.append(this.getLon(i));
            if (this.is3D()) {
                sb.append(',');
                sb.append(this.getEle(i));
            }
            sb.append(')');
        }
        return sb.toString();
    }

    public static PointList fromLineString(LineString lineString) {
        PointList pointList = new PointList();
        for (Coordinate coordinate : lineString.getCoordinates()) {
            pointList.add(new GHPoint(coordinate.y, coordinate.x));
        }
        return pointList;
    }

    public LineString toLineString(boolean includeElevation) {
        Coordinate[] coordinates = new Coordinate[this.getSize() == 1 ? 2 : this.getSize()];
        for (int i = 0; i < this.getSize(); ++i) {
            coordinates[i] = includeElevation ? new Coordinate(Helper.round6(this.getLon(i)), Helper.round6(this.getLat(i)), Helper.round2(this.getEle(i))) : new Coordinate(Helper.round6(this.getLon(i)), Helper.round6(this.getLat(i)));
        }
        if (this.getSize() == 1) {
            coordinates[1] = coordinates[0];
        }
        return factory.createLineString(new PackedCoordinateSequence.Double(coordinates, includeElevation ? 3 : 2));
    }

    public LineString getCachedLineString(boolean includeElevation) {
        if (this.cachedLineString != null) {
            return this.cachedLineString;
        }
        if (!this.isImmutable) {
            throw new IllegalArgumentException("Make PointList immutable before calling getCachedLineString");
        }
        this.cachedLineString = this.toLineString(includeElevation);
        return this.cachedLineString;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        PointList other = (PointList)obj;
        if (this.isEmpty() && other.isEmpty()) {
            return true;
        }
        if (this.getSize() != other.getSize() || this.is3D() != other.is3D()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (!PointList.equalsEps(this.getLat(i), other.getLat(i))) {
                return false;
            }
            if (!PointList.equalsEps(this.getLon(i), other.getLon(i))) {
                return false;
            }
            if (!this.is3D() || PointList.equalsEps(this.getEle(i), other.getEle(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsEps(double d1, double d2) {
        return PointList.equalsEps(d1, d2, 1.0E-6);
    }

    public static boolean equalsEps(double d1, double d2, double epsilon) {
        return Math.abs(d1 - d2) < epsilon;
    }

    public PointList clone(boolean reverse) {
        PointList clonePL = new PointList(this.getSize(), this.is3D());
        if (this.is3D()) {
            for (int i = 0; i < this.getSize(); ++i) {
                clonePL.add(this.getLat(i), this.getLon(i), this.getEle(i));
            }
        } else {
            for (int i = 0; i < this.getSize(); ++i) {
                clonePL.add(this.getLat(i), this.getLon(i));
            }
        }
        if (reverse) {
            clonePL.reverse();
        }
        return clonePL;
    }

    public PointList copy(int from, int end) {
        if (from > end) {
            throw new IllegalArgumentException("from must be smaller or equal to end");
        }
        if (from < 0 || end > this.getSize()) {
            throw new IllegalArgumentException("Illegal interval: " + from + ", " + end + ", size:" + this.getSize());
        }
        PointList thisPL = this;
        if (this instanceof ShallowImmutablePointList) {
            ShallowImmutablePointList spl = (ShallowImmutablePointList)this;
            thisPL = spl.wrappedPointList;
            from = spl.fromOffset + from;
            end = spl.fromOffset + end;
        }
        int len = end - from;
        PointList copyPL = new PointList(len, this.is3D());
        copyPL.size = len;
        copyPL.isImmutable = this.isImmutable();
        System.arraycopy(thisPL.latitudes, from, copyPL.latitudes, 0, len);
        System.arraycopy(thisPL.longitudes, from, copyPL.longitudes, 0, len);
        if (this.is3D()) {
            System.arraycopy(thisPL.elevations, from, copyPL.elevations, 0, len);
        }
        return copyPL;
    }

    public PointList shallowCopy(int from, int end, boolean makeImmutable) {
        if (makeImmutable) {
            this.makeImmutable();
        }
        return new ShallowImmutablePointList(from, end, this);
    }

    public int hashCode() {
        int hash = 5;
        for (int i = 0; i < this.getSize(); ++i) {
            hash = 73 * hash + (int)Math.round(this.getLat(i) * 1000000.0);
            hash = 73 * hash + (int)Math.round(this.getLon(i) * 1000000.0);
        }
        hash = 73 * hash + this.getSize();
        return hash;
    }

    public void parse2DJSON(String str) {
        for (String latlon : str.split("\\[")) {
            if (latlon.trim().length() == 0) continue;
            String[] ll = latlon.split(",");
            String lat = ll[1].replace("]", "").trim();
            this.add(Double.parseDouble(lat), Double.parseDouble(ll[0].trim()), Double.NaN);
        }
    }

    public GHPoint3D get(int index) {
        return new GHPoint3D(this.getLat(index), this.getLon(index), this.getEle(index));
    }

    int getCapacity() {
        return this.latitudes.length;
    }

    @Override
    public Iterator<GHPoint3D> iterator() {
        return new Iterator<GHPoint3D>(){
            int counter = 0;

            @Override
            public boolean hasNext() {
                return this.counter < PointList.this.getSize();
            }

            @Override
            public GHPoint3D next() {
                if (this.counter >= PointList.this.getSize()) {
                    throw new NoSuchElementException();
                }
                GHPoint3D point = PointList.this.get(this.counter);
                ++this.counter;
                return point;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported.");
            }
        };
    }

    public static PointList from(LineString lineString) {
        PointList pointList = new PointList();
        for (Coordinate coordinate : lineString.getCoordinates()) {
            pointList.add(new GHPoint(coordinate.y, coordinate.x));
        }
        return pointList;
    }

    public boolean isImmutable() {
        return this.isImmutable;
    }

    public PointList makeImmutable() {
        this.isImmutable = true;
        return this;
    }

    private void ensureMutability() {
        if (this.isImmutable()) {
            throw new IllegalStateException("You cannot change an immutable PointList");
        }
    }
}

