/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.http;

import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.RealtimeFeed;
import com.graphhopper.http.RealtimeBundleConfiguration;
import com.graphhopper.http.RealtimeFeedLoadingCache;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.client.HttpClientBuilder;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.utilities.binding.AbstractBinder;

public class RealtimeBundle
implements ConfiguredBundle<RealtimeBundleConfiguration> {
    @Override
    public void initialize(Bootstrap<?> bootstrap) {
    }

    @Override
    public void run(final RealtimeBundleConfiguration configuration, Environment environment) {
        if (configuration.gtfsrealtime().getFeeds().isEmpty()) {
            environment.jersey().register(new AbstractBinder(){

                @Override
                protected void configure() {
                    this.bindFactory(EmptyRealtimeFeedFactory.class).to(RealtimeFeed.class).in(Singleton.class);
                }
            });
        } else {
            final CloseableHttpClient httpClient = new HttpClientBuilder(environment).using(configuration.gtfsrealtime().getHttpClientConfiguration()).build("gtfs-realtime-feed-loader");
            environment.jersey().register(new AbstractBinder(){

                @Override
                protected void configure() {
                    this.bind(httpClient).to(HttpClient.class);
                    this.bind(configuration).to(RealtimeBundleConfiguration.class);
                    this.bindFactory(RealtimeFeedLoadingCache.class, Singleton.class).to(RealtimeFeed.class);
                }
            });
        }
    }

    private static class EmptyRealtimeFeedFactory
    implements Factory<RealtimeFeed> {
        private final GtfsStorage staticGtfs;

        @Inject
        EmptyRealtimeFeedFactory(GtfsStorage staticGtfs) {
            this.staticGtfs = staticGtfs;
        }

        @Override
        public RealtimeFeed provide() {
            return RealtimeFeed.empty(this.staticGtfs);
        }

        @Override
        public void dispose(RealtimeFeed realtimeFeed) {
        }
    }
}

