/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.http;

import java.net.URI;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;

@PreMatching
public class PtRedirectFilter
implements ContainerRequestFilter {
    @Override
    public void filter(ContainerRequestContext requestContext) {
        if (this.shouldRedirect(requestContext)) {
            if (requestContext.getUriInfo().getPath().equals("route")) {
                URI forwardURI = requestContext.getUriInfo().getRequestUriBuilder().replacePath("/route-pt").replaceQueryParam("vehicle", new Object[0]).replaceQueryParam("profile", new Object[0]).build(new Object[0]);
                requestContext.setRequestUri(forwardURI);
            } else if (requestContext.getUriInfo().getPath().equals("isochrone")) {
                URI forwardURI = requestContext.getUriInfo().getRequestUriBuilder().replacePath("/isochrone-pt").replaceQueryParam("vehicle", new Object[0]).replaceQueryParam("profile", new Object[0]).build(new Object[0]);
                requestContext.setRequestUri(forwardURI);
            }
        }
    }

    private boolean shouldRedirect(ContainerRequestContext requestContext) {
        String maybeVehicle = requestContext.getUriInfo().getQueryParameters().getFirst("vehicle");
        String maybeProfile = requestContext.getUriInfo().getQueryParameters().getFirst("profile");
        return "pt".equals(maybeVehicle) || "pt".equals(maybeProfile);
    }
}

