/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.http;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.graphhopper.GraphHopper;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.config.Profile;
import com.graphhopper.gtfs.GraphHopperGtfs;
import com.graphhopper.jackson.Jackson;
import com.graphhopper.routing.lm.LandmarkStorage;
import com.graphhopper.routing.util.spatialrules.SpatialRuleLookupHelper;
import com.graphhopper.routing.weighting.custom.CustomProfile;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.Helper;
import com.graphhopper.util.JsonFeatureCollection;
import com.graphhopper.util.shapes.BBox;
import io.dropwizard.lifecycle.Managed;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphHopperManaged
implements Managed {
    private static final Logger logger = LoggerFactory.getLogger(GraphHopperManaged.class);
    private final GraphHopper graphHopper;

    public GraphHopperManaged(GraphHopperConfig configuration, ObjectMapper objectMapper) {
        ObjectMapper localObjectMapper = objectMapper.copy();
        localObjectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonFeatureCollection landmarkSplittingFeatureCollection = GraphHopperManaged.loadLandmarkSplittingFeatureCollection(configuration, localObjectMapper);
        this.graphHopper = configuration.has("gtfs.file") ? new GraphHopperGtfs(configuration) : new GraphHopper(landmarkSplittingFeatureCollection);
        if (!configuration.getString("spatial_rules.location", "").isEmpty()) {
            throw new RuntimeException("spatial_rules.location has been deprecated. Please use spatial_rules.borders_directory instead.");
        }
        String spatialRuleBordersDirLocation = configuration.getString("spatial_rules.borders_directory", "");
        if (!spatialRuleBordersDirLocation.isEmpty()) {
            Envelope maxBounds = BBox.toEnvelope(BBox.parseBBoxString(configuration.getString("spatial_rules.max_bbox", "-180, 180, -90, 90")));
            Path bordersDirectory = Paths.get(spatialRuleBordersDirLocation, new String[0]);
            ArrayList<JsonFeatureCollection> jsonFeatureCollections = new ArrayList<JsonFeatureCollection>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(bordersDirectory, "*.{geojson,json}");){
                for (Path borderFile : stream) {
                    BufferedReader reader = Files.newBufferedReader(borderFile, StandardCharsets.UTF_8);
                    Throwable throwable = null;
                    try {
                        JsonFeatureCollection jsonFeatureCollection = localObjectMapper.readValue((Reader)reader, JsonFeatureCollection.class);
                        jsonFeatureCollections.add(jsonFeatureCollection);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            SpatialRuleLookupHelper.buildAndInjectCountrySpatialRules(this.graphHopper, maxBounds, jsonFeatureCollections);
        }
        String customModelFolder = configuration.getString("custom_model_folder", "");
        List<Profile> newProfiles = GraphHopperManaged.resolveCustomModelFiles(customModelFolder, configuration.getProfiles());
        configuration.setProfiles(newProfiles);
        this.graphHopper.init(configuration);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonFeatureCollection loadLandmarkSplittingFeatureCollection(GraphHopperConfig configuration, ObjectMapper localObjectMapper) {
        String splitAreaLocation = configuration.getString("prepare.lm.split_area_location", "");
        try (InputStreamReader reader = splitAreaLocation.isEmpty() ? new InputStreamReader(LandmarkStorage.class.getResource("map.geo.json").openStream(), Helper.UTF_CS) : new InputStreamReader((InputStream)new FileInputStream(splitAreaLocation), Helper.UTF_CS);){
            JsonFeatureCollection result = localObjectMapper.readValue((Reader)reader, JsonFeatureCollection.class);
            logger.info("Loaded landmark splitting collection from " + splitAreaLocation);
            JsonFeatureCollection jsonFeatureCollection = result;
            return jsonFeatureCollection;
        }
        catch (IOException e1) {
            logger.error("Problem while reading border map GeoJSON. Skipping this.", e1);
            return null;
        }
    }

    public static List<Profile> resolveCustomModelFiles(String customModelFolder, List<Profile> profiles) {
        ObjectMapper yamlOM = Jackson.initObjectMapper(new ObjectMapper(new YAMLFactory()));
        ObjectMapper jsonOM = Jackson.newObjectMapper();
        ArrayList<Profile> newProfiles = new ArrayList<Profile>();
        for (Profile profile : profiles) {
            if (!"custom".equals(profile.getWeighting())) {
                newProfiles.add(profile);
                continue;
            }
            Object cm = profile.getHints().getObject("custom_model", null);
            if (cm != null) {
                try {
                    CustomModel customModel = jsonOM.readValue(jsonOM.writeValueAsBytes(cm), CustomModel.class);
                    newProfiles.add(new CustomProfile(profile).setCustomModel(customModel));
                    continue;
                }
                catch (Exception ex) {
                    throw new RuntimeException("Cannot load custom_model from " + cm + " for profile " + profile.getName(), ex);
                }
            }
            String customModelFileName = profile.getHints().getString("custom_model_file", "");
            if (customModelFileName.isEmpty()) {
                throw new IllegalArgumentException("Missing 'custom_model' or 'custom_model_file' field in profile '" + profile.getName() + "'. To use default specify custom_model_file: empty");
            }
            if ("empty".equals(customModelFileName)) {
                newProfiles.add(new CustomProfile(profile).setCustomModel(new CustomModel()));
                continue;
            }
            if (customModelFileName.contains(File.separator)) {
                throw new IllegalArgumentException("Use custom_model_folder for the custom_model_file parent");
            }
            File file = Paths.get(customModelFolder, new String[0]).resolve(customModelFileName).toFile();
            try {
                CustomModel customModel = (customModelFileName.endsWith(".json") ? jsonOM : yamlOM).readValue(file, CustomModel.class);
                newProfiles.add(new CustomProfile(profile).setCustomModel(customModel));
            }
            catch (Exception ex) {
                throw new RuntimeException("Cannot load custom_model from location " + customModelFileName + " for profile " + profile.getName(), ex);
            }
        }
        return newProfiles;
    }

    @Override
    public void start() {
        this.graphHopper.importOrLoad();
        logger.info("loaded graph at:{}, data_reader_file:{}, encoded values:{}, {} ints for edge flags, {}", this.graphHopper.getGraphHopperLocation(), this.graphHopper.getOSMFile(), this.graphHopper.getEncodingManager().toEncodedValuesAsString(), this.graphHopper.getEncodingManager().getIntsForFlags(), this.graphHopper.getGraphHopperStorage().toDetailsString());
    }

    public GraphHopper getGraphHopper() {
        return this.graphHopper;
    }

    @Override
    public void stop() {
        this.graphHopper.close();
    }
}

