/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.geohash;

import com.graphhopper.util.shapes.BBox;

public class SpatialKeyAlgo {
    private final int parts;
    private final int allBits;
    private final BBox bbox;
    private final double deltaY;
    private final double deltaX;
    private final int[] MortonTable256 = new int[]{0, 1, 4, 5, 16, 17, 20, 21, 64, 65, 68, 69, 80, 81, 84, 85, 256, 257, 260, 261, 272, 273, 276, 277, 320, 321, 324, 325, 336, 337, 340, 341, 1024, 1025, 1028, 1029, 1040, 1041, 1044, 1045, 1088, 1089, 1092, 1093, 1104, 1105, 1108, 1109, 1280, 1281, 1284, 1285, 1296, 1297, 1300, 1301, 1344, 1345, 1348, 1349, 1360, 1361, 1364, 1365, 4096, 4097, 4100, 4101, 4112, 4113, 4116, 4117, 4160, 4161, 4164, 4165, 4176, 4177, 4180, 4181, 4352, 4353, 4356, 4357, 4368, 4369, 4372, 4373, 4416, 4417, 4420, 4421, 4432, 4433, 4436, 4437, 5120, 5121, 5124, 5125, 5136, 5137, 5140, 5141, 5184, 5185, 5188, 5189, 5200, 5201, 5204, 5205, 5376, 5377, 5380, 5381, 5392, 5393, 5396, 5397, 5440, 5441, 5444, 5445, 5456, 5457, 5460, 5461, 16384, 16385, 16388, 16389, 16400, 16401, 16404, 16405, 16448, 16449, 16452, 16453, 16464, 16465, 16468, 16469, 16640, 16641, 16644, 16645, 16656, 16657, 16660, 16661, 16704, 16705, 16708, 16709, 16720, 16721, 16724, 16725, 17408, 17409, 17412, 17413, 17424, 17425, 17428, 17429, 17472, 17473, 17476, 17477, 17488, 17489, 17492, 17493, 17664, 17665, 17668, 17669, 17680, 17681, 17684, 17685, 17728, 17729, 17732, 17733, 17744, 17745, 17748, 17749, 20480, 20481, 20484, 20485, 20496, 20497, 20500, 20501, 20544, 20545, 20548, 20549, 20560, 20561, 20564, 20565, 20736, 20737, 20740, 20741, 20752, 20753, 20756, 20757, 20800, 20801, 20804, 20805, 20816, 20817, 20820, 20821, 21504, 21505, 21508, 21509, 21520, 21521, 21524, 21525, 21568, 21569, 21572, 21573, 21584, 21585, 21588, 21589, 21760, 21761, 21764, 21765, 21776, 21777, 21780, 21781, 21824, 21825, 21828, 21829, 21840, 21841, 21844, 21845};
    private final int[] MortonTable256DecodeX = new int[]{0, 1, 0, 1, 2, 3, 2, 3, 0, 1, 0, 1, 2, 3, 2, 3, 4, 5, 4, 5, 6, 7, 6, 7, 4, 5, 4, 5, 6, 7, 6, 7, 0, 1, 0, 1, 2, 3, 2, 3, 0, 1, 0, 1, 2, 3, 2, 3, 4, 5, 4, 5, 6, 7, 6, 7, 4, 5, 4, 5, 6, 7, 6, 7, 8, 9, 8, 9, 10, 11, 10, 11, 8, 9, 8, 9, 10, 11, 10, 11, 12, 13, 12, 13, 14, 15, 14, 15, 12, 13, 12, 13, 14, 15, 14, 15, 8, 9, 8, 9, 10, 11, 10, 11, 8, 9, 8, 9, 10, 11, 10, 11, 12, 13, 12, 13, 14, 15, 14, 15, 12, 13, 12, 13, 14, 15, 14, 15, 0, 1, 0, 1, 2, 3, 2, 3, 0, 1, 0, 1, 2, 3, 2, 3, 4, 5, 4, 5, 6, 7, 6, 7, 4, 5, 4, 5, 6, 7, 6, 7, 0, 1, 0, 1, 2, 3, 2, 3, 0, 1, 0, 1, 2, 3, 2, 3, 4, 5, 4, 5, 6, 7, 6, 7, 4, 5, 4, 5, 6, 7, 6, 7, 8, 9, 8, 9, 10, 11, 10, 11, 8, 9, 8, 9, 10, 11, 10, 11, 12, 13, 12, 13, 14, 15, 14, 15, 12, 13, 12, 13, 14, 15, 14, 15, 8, 9, 8, 9, 10, 11, 10, 11, 8, 9, 8, 9, 10, 11, 10, 11, 12, 13, 12, 13, 14, 15, 14, 15, 12, 13, 12, 13, 14, 15, 14, 15};
    private final int[] MortonTable256DecodeY = new int[]{0, 0, 1, 1, 0, 0, 1, 1, 2, 2, 3, 3, 2, 2, 3, 3, 0, 0, 1, 1, 0, 0, 1, 1, 2, 2, 3, 3, 2, 2, 3, 3, 4, 4, 5, 5, 4, 4, 5, 5, 6, 6, 7, 7, 6, 6, 7, 7, 4, 4, 5, 5, 4, 4, 5, 5, 6, 6, 7, 7, 6, 6, 7, 7, 0, 0, 1, 1, 0, 0, 1, 1, 2, 2, 3, 3, 2, 2, 3, 3, 0, 0, 1, 1, 0, 0, 1, 1, 2, 2, 3, 3, 2, 2, 3, 3, 4, 4, 5, 5, 4, 4, 5, 5, 6, 6, 7, 7, 6, 6, 7, 7, 4, 4, 5, 5, 4, 4, 5, 5, 6, 6, 7, 7, 6, 6, 7, 7, 8, 8, 9, 9, 8, 8, 9, 9, 10, 10, 11, 11, 10, 10, 11, 11, 8, 8, 9, 9, 8, 8, 9, 9, 10, 10, 11, 11, 10, 10, 11, 11, 12, 12, 13, 13, 12, 12, 13, 13, 14, 14, 15, 15, 14, 14, 15, 15, 12, 12, 13, 13, 12, 12, 13, 13, 14, 14, 15, 15, 14, 14, 15, 15, 8, 8, 9, 9, 8, 8, 9, 9, 10, 10, 11, 11, 10, 10, 11, 11, 8, 8, 9, 9, 8, 8, 9, 9, 10, 10, 11, 11, 10, 10, 11, 11, 12, 12, 13, 13, 12, 12, 13, 13, 14, 14, 15, 15, 14, 14, 15, 15, 12, 12, 13, 13, 12, 12, 13, 13, 14, 14, 15, 15, 14, 14, 15, 15};

    public SpatialKeyAlgo(int allBits, BBox bounds) {
        if (allBits > 48) {
            throw new IllegalStateException("allBits is too big for this implementation");
        }
        if (allBits <= 0) {
            throw new IllegalStateException("allBits must be positive");
        }
        this.allBits = allBits;
        this.parts = (int)Math.pow(2.0, allBits / 2);
        this.bbox = bounds;
        this.deltaY = (this.bbox.maxLat - this.bbox.minLat) / (double)this.parts;
        this.deltaX = (this.bbox.maxLon - this.bbox.minLon) / (double)this.parts;
    }

    public int getBits() {
        return this.allBits;
    }

    public final long encodeLatLon(double lat, double lon) {
        return this.encode(this.x(lon), this.y(lat));
    }

    public int y(double lat) {
        return Math.max(0, Math.min((int)((lat - this.bbox.minLat) / this.deltaY), this.parts - 1));
    }

    public int x(double lon) {
        return Math.max(0, Math.min((int)((lon - this.bbox.minLon) / this.deltaX), this.parts - 1));
    }

    public long encode(int x, int y) {
        int EIGHTBITMASK = 255;
        return this.MortonTable256[y >> 8 & EIGHTBITMASK] << 17 | this.MortonTable256[x >> 8 & EIGHTBITMASK] << 16 | this.MortonTable256[y & EIGHTBITMASK] << 1 | this.MortonTable256[x & EIGHTBITMASK];
    }

    public int[] decode(long z) {
        int[] result = new int[2];
        if ((double)z < Math.pow(2.0, 48.0)) {
            result[0] = SpatialKeyAlgo.decodeHelper(z, this.MortonTable256DecodeX);
            result[1] = SpatialKeyAlgo.decodeHelper(z, this.MortonTable256DecodeY);
        }
        return result;
    }

    private static int decodeHelper(long z, int[] coord) {
        long a = 0L;
        long EIGHTBITMASK = 255L;
        long loops = (long)Math.floor(7.111111164093018);
        for (long i = 0L; i < loops; ++i) {
            a |= (long)(coord[(int)(z >> (int)(i * 8L) & EIGHTBITMASK)] << (int)(4L * i));
        }
        return (int)a;
    }

    public long up(long z) {
        return (z | 0x5555555555555555L) + 1L & 0xAAAAAAAAAAAAAAAAL | z & 0x5555555555555555L;
    }

    public long down(long z) {
        return (z & 0xAAAAAAAAAAAAAAAAL) - 1L & 0xAAAAAAAAAAAAAAAAL | z & 0x5555555555555555L;
    }

    public long right(long z) {
        return (z | 0xAAAAAAAAAAAAAAAAL) + 1L & 0x5555555555555555L | z & 0xAAAAAAAAAAAAAAAAL;
    }

    public long left(long z) {
        return (z & 0x5555555555555555L) - 1L & 0x5555555555555555L | z & 0xAAAAAAAAAAAAAAAAL;
    }
}

