/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.details;

import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.details.AbstractPathDetailsBuilder;

public class WeightDetails
extends AbstractPathDetailsBuilder {
    private final Weighting weighting;
    private int edgeId = -1;
    private double weight = Double.NaN;

    public WeightDetails(Weighting weighting) {
        super("weight");
        this.weighting = weighting;
    }

    @Override
    public boolean isEdgeDifferentToLastEdge(EdgeIteratorState edge) {
        if (edge.getEdge() != this.edgeId) {
            this.edgeId = edge.getEdge();
            this.weight = GHUtility.calcWeightWithTurnWeight(this.weighting, edge, false, this.edgeId);
            return true;
        }
        return false;
    }

    @Override
    public Object getCurrentValue() {
        return this.weight;
    }
}

