/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.details;

import com.graphhopper.coll.MapEntry;
import com.graphhopper.routing.ev.Country;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.Hazmat;
import com.graphhopper.routing.ev.HazmatTunnel;
import com.graphhopper.routing.ev.HazmatWater;
import com.graphhopper.routing.ev.RoadAccess;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.ev.RoadEnvironment;
import com.graphhopper.routing.ev.Surface;
import com.graphhopper.routing.ev.Toll;
import com.graphhopper.routing.ev.TrackType;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.util.details.AverageSpeedDetails;
import com.graphhopper.util.details.DecimalDetails;
import com.graphhopper.util.details.DistanceDetails;
import com.graphhopper.util.details.EdgeIdDetails;
import com.graphhopper.util.details.EdgeKeyDetails;
import com.graphhopper.util.details.EnumDetails;
import com.graphhopper.util.details.PathDetailsBuilder;
import com.graphhopper.util.details.StreetNameDetails;
import com.graphhopper.util.details.TimeDetails;
import com.graphhopper.util.details.WeightDetails;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class PathDetailsBuilderFactory {
    public List<PathDetailsBuilder> createPathDetailsBuilders(List<String> requestedPathDetails, EncodedValueLookup evl, Weighting weighting) {
        ArrayList<PathDetailsBuilder> builders = new ArrayList<PathDetailsBuilder>();
        if (requestedPathDetails.contains("average_speed")) {
            builders.add(new AverageSpeedDetails(weighting));
        }
        if (requestedPathDetails.contains("street_name")) {
            builders.add(new StreetNameDetails());
        }
        if (requestedPathDetails.contains("edge_id")) {
            builders.add(new EdgeIdDetails());
        }
        if (requestedPathDetails.contains("edge_key")) {
            builders.add(new EdgeKeyDetails());
        }
        if (requestedPathDetails.contains("time")) {
            builders.add(new TimeDetails(weighting));
        }
        if (requestedPathDetails.contains("weight")) {
            builders.add(new WeightDetails(weighting));
        }
        if (requestedPathDetails.contains("distance")) {
            builders.add(new DistanceDetails());
        }
        for (String string : requestedPathDetails) {
            if (!string.contains(EncodingManager.getKey("", "priority")) || !evl.hasEncodedValue(string)) continue;
            builders.add(new DecimalDetails(string, evl.getDecimalEncodedValue(string)));
        }
        for (String string : Arrays.asList("max_speed", "max_width", "max_height", "max_weight", "max_axle_load", "max_length")) {
            if (!requestedPathDetails.contains(string) || !evl.hasEncodedValue(string)) continue;
            builders.add(new DecimalDetails(string, evl.getDecimalEncodedValue(string)));
        }
        for (Map.Entry entry : Arrays.asList(new MapEntry<String, Class<RoadClass>>("road_class", RoadClass.class), new MapEntry<String, Class<RoadEnvironment>>("road_environment", RoadEnvironment.class), new MapEntry<String, Class<Surface>>("surface", Surface.class), new MapEntry<String, Class<RoadAccess>>("road_access", RoadAccess.class), new MapEntry<String, Class<Toll>>("toll", Toll.class), new MapEntry<String, Class<TrackType>>("track_type", TrackType.class), new MapEntry<String, Class<Hazmat>>("hazmat", Hazmat.class), new MapEntry<String, Class<HazmatTunnel>>("hazmat_tunnel", HazmatTunnel.class), new MapEntry<String, Class<HazmatWater>>("hazmat_water", HazmatWater.class), new MapEntry<String, Class<Country>>("country", Country.class))) {
            String key = (String)entry.getKey();
            if (!requestedPathDetails.contains(key) || !evl.hasEncodedValue(key)) continue;
            builders.add(new EnumDetails(key, evl.getEnumEncodedValue(key, (Class)entry.getValue())));
        }
        if (requestedPathDetails.size() != builders.size()) {
            throw new IllegalArgumentException("You requested the details " + requestedPathDetails + " but we could only find " + builders);
        }
        return builders;
    }
}

