/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntIndexedContainer;
import java.util.Arrays;
import java.util.Random;

public class ArrayUtil {
    public static IntArrayList constant(int size, int value) {
        IntArrayList result = new IntArrayList(size);
        Arrays.fill(result.buffer, value);
        result.elementsCount = size;
        return result;
    }

    public static IntArrayList iota(int size) {
        IntArrayList result = new IntArrayList(size);
        result.elementsCount = size;
        for (int i = 0; i < size; ++i) {
            result.set(i, i);
        }
        return result;
    }

    public static IntArrayList permutation(int size, Random rnd) {
        IntArrayList result = ArrayUtil.iota(size);
        ArrayUtil.shuffle(result, rnd);
        return result;
    }

    public static IntArrayList reverse(IntArrayList list) {
        int[] buffer = list.buffer;
        int start = 0;
        for (int end = list.size() - 1; start < end; ++start, --end) {
            int tmp = buffer[start];
            buffer[start] = buffer[end];
            buffer[end] = tmp;
        }
        return list;
    }

    public static IntArrayList shuffle(IntArrayList list, Random random) {
        int maxHalf = list.size() / 2;
        for (int x1 = 0; x1 < maxHalf; ++x1) {
            int x2 = random.nextInt(maxHalf) + maxHalf;
            int tmp = list.buffer[x1];
            list.buffer[x1] = list.buffer[x2];
            list.buffer[x2] = tmp;
        }
        return list;
    }

    public static IntIndexedContainer removeConsecutiveDuplicates(IntIndexedContainer arr) {
        if (arr.size() < 2) {
            return arr;
        }
        IntArrayList result = new IntArrayList();
        int prev = arr.get(0);
        for (int i = 1; i < arr.size(); ++i) {
            int val = arr.get(i);
            if (val != prev) {
                result.add(val);
            }
            prev = val;
        }
        return result;
    }
}

