/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.routing.ch.NodeOrderingProvider;
import com.graphhopper.routing.ch.PrepareEncoder;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.util.AllCHEdgesIterator;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.DAType;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.EdgeAccess;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.Storable;
import com.graphhopper.util.CHEdgeExplorer;
import com.graphhopper.util.CHEdgeIterator;
import com.graphhopper.util.CHEdgeIteratorState;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PointList;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHGraphImpl
implements CHGraph,
Storable<CHGraph> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CHGraphImpl.class);
    private static final double WEIGHT_FACTOR = 1000.0;
    private static final int MAX_WEIGHT_31 = 0x7FFFFFFC;
    private static final double MAX_WEIGHT = 536870.911;
    private static final double MIN_WEIGHT = 0.001;
    final DataAccess shortcuts;
    final DataAccess nodesCH;
    final int scDirMask = PrepareEncoder.getScDirMask();
    private final CHConfig chConfig;
    private final BaseGraph baseGraph;
    private final CHEdgeAccess chEdgeAccess;
    int N_CH_REF;
    int shortcutEntryBytes;
    int nodeCHEntryBytes;
    private int N_LEVEL;
    private int S_SKIP_EDGE1;
    private int S_SKIP_EDGE2;
    private int S_ORIG_FIRST;
    private int S_ORIG_LAST;
    private int shortcutCount = 0;
    private boolean isReadyForContraction;

    CHGraphImpl(CHConfig chConfig, Directory dir, BaseGraph baseGraph, int segmentSize) {
        if (chConfig.getWeighting() == null) {
            throw new IllegalStateException("Weighting for CHGraph cannot be null");
        }
        this.chConfig = chConfig;
        this.baseGraph = baseGraph;
        String name = chConfig.getName();
        this.nodesCH = dir.find("nodes_ch_" + name, DAType.getPreferredInt(dir.getDefaultType()));
        this.shortcuts = dir.find("shortcuts_" + name, DAType.getPreferredInt(dir.getDefaultType()));
        this.chEdgeAccess = new CHEdgeAccess(name);
        if (segmentSize >= 0) {
            this.nodesCH.setSegmentSize(segmentSize);
            this.shortcuts.setSegmentSize(segmentSize);
        }
    }

    @Override
    public CHConfig getCHConfig() {
        return this.chConfig;
    }

    @Override
    public boolean isShortcut(int edgeId) {
        assert (this.baseGraph.isFrozen()) : "level graph not yet frozen";
        return edgeId >= this.baseGraph.edgeCount;
    }

    @Override
    public final void setLevel(int nodeIndex, int level) {
        this.checkNodeId(nodeIndex);
        this.nodesCH.setInt((long)nodeIndex * (long)this.nodeCHEntryBytes + (long)this.N_LEVEL, level);
    }

    @Override
    public final int getLevel(int nodeIndex) {
        this.checkNodeId(nodeIndex);
        return this.nodesCH.getInt((long)nodeIndex * (long)this.nodeCHEntryBytes + (long)this.N_LEVEL);
    }

    final void checkNodeId(int nodeId) {
        assert (nodeId < this.baseGraph.getNodes()) : "node " + nodeId + " is invalid. Not in [0," + this.baseGraph.getNodes() + ")";
    }

    @Override
    public int shortcut(int a, int b, int accessFlags, double weight, int skippedEdge1, int skippedEdge2) {
        if (!this.baseGraph.isFrozen()) {
            throw new IllegalStateException("Cannot create shortcut if graph is not yet frozen");
        }
        this.checkNodeId(a);
        this.checkNodeId(b);
        int scId = this.chEdgeAccess.internalEdgeAdd(this.nextShortcutId(), a, b, false);
        long edgePointer = this.chEdgeAccess.toPointer(scId);
        this.chEdgeAccess.setAccessAndWeight(edgePointer, accessFlags & this.scDirMask, weight);
        this.chEdgeAccess.setSkippedEdges(edgePointer, skippedEdge1, skippedEdge2);
        return scId;
    }

    @Override
    public int shortcutEdgeBased(int a, int b, int accessFlags, double weight, int skippedEdge1, int skippedEdge2, int origFirst, int origLast) {
        if (!this.chConfig.isEdgeBased()) {
            throw new IllegalStateException("Edge-based shortcuts should only be added when CHGraph is edge-based");
        }
        int scId = this.shortcut(a, b, accessFlags, weight, skippedEdge1, skippedEdge2);
        this.chEdgeAccess.setFirstAndLastOrigEdges(this.chEdgeAccess.toPointer(scId), origFirst, origLast);
        return scId;
    }

    protected int nextShortcutId() {
        int nextSC = this.shortcutCount++;
        if (this.shortcutCount < 0) {
            throw new IllegalStateException("too many shortcuts. new shortcut id would be negative. " + this.toString());
        }
        this.shortcuts.ensureCapacity(((long)this.shortcutCount + 1L) * (long)this.shortcutEntryBytes);
        return nextSC + this.baseGraph.edgeCount;
    }

    @Override
    public CHEdgeExplorer createEdgeExplorer() {
        return this.createEdgeExplorer(EdgeFilter.ALL_EDGES);
    }

    @Override
    public CHEdgeExplorer createEdgeExplorer(EdgeFilter filter) {
        return new CHEdgeIteratorImpl(this.baseGraph, this.chEdgeAccess, filter);
    }

    @Override
    public EdgeExplorer createOriginalEdgeExplorer() {
        return this.createOriginalEdgeExplorer(EdgeFilter.ALL_EDGES);
    }

    @Override
    public EdgeExplorer createOriginalEdgeExplorer(EdgeFilter filter) {
        return this.baseGraph.createEdgeExplorer(filter);
    }

    @Override
    public final CHEdgeIteratorState getEdgeIteratorState(int edgeId, int endNode) {
        CHEdgeIteratorStateImpl edge;
        if (this.isShortcut(edgeId)) {
            if (!this.chEdgeAccess.isInBounds(edgeId)) {
                throw new IllegalStateException("shortcutId " + edgeId + " out of bounds");
            }
        } else if (!this.baseGraph.edgeAccess.isInBounds(edgeId)) {
            throw new IllegalStateException("edgeId " + edgeId + " out of bounds");
        }
        if ((edge = new CHEdgeIteratorStateImpl(new BaseGraph.EdgeIteratorStateImpl(this.chEdgeAccess, this.baseGraph))).init(edgeId, endNode)) {
            return edge;
        }
        return null;
    }

    @Override
    public int getNodes() {
        return this.baseGraph.getNodes();
    }

    @Override
    public int getEdges() {
        return this.baseGraph.getEdges() + this.shortcutCount;
    }

    @Override
    public int getOriginalEdges() {
        return this.baseGraph.getEdges();
    }

    @Override
    public boolean isReadyForContraction() {
        return this.isReadyForContraction;
    }

    @Override
    public int getOtherNode(int edge, int node) {
        EdgeAccess edgeAccess = this.isShortcut(edge) ? this.chEdgeAccess : this.baseGraph.edgeAccess;
        long edgePointer = edgeAccess.toPointer(edge);
        return edgeAccess.getOtherNode(node, edgePointer);
    }

    @Override
    public boolean isAdjacentToNode(int edge, int node) {
        EdgeAccess edgeAccess = this.isShortcut(edge) ? this.chEdgeAccess : this.baseGraph.edgeAccess;
        long edgePointer = edgeAccess.toPointer(edge);
        return edgeAccess.isAdjacentToNode(node, edgePointer);
    }

    void _prepareForContraction() {
        if (this.isReadyForContraction) {
            return;
        }
        long maxCapacity = (long)this.getNodes() * (long)this.nodeCHEntryBytes;
        this.nodesCH.ensureCapacity(maxCapacity);
        long baseCapacity = this.baseGraph.nodes.getCapacity();
        long pointer = this.N_CH_REF;
        long basePointer = this.baseGraph.N_EDGE_REF;
        while (pointer < maxCapacity) {
            if (basePointer >= baseCapacity) {
                throw new IllegalStateException("Cannot copy edge refs into ch graph. pointer:" + pointer + ", cap:" + maxCapacity + ", basePtr:" + basePointer + ", baseCap:" + baseCapacity);
            }
            this.nodesCH.setInt(pointer, this.baseGraph.nodes.getInt(basePointer));
            pointer += (long)this.nodeCHEntryBytes;
            basePointer += (long)this.baseGraph.nodeEntryBytes;
        }
        this.isReadyForContraction = true;
    }

    String toDetailsString() {
        return this.toString() + ", shortcuts:" + Helper.nf(this.shortcutCount) + ", nodesCH:(" + this.nodesCH.getCapacity() / 0x100000L + "MB)";
    }

    @Override
    public AllCHEdgesIterator getAllEdges() {
        return new AllCHEdgesIteratorImpl(this.baseGraph);
    }

    void loadNodesHeader() {
        this.isReadyForContraction = this.nodesCH.getHeader(0) == 1;
    }

    void setNodesHeader() {
        this.nodesCH.setHeader(0, this.isReadyForContraction ? 1 : 0);
    }

    protected int loadEdgesHeader() {
        this.shortcutCount = this.shortcuts.getHeader(0);
        this.shortcutEntryBytes = this.shortcuts.getHeader(4);
        return 3;
    }

    int setEdgesHeader() {
        this.shortcuts.setHeader(0, this.shortcutCount);
        this.shortcuts.setHeader(4, this.shortcutEntryBytes);
        return 3;
    }

    @Override
    public Graph getBaseGraph() {
        return this.baseGraph;
    }

    void initStorage() {
        EdgeAccess ea = this.baseGraph.edgeAccess;
        this.chEdgeAccess.init(ea.E_NODEA, ea.E_NODEB, ea.E_LINKA, ea.E_LINKB, ea.E_FLAGS);
        this.S_SKIP_EDGE1 = ea.E_FLAGS + 4;
        this.S_SKIP_EDGE2 = this.S_SKIP_EDGE1 + 4;
        if (this.chConfig.isEdgeBased()) {
            this.S_ORIG_FIRST = this.S_SKIP_EDGE2 + 4;
            this.S_ORIG_LAST = this.S_ORIG_FIRST + 4;
            this.shortcutEntryBytes = this.S_ORIG_LAST + 4;
        } else {
            this.shortcutEntryBytes = this.S_SKIP_EDGE2 + 4;
        }
        this.N_LEVEL = 0;
        this.N_CH_REF = this.N_LEVEL + 4;
        this.nodeCHEntryBytes = this.N_CH_REF + 4;
    }

    @Override
    public CHGraph create(long bytes) {
        this.nodesCH.create(bytes);
        this.shortcuts.create(bytes);
        return this;
    }

    @Override
    public boolean loadExisting() {
        if (!this.nodesCH.loadExisting() || !this.shortcuts.loadExisting()) {
            return false;
        }
        this.loadNodesHeader();
        this.loadEdgesHeader();
        return true;
    }

    @Override
    public void flush() {
        this.setNodesHeader();
        this.setEdgesHeader();
        this.nodesCH.flush();
        this.shortcuts.flush();
    }

    @Override
    public void close() {
        this.nodesCH.close();
        this.shortcuts.close();
    }

    @Override
    public boolean isClosed() {
        return this.nodesCH.isClosed();
    }

    @Override
    public long getCapacity() {
        return this.nodesCH.getCapacity() + this.shortcuts.getCapacity();
    }

    public String toString() {
        return "CHGraph|" + this.chConfig.getName() + "|" + (Object)((Object)this.chConfig.getTraversalMode());
    }

    public void debugPrint() {
        int printMax = 100;
        System.out.println("nodesCH:");
        String formatNodes = "%12s | %12s | %12s \n";
        System.out.format(Locale.ROOT, formatNodes, "#", "N_CH_REF", "N_LEVEL");
        for (int i = 0; i < Math.min(this.baseGraph.getNodes(), 100); ++i) {
            System.out.format(Locale.ROOT, formatNodes, i, this.chEdgeAccess.getEdgeRef(i), this.getLevel(i));
        }
        if (this.baseGraph.getNodes() > 100) {
            System.out.format(Locale.ROOT, " ... %d more nodes", this.baseGraph.getNodes() - 100);
        }
        System.out.println("shortcuts:");
        String formatShortcutsBase = "%12s | %12s | %12s | %12s | %12s | %12s | %12s | %12s";
        String formatShortcutExt = " | %12s | %12s";
        String header = String.format(Locale.ROOT, formatShortcutsBase, "#", "E_NODEA", "E_NODEB", "E_LINKA", "E_LINKB", "E_FLAGS", "S_SKIP_EDGE1", "S_SKIP_EDGE2");
        if (this.chConfig.isEdgeBased()) {
            header = header + String.format(Locale.ROOT, formatShortcutExt, "S_ORIG_FIRST", "S_ORIG_LAST");
        }
        System.out.println(header);
        for (int i = this.baseGraph.edgeCount; i < this.baseGraph.edgeCount + Math.min(this.shortcutCount, 100); ++i) {
            long edgePointer = this.chEdgeAccess.toPointer(i);
            String edgeString = String.format(Locale.ROOT, formatShortcutsBase, i, this.chEdgeAccess.getNodeA(edgePointer), this.chEdgeAccess.getNodeB(edgePointer), this.chEdgeAccess.getLinkA(edgePointer), this.chEdgeAccess.getLinkB(edgePointer), this.chEdgeAccess.getShortcutFlags(edgePointer), this.shortcuts.getInt(edgePointer + (long)this.S_SKIP_EDGE1), this.shortcuts.getInt(edgePointer + (long)this.S_SKIP_EDGE2));
            if (this.chConfig.isEdgeBased()) {
                edgeString = edgeString + String.format(Locale.ROOT, formatShortcutExt, this.shortcuts.getInt(edgePointer + (long)this.S_ORIG_FIRST), this.shortcuts.getInt(edgePointer + (long)this.S_ORIG_LAST));
            }
            System.out.println(edgeString);
        }
        if (this.shortcutCount > 100) {
            System.out.printf(Locale.ROOT, " ... %d more shortcut edges\n", this.shortcutCount - 100);
        }
    }

    @Override
    public NodeOrderingProvider getNodeOrderingProvider() {
        int numNodes = this.getNodes();
        final int[] nodeOrdering = new int[numNodes];
        int i = 0;
        while (i < numNodes) {
            int level = this.getLevel(i);
            nodeOrdering[level] = i++;
        }
        return new NodeOrderingProvider(){

            @Override
            public int getNodeIdForLevel(int level) {
                return nodeOrdering[level];
            }

            @Override
            public int getNumNodes() {
                return nodeOrdering.length;
            }
        };
    }

    private class CHEdgeIteratorStateImpl
    implements CHEdgeIteratorState {
        final BaseGraph.EdgeIteratorStateImpl edgeIterable;
        private int chFlags;

        private CHEdgeIteratorStateImpl(BaseGraph.EdgeIteratorStateImpl edgeIterable) {
            this.edgeIterable = edgeIterable;
        }

        boolean init(int edgeId, int expectedAdjNode) {
            this.selectEdgeAccess(edgeId);
            return this.edgeIterable.init(edgeId, expectedAdjNode);
        }

        void selectEdgeAccess(int edgeId) {
            this.edgeIterable.edgeAccess = edgeId < this.edgeIterable.baseGraph.edgeCount ? this.edgeIterable.baseGraph.edgeAccess : CHGraphImpl.this.chEdgeAccess;
        }

        @Override
        public int getBaseNode() {
            return this.edgeIterable.getBaseNode();
        }

        @Override
        public int getAdjNode() {
            return this.edgeIterable.getAdjNode();
        }

        @Override
        public int getEdge() {
            return this.edgeIterable.getEdge();
        }

        @Override
        public EdgeIteratorState setFlags(IntsRef edgeFlags) {
            return this.edgeIterable.setFlags(edgeFlags);
        }

        @Override
        public final IntsRef getFlags() {
            this.checkShortcut(false, "getFlags");
            return this.edgeIterable.getFlags();
        }

        @Override
        public EdgeIteratorState copyPropertiesFrom(EdgeIteratorState e) {
            return this.edgeIterable.copyPropertiesFrom(e);
        }

        @Override
        public double getDistance() {
            this.checkShortcut(false, "getDistance");
            return this.edgeIterable.getDistance();
        }

        @Override
        public EdgeIteratorState setDistance(double dist) {
            this.checkShortcut(false, "setDistance");
            return this.edgeIterable.setDistance(dist);
        }

        @Override
        public final CHEdgeIteratorState setSkippedEdges(int edge1, int edge2) {
            this.checkShortcut(true, "setSkippedEdges");
            CHGraphImpl.this.chEdgeAccess.setSkippedEdges(this.edgeIterable.edgePointer, edge1, edge2);
            return this;
        }

        @Override
        public final int getSkippedEdge1() {
            this.checkShortcut(true, "getSkippedEdge1");
            return CHGraphImpl.this.shortcuts.getInt(this.edgeIterable.edgePointer + (long)CHGraphImpl.this.S_SKIP_EDGE1);
        }

        @Override
        public final int getSkippedEdge2() {
            this.checkShortcut(true, "getSkippedEdge2");
            return CHGraphImpl.this.shortcuts.getInt(this.edgeIterable.edgePointer + (long)CHGraphImpl.this.S_SKIP_EDGE2);
        }

        @Override
        public int getOrigEdgeFirst() {
            if (!this.isShortcut() || !CHGraphImpl.this.chConfig.isEdgeBased()) {
                return this.getEdge();
            }
            return CHGraphImpl.this.shortcuts.getInt(this.edgeIterable.edgePointer + (long)CHGraphImpl.this.S_ORIG_FIRST);
        }

        @Override
        public int getOrigEdgeLast() {
            if (!this.isShortcut() || !CHGraphImpl.this.chConfig.isEdgeBased()) {
                return this.getEdge();
            }
            return CHGraphImpl.this.shortcuts.getInt(this.edgeIterable.edgePointer + (long)CHGraphImpl.this.S_ORIG_LAST);
        }

        @Override
        public boolean isShortcut() {
            return this.edgeIterable.edgeId >= this.edgeIterable.baseGraph.edgeCount;
        }

        @Override
        public boolean getFwdAccess() {
            return (this.getShortcutFlags() & (this.edgeIterable.reverse ? PrepareEncoder.getScBwdDir() : PrepareEncoder.getScFwdDir())) != 0;
        }

        @Override
        public boolean getBwdAccess() {
            return (this.getShortcutFlags() & (this.edgeIterable.reverse ? PrepareEncoder.getScFwdDir() : PrepareEncoder.getScBwdDir())) != 0;
        }

        @Override
        public boolean get(BooleanEncodedValue property) {
            if (this.isShortcut()) {
                return this.getFwdAccess();
            }
            return property.getBool(this.edgeIterable.reverse, this.getFlags());
        }

        @Override
        public boolean getReverse(BooleanEncodedValue property) {
            if (this.isShortcut()) {
                return this.getBwdAccess();
            }
            return property.getBool(!this.edgeIterable.reverse, this.getFlags());
        }

        @Override
        public final CHEdgeIteratorState setWeight(double weight) {
            this.checkShortcut(true, "setWeight");
            CHGraphImpl.this.chEdgeAccess.setShortcutWeight(this.edgeIterable.edgePointer, weight);
            return this;
        }

        @Override
        public void setFlagsAndWeight(int flags, double weight) {
            this.checkShortcut(true, "setFlagsAndWeight");
            CHGraphImpl.this.chEdgeAccess.setAccessAndWeight(this.edgeIterable.edgePointer, flags, weight);
            this.chFlags = flags;
            this.edgeIterable.freshFlags = true;
        }

        @Override
        public final double getWeight() {
            this.checkShortcut(true, "getWeight");
            return CHGraphImpl.this.chEdgeAccess.getShortcutWeight(this.edgeIterable.edgePointer);
        }

        void checkShortcut(boolean shouldBeShortcut, String methodName) {
            if (this.isShortcut()) {
                if (!shouldBeShortcut) {
                    throw new IllegalStateException("Cannot call " + methodName + " on shortcut " + this.getEdge());
                }
            } else if (shouldBeShortcut) {
                throw new IllegalStateException("Method " + methodName + " only for shortcuts " + this.getEdge());
            }
        }

        @Override
        public final String getName() {
            this.checkShortcut(false, "getName");
            return this.edgeIterable.getName();
        }

        @Override
        public final EdgeIteratorState setName(String name) {
            this.checkShortcut(false, "setName");
            return this.edgeIterable.setName(name);
        }

        @Override
        public final PointList fetchWayGeometry(FetchMode mode) {
            this.checkShortcut(false, "fetchWayGeometry");
            return this.edgeIterable.fetchWayGeometry(mode);
        }

        @Override
        public final EdgeIteratorState setWayGeometry(PointList list) {
            this.checkShortcut(false, "setWayGeometry");
            return this.edgeIterable.setWayGeometry(list);
        }

        @Override
        public EdgeIteratorState set(BooleanEncodedValue property, boolean value) {
            return this.edgeIterable.set(property, value);
        }

        @Override
        public EdgeIteratorState setReverse(BooleanEncodedValue property, boolean value) {
            return this.edgeIterable.setReverse(property, value);
        }

        @Override
        public int get(IntEncodedValue property) {
            return this.edgeIterable.get(property);
        }

        @Override
        public EdgeIteratorState set(IntEncodedValue property, int value) {
            return this.edgeIterable.set(property, value);
        }

        @Override
        public int getReverse(IntEncodedValue property) {
            return this.edgeIterable.getReverse(property);
        }

        @Override
        public EdgeIteratorState setReverse(IntEncodedValue property, int value) {
            return this.edgeIterable.setReverse(property, value);
        }

        @Override
        public double get(DecimalEncodedValue property) {
            return this.edgeIterable.get(property);
        }

        @Override
        public EdgeIteratorState set(DecimalEncodedValue property, double value) {
            return this.edgeIterable.set(property, value);
        }

        @Override
        public double getReverse(DecimalEncodedValue property) {
            return this.edgeIterable.getReverse(property);
        }

        @Override
        public EdgeIteratorState setReverse(DecimalEncodedValue property, double value) {
            return this.edgeIterable.setReverse(property, value);
        }

        @Override
        public <T extends Enum> T get(EnumEncodedValue<T> property) {
            return this.edgeIterable.get(property);
        }

        @Override
        public <T extends Enum> EdgeIteratorState set(EnumEncodedValue<T> property, T value) {
            return this.edgeIterable.set(property, value);
        }

        @Override
        public <T extends Enum> T getReverse(EnumEncodedValue<T> property) {
            return this.edgeIterable.getReverse(property);
        }

        @Override
        public <T extends Enum> EdgeIteratorState setReverse(EnumEncodedValue<T> property, T value) {
            return this.edgeIterable.setReverse(property, value);
        }

        @Override
        public EdgeIteratorState detach(boolean reverseArg) {
            return this.edgeIterable.detach(reverseArg);
        }

        int getShortcutFlags() {
            if (!this.edgeIterable.freshFlags) {
                this.chFlags = CHGraphImpl.this.chEdgeAccess.getShortcutFlags(this.edgeIterable.edgePointer);
                this.edgeIterable.freshFlags = true;
            }
            return this.chFlags;
        }
    }

    private class CHEdgeAccess
    extends EdgeAccess {
        private final String name;

        public CHEdgeAccess(String name) {
            super(CHGraphImpl.this.shortcuts);
            this.name = name;
        }

        @Override
        final int getEdgeRef(int nodeId) {
            return CHGraphImpl.this.nodesCH.getInt((long)nodeId * (long)CHGraphImpl.this.nodeCHEntryBytes + (long)CHGraphImpl.this.N_CH_REF);
        }

        @Override
        final void setEdgeRef(int nodeId, int edgeId) {
            CHGraphImpl.this.nodesCH.setInt((long)nodeId * (long)CHGraphImpl.this.nodeCHEntryBytes + (long)CHGraphImpl.this.N_CH_REF, edgeId);
        }

        @Override
        final int getEntryBytes() {
            return CHGraphImpl.this.shortcutEntryBytes;
        }

        void setShortcutFlags(long edgePointer, int flags) {
            this.edges.setInt(edgePointer + (long)this.E_FLAGS, flags);
        }

        int getShortcutFlags(long edgePointer) {
            return this.edges.getInt(edgePointer + (long)this.E_FLAGS);
        }

        void setShortcutWeight(long edgePointer, double weight) {
            int accessFlags = this.getShortcutFlags(edgePointer) & CHGraphImpl.this.scDirMask;
            this.setAccessAndWeight(edgePointer, accessFlags, weight);
        }

        void setAccessAndWeight(long edgePointer, int accessFlags, double weight) {
            int weightFlags = this.weightToWeightFlags(edgePointer, weight);
            this.setShortcutFlags(edgePointer, weightFlags | accessFlags);
        }

        int weightToWeightFlags(long edgePointer, double weight) {
            if (weight < 0.0) {
                throw new IllegalArgumentException("weight cannot be negative but was " + weight);
            }
            if (weight < 0.001) {
                NodeAccess nodeAccess = CHGraphImpl.this.baseGraph.getNodeAccess();
                int edgeId = -1;
                LOGGER.warn("Setting weights smaller than 0.001 is not allowed in CHGraphImpl#setWeight. You passed: " + weight + " for the edge " + edgeId + " nodeA " + nodeAccess.getLat(this.getNodeA(edgePointer)) + "," + nodeAccess.getLon(this.getNodeA(edgePointer)) + " nodeB " + nodeAccess.getLat(this.getNodeB(edgePointer)) + "," + nodeAccess.getLon(this.getNodeB(edgePointer)));
                weight = 0.001;
            }
            int weightInt = weight > 536870.911 ? 0x7FFFFFFC : (int)Math.round(weight * 1000.0) << 2;
            return weightInt;
        }

        double getShortcutWeight(long edgePointer) {
            long flags32bit = this.getShortcutFlags(edgePointer);
            double weight = (double)(flags32bit >>> 2) / 1000.0;
            if (weight >= 536870.911) {
                return Double.POSITIVE_INFINITY;
            }
            return weight;
        }

        void setSkippedEdges(long edgePointer, int edge1, int edge2) {
            if (EdgeIterator.Edge.isValid(edge1) != EdgeIterator.Edge.isValid(edge2)) {
                throw new IllegalStateException("Skipped edges of a shortcut needs to be both valid or invalid but they were not " + edge1 + ", " + edge2);
            }
            CHGraphImpl.this.shortcuts.setInt(edgePointer + (long)CHGraphImpl.this.S_SKIP_EDGE1, edge1);
            CHGraphImpl.this.shortcuts.setInt(edgePointer + (long)CHGraphImpl.this.S_SKIP_EDGE2, edge2);
        }

        public void setFirstAndLastOrigEdges(long edgePointer, int origFirst, int origLast) {
            if (!CHGraphImpl.this.chConfig.isEdgeBased()) {
                throw new IllegalStateException("Edge-based shortcuts should only be added when CHGraph is edge-based");
            }
            CHGraphImpl.this.shortcuts.setInt(edgePointer + (long)CHGraphImpl.this.S_ORIG_FIRST, origFirst);
            CHGraphImpl.this.shortcuts.setInt(edgePointer + (long)CHGraphImpl.this.S_ORIG_LAST, origLast);
        }

        @Override
        final long toPointer(int shortcutId) {
            assert (this.isInBounds(shortcutId)) : "shortcutId " + shortcutId + " not in bounds [" + CHGraphImpl.access$300((CHGraphImpl)CHGraphImpl.this).edgeCount + ", " + (CHGraphImpl.access$300((CHGraphImpl)CHGraphImpl.this).edgeCount + CHGraphImpl.access$200(CHGraphImpl.this)) + ")";
            return (long)(shortcutId - ((CHGraphImpl)CHGraphImpl.this).baseGraph.edgeCount) * (long)CHGraphImpl.this.shortcutEntryBytes;
        }

        @Override
        final boolean isInBounds(int shortcutId) {
            int tmp = shortcutId - ((CHGraphImpl)CHGraphImpl.this).baseGraph.edgeCount;
            return tmp < CHGraphImpl.this.shortcutCount && tmp >= 0;
        }

        public String toString() {
            return "ch edge access " + this.name;
        }
    }

    class AllCHEdgesIteratorImpl
    extends CHEdgeIteratorStateImpl
    implements AllCHEdgesIterator {
        private final BaseGraph.AllEdgeIterator allEdgeIterator;

        public AllCHEdgesIteratorImpl(BaseGraph baseGraph) {
            super(new BaseGraph.AllEdgeIterator(baseGraph));
            this.allEdgeIterator = (BaseGraph.AllEdgeIterator)this.edgeIterable;
        }

        @Override
        public boolean next() {
            ++this.allEdgeIterator.edgeId;
            this.allEdgeIterator.edgePointer = (long)this.allEdgeIterator.edgeId * (long)this.allEdgeIterator.edgeAccess.getEntryBytes();
            if (!this.checkRange()) {
                return false;
            }
            this.allEdgeIterator.adjNode = this.allEdgeIterator.edgeAccess.getNodeB(this.allEdgeIterator.edgePointer);
            this.allEdgeIterator.baseNode = this.allEdgeIterator.edgeAccess.getNodeA(this.allEdgeIterator.edgePointer);
            this.allEdgeIterator.freshFlags = false;
            this.allEdgeIterator.reverse = false;
            return true;
        }

        @Override
        public EdgeIteratorState detach(boolean reverseArg) {
            return this.allEdgeIterator.detach(reverseArg);
        }

        private boolean checkRange() {
            if (this.isShortcut()) {
                return this.allEdgeIterator.edgeId < CHGraphImpl.this.shortcutCount;
            }
            if (this.allEdgeIterator.edgeId < ((CHGraphImpl)CHGraphImpl.this).baseGraph.edgeCount) {
                return true;
            }
            this.allEdgeIterator.edgeAccess = CHGraphImpl.this.chEdgeAccess;
            this.allEdgeIterator.edgeId = 0;
            this.allEdgeIterator.edgePointer = (long)this.allEdgeIterator.edgeId * (long)CHGraphImpl.this.shortcutEntryBytes;
            return this.allEdgeIterator.edgeId < CHGraphImpl.this.shortcutCount;
        }

        @Override
        public int getEdge() {
            if (this.isShortcut()) {
                return ((CHGraphImpl)CHGraphImpl.this).baseGraph.edgeCount + this.allEdgeIterator.edgeId;
            }
            return super.getEdge();
        }

        @Override
        public int length() {
            return ((CHGraphImpl)CHGraphImpl.this).baseGraph.edgeCount + CHGraphImpl.this.shortcutCount;
        }

        @Override
        public final boolean isShortcut() {
            assert (CHGraphImpl.this.baseGraph.isFrozen()) : "level graph not yet frozen";
            return this.edgeIterable.edgeAccess == CHGraphImpl.this.chEdgeAccess;
        }
    }

    class CHEdgeIteratorImpl
    extends CHEdgeIteratorStateImpl
    implements CHEdgeExplorer,
    CHEdgeIterator {
        private final BaseGraph.EdgeIteratorImpl baseIterator;

        public CHEdgeIteratorImpl(BaseGraph baseGraph, EdgeAccess edgeAccess, EdgeFilter filter) {
            super(new BaseGraph.EdgeIteratorImpl(baseGraph, edgeAccess, filter));
            this.baseIterator = (BaseGraph.EdgeIteratorImpl)this.edgeIterable;
        }

        @Override
        public final CHEdgeIterator setBaseNode(int baseNode) {
            assert (this.baseIterator.baseGraph.isFrozen()) : "Traversing CHGraph is only possible if BaseGraph is frozen";
            this.baseIterator.setEdgeId(CHGraphImpl.this.chEdgeAccess.getEdgeRef(baseNode));
            this.baseIterator._setBaseNode(baseNode);
            return this;
        }

        @Override
        public boolean next() {
            do {
                if (!EdgeIterator.Edge.isValid(this.baseIterator.nextEdgeId)) {
                    return false;
                }
                this.selectEdgeAccess(this.baseIterator.nextEdgeId);
                this.baseIterator.goToNext();
            } while (!this.baseIterator.filter.accept(this));
            return true;
        }

        public String toString() {
            return this.baseIterator.toString();
        }
    }
}

