/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting.custom;

import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.weighting.custom.EdgeToValueEntry;
import com.graphhopper.util.EdgeIteratorState;
import java.util.Arrays;
import java.util.Map;

final class EnumToValueEntry
implements EdgeToValueEntry {
    private final IntEncodedValue eev;
    private final double[] values;

    private EnumToValueEntry(EnumEncodedValue eev, double[] values) {
        this.eev = eev;
        this.values = values;
    }

    @Override
    public double getValue(EdgeIteratorState iter, boolean reverse) {
        int enumOrdinal = reverse ? iter.getReverse(this.eev) : iter.get(this.eev);
        return this.values[enumOrdinal];
    }

    static EnumToValueEntry create(String name, EnumEncodedValue enumEncodedValue, Map<String, Object> map, double defaultValue, double minValue, double maxValue) {
        Enum[] enumValues = enumEncodedValue.getValues();
        if (map.isEmpty()) {
            throw new IllegalArgumentException("Empty map for " + name);
        }
        Object evEntryValue = map.get("*");
        if (evEntryValue != null) {
            defaultValue = EnumToValueEntry.getReturnValue(name, "*", evEntryValue, minValue, maxValue);
        }
        double[] tmp = new double[enumValues.length];
        Arrays.fill(tmp, defaultValue);
        for (Map.Entry<String, Object> encValEntry : map.entrySet()) {
            double returnValue;
            if (encValEntry.getKey() == null) {
                throw new IllegalArgumentException("key for " + name + " cannot be null, value: " + encValEntry.getValue());
            }
            String key = encValEntry.getKey();
            if ("*".equals(key)) continue;
            Enum enumValue = EnumToValueEntry.getValueOf(enumValues, key);
            tmp[enumValue.ordinal()] = returnValue = EnumToValueEntry.getReturnValue(name, key, encValEntry.getValue(), minValue, maxValue);
        }
        return new EnumToValueEntry(enumEncodedValue, tmp);
    }

    static double getReturnValue(String name, String key, Object valueObject, double minValue, double maxValue) {
        if (valueObject == null) {
            throw new IllegalArgumentException("value for " + name + " cannot be null, key: " + key);
        }
        if (!(valueObject instanceof Number)) {
            throw new IllegalArgumentException("value for " + name + " has to be a number but was: " + valueObject.getClass().getSimpleName());
        }
        double value = ((Number)valueObject).doubleValue();
        if (value < minValue) {
            throw new IllegalArgumentException(name + " cannot be smaller than " + minValue + ", was " + value);
        }
        if (value > maxValue) {
            throw new IllegalArgumentException(name + " cannot be bigger than " + maxValue + ", was " + value);
        }
        return value;
    }

    private static Enum getValueOf(Enum[] enumValues, String enumToString) {
        for (Enum e : enumValues) {
            if (!e.toString().equals(enumToString)) continue;
            return e;
        }
        throw new IllegalArgumentException("Cannot find enum " + enumToString + " in " + Arrays.toString(enumValues));
    }

    public String toString() {
        return this.eev.getName() + ": " + Arrays.toString(this.values);
    }
}

