/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.spatialrules.countries;

import com.graphhopper.routing.ev.Country;
import com.graphhopper.routing.ev.RoadAccess;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.util.spatialrules.AbstractSpatialRule;
import com.graphhopper.routing.util.spatialrules.TransportationMode;
import java.util.List;
import org.locationtech.jts.geom.Polygon;

public class GermanySpatialRule
extends AbstractSpatialRule {
    public GermanySpatialRule(List<Polygon> borders) {
        super(borders);
    }

    @Override
    public double getMaxSpeed(RoadClass roadClass, TransportationMode transport, double currentMaxSpeed) {
        if (!Double.isNaN(currentMaxSpeed) || transport != TransportationMode.MOTOR_VEHICLE) {
            return currentMaxSpeed;
        }
        switch (roadClass) {
            case MOTORWAY: 
            case TRUNK: {
                return 150.0;
            }
            case PRIMARY: {
                return 100.0;
            }
            case SECONDARY: {
                return 100.0;
            }
            case TERTIARY: {
                return 100.0;
            }
            case UNCLASSIFIED: {
                return 100.0;
            }
            case RESIDENTIAL: {
                return 100.0;
            }
            case LIVING_STREET: {
                return 4.0;
            }
        }
        return Double.NaN;
    }

    @Override
    public RoadAccess getAccess(RoadClass roadClass, TransportationMode transport, RoadAccess currentRoadAccess) {
        if (currentRoadAccess != RoadAccess.YES) {
            return currentRoadAccess;
        }
        if (transport != TransportationMode.MOTOR_VEHICLE) {
            return RoadAccess.YES;
        }
        switch (roadClass) {
            case TRACK: {
                return RoadAccess.DESTINATION;
            }
            case PATH: 
            case BRIDLEWAY: 
            case CYCLEWAY: 
            case FOOTWAY: 
            case PEDESTRIAN: {
                return RoadAccess.NO;
            }
        }
        return RoadAccess.YES;
    }

    @Override
    public String getId() {
        return Country.DEU.toString();
    }
}

