/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.routing.util.spatialrules.SpatialRuleLookup;
import com.graphhopper.routing.util.spatialrules.SpatialRuleSet;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.shapes.GHPoint;
import java.util.List;

public class SpatialRuleParser
implements TagParser {
    private final IntEncodedValue spatialRuleEnc;
    private SpatialRuleLookup spatialRuleLookup;

    public SpatialRuleParser(SpatialRuleLookup spatialRuleLookup, IntEncodedValue spatialRuleEnc) {
        this.spatialRuleLookup = spatialRuleLookup;
        if (spatialRuleEnc == null) {
            throw new IllegalStateException("SpatialRuleLookup was not initialized before building the EncodingManager");
        }
        this.spatialRuleEnc = spatialRuleEnc;
    }

    @Override
    public void createEncodedValues(EncodedValueLookup lookup, List<EncodedValue> registerNewEncodedValue) {
        registerNewEncodedValue.add(this.spatialRuleEnc);
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way, boolean ferry, IntsRef relationFlags) {
        GHPoint estimatedCenter = way.getTag("estimated_center", null);
        if (estimatedCenter != null) {
            SpatialRuleSet ruleSet = this.spatialRuleLookup.lookupRules(estimatedCenter.lat, estimatedCenter.lon);
            way.setTag("spatial_rule_set", ruleSet);
            this.spatialRuleEnc.setInt(false, edgeFlags, ruleSet.getSpatialId());
        }
        return edgeFlags;
    }
}

