/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.parsers.RelationTagParser;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.Helper;
import java.util.List;

public class OSMFootNetworkTagParser
implements RelationTagParser {
    private EnumEncodedValue<RouteNetwork> footRouteEnc;
    private EnumEncodedValue<RouteNetwork> transformerRouteRelEnc;

    @Override
    public void createRelationEncodedValues(EncodedValueLookup lookup, List<EncodedValue> registerNewEncodedValue) {
        this.transformerRouteRelEnc = new EnumEncodedValue<RouteNetwork>(EncodingManager.getKey("foot", "route_relation"), RouteNetwork.class);
        registerNewEncodedValue.add(this.transformerRouteRelEnc);
    }

    @Override
    public IntsRef handleRelationTags(IntsRef relFlags, ReaderRelation relation) {
        RouteNetwork oldFootNetwork = this.transformerRouteRelEnc.getEnum(false, relFlags);
        if (relation.hasTag("route", (Object)"hiking") || relation.hasTag("route", (Object)"foot")) {
            String tag = Helper.toLowerCase(relation.getTag("network", ""));
            RouteNetwork newFootNetwork = RouteNetwork.LOCAL;
            if ("lwn".equals(tag)) {
                newFootNetwork = RouteNetwork.LOCAL;
            } else if ("rwn".equals(tag)) {
                newFootNetwork = RouteNetwork.REGIONAL;
            } else if ("nwn".equals(tag)) {
                newFootNetwork = RouteNetwork.NATIONAL;
            } else if ("iwn".equals(tag)) {
                newFootNetwork = RouteNetwork.INTERNATIONAL;
            }
            if (oldFootNetwork == RouteNetwork.OTHER || oldFootNetwork.ordinal() > newFootNetwork.ordinal()) {
                this.transformerRouteRelEnc.setEnum(false, relFlags, newFootNetwork);
            }
        }
        return relFlags;
    }

    @Override
    public void createEncodedValues(EncodedValueLookup lookup, List<EncodedValue> registerNewEncodedValue) {
        this.footRouteEnc = new EnumEncodedValue<RouteNetwork>(RouteNetwork.key("foot"), RouteNetwork.class);
        registerNewEncodedValue.add(this.footRouteEnc);
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way, boolean ferry, IntsRef relationFlags) {
        RouteNetwork footNetwork = this.transformerRouteRelEnc.getEnum(false, relationFlags);
        this.footRouteEnc.setEnum(false, edgeFlags, footNetwork);
        return edgeFlags;
    }
}

