/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.apache.commons.lang3.StringUtils;
import com.graphhopper.debatty.java.stringsimilarity.JaroWinkler;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.Circle;
import com.graphhopper.util.shapes.GHPoint;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NameSimilarityEdgeFilter
implements EdgeFilter {
    private static final Map<String, String> DEFAULT_REWRITE_MAP = new HashMap<String, String>(){
        {
            for (String remove : Arrays.asList("ally", "alley", "arc", "arcade", "bvd", "bvd.", "boulevard", "av.", "avenue", "avenida", "calle", "cl.", "close", "crescend", "cres", "cres.", "rd.", "road", "ln.", "lane", "pde.", "pde", "parade", "pl.", "place", "plaza", "rte", "route", "str.", "str", "stra\u00dfe", "strasse", "st.", "street", "strada", "sq.", "square", "tr.", "track", "via")) {
                this.put(remove, "");
            }
            this.put("n", "north");
            this.put("s", "south");
            this.put("w", "west");
            this.put("e", "east");
            this.put("ne", "northeast");
            this.put("nw", "northwest");
            this.put("se", "southeast");
            this.put("sw", "southwest");
        }
    };
    private static final Pattern WORD_CHAR = Pattern.compile("\\p{LD}+");
    private static final JaroWinkler jaroWinkler = new JaroWinkler();
    private static final double JARO_WINKLER_ACCEPT_FACTOR = 0.9;
    private final EdgeFilter edgeFilter;
    private final String pointHint;
    private final Map<String, String> rewriteMap;
    private final Circle pointCircle;

    public NameSimilarityEdgeFilter(EdgeFilter edgeFilter, String pointHint, GHPoint point, double radius) {
        this(edgeFilter, pointHint, point, radius, DEFAULT_REWRITE_MAP);
    }

    public NameSimilarityEdgeFilter(EdgeFilter edgeFilter, String pointHint, GHPoint point, double radius, Map<String, String> rewriteMap) {
        this.edgeFilter = edgeFilter;
        this.rewriteMap = rewriteMap;
        this.pointHint = this.prepareName(this.removeRelation(pointHint == null ? "" : pointHint));
        this.pointCircle = new Circle(point.lat, point.lon, radius);
    }

    String getNormalizedPointHint() {
        return this.pointHint;
    }

    private String prepareName(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        Matcher wordCharMatcher = WORD_CHAR.matcher(name);
        while (wordCharMatcher.find()) {
            String normalizedToken = Helper.toLowerCase(wordCharMatcher.group());
            String rewrite = this.rewriteMap.get(normalizedToken);
            if (rewrite != null) {
                normalizedToken = rewrite;
            }
            if (normalizedToken.isEmpty()) continue;
            if (normalizedToken.length() > 2) {
                sb.append(normalizedToken);
                continue;
            }
            if (!Character.isDigit(normalizedToken.charAt(0)) || normalizedToken.length() != 1 && !Character.isDigit(normalizedToken.charAt(1))) continue;
            sb.append(normalizedToken);
        }
        return sb.toString();
    }

    private String removeRelation(String edgeName) {
        int index = edgeName.lastIndexOf(", ");
        return index >= 0 ? edgeName.substring(0, index) : edgeName;
    }

    @Override
    public final boolean accept(EdgeIteratorState iter) {
        if (!this.edgeFilter.accept(iter)) {
            return false;
        }
        if (this.pointHint.isEmpty()) {
            return true;
        }
        String name = iter.getName();
        if (name == null || name.isEmpty()) {
            return false;
        }
        BBox bbox = GHUtility.createBBox(iter);
        if (!this.pointCircle.intersects(bbox)) {
            return false;
        }
        name = this.removeRelation(name);
        String edgeName = this.prepareName(name);
        return this.isJaroWinklerSimilar(this.pointHint, edgeName);
    }

    private static BBox createBBox(NodeAccess na, EdgeIteratorState edgeState) {
        return BBox.fromPoints(na.getLatitude(edgeState.getBaseNode()), na.getLongitude(edgeState.getBaseNode()), na.getLatitude(edgeState.getAdjNode()), na.getLongitude(edgeState.getAdjNode()));
    }

    private boolean isJaroWinklerSimilar(String str1, String str2) {
        double jwSimilarity = jaroWinkler.similarity(str1, str2);
        return jwSimilarity > 0.9;
    }

    private boolean isLevenshteinSimilar(String hint, String name) {
        if (Math.min(name.length(), hint.length()) * 4 < Math.max(name.length(), hint.length())) {
            return false;
        }
        int factor = 1 + Math.abs(hint.length() - name.length());
        int levDistance = StringUtils.getLevenshteinDistance(hint, name);
        return levDistance <= factor;
    }
}

