/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.routing.BidirPathExtractor;
import com.graphhopper.routing.ch.ShortcutUnpacker;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.util.EdgeIteratorState;

public class NodeBasedCHBidirPathExtractor
extends BidirPathExtractor {
    private final ShortcutUnpacker shortcutUnpacker;
    private final RoutingCHGraph routingGraph;

    public NodeBasedCHBidirPathExtractor(RoutingCHGraph routingGraph) {
        super(routingGraph.getBaseGraph(), routingGraph.getWeighting());
        this.routingGraph = routingGraph;
        this.shortcutUnpacker = this.createShortcutUnpacker();
    }

    @Override
    public void onEdge(int edge, int adjNode, boolean reverse, int prevOrNextEdge) {
        if (reverse) {
            this.shortcutUnpacker.visitOriginalEdgesBwd(edge, adjNode, true, prevOrNextEdge);
        } else {
            this.shortcutUnpacker.visitOriginalEdgesFwd(edge, adjNode, true, prevOrNextEdge);
        }
    }

    private ShortcutUnpacker createShortcutUnpacker() {
        return new ShortcutUnpacker(this.routingGraph, new ShortcutUnpacker.Visitor(){

            @Override
            public void visit(EdgeIteratorState edge, boolean reverse, int prevOrNextEdgeId) {
                NodeBasedCHBidirPathExtractor.this.path.addDistance(edge.getDistance());
                NodeBasedCHBidirPathExtractor.this.path.addTime(NodeBasedCHBidirPathExtractor.this.routingGraph.getWeighting().calcEdgeMillis(edge, reverse));
                NodeBasedCHBidirPathExtractor.this.path.addEdge(edge.getEdge());
            }
        }, false);
    }
}

