/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.routing.ch.EdgeBasedNodeContractor;
import com.graphhopper.routing.ch.PrepareEncoder;
import com.graphhopper.routing.util.AllCHEdgesIterator;
import com.graphhopper.storage.CHGraph;

public class EdgeBasedShortcutInserter
implements EdgeBasedNodeContractor.ShortcutHandler {
    private final CHGraph chGraph;
    private final int origEdges;
    private final IntArrayList shortcutsByPrepareEdges;
    private int shortcutCount;

    public EdgeBasedShortcutInserter(CHGraph chGraph) {
        this.chGraph = chGraph;
        this.origEdges = chGraph.getOriginalEdges();
        this.shortcutsByPrepareEdges = new IntArrayList();
    }

    @Override
    public void startContractingNode() {
        this.shortcutCount = 0;
    }

    @Override
    public void addShortcut(int prepareEdge, int from, int to, int origEdgeFirst, int origEdgeLast, int skipped1, int skipped2, double weight, boolean reverse) {
        int flags = reverse ? PrepareEncoder.getScBwdDir() : PrepareEncoder.getScFwdDir();
        int scId = this.chGraph.shortcutEdgeBased(from, to, flags, weight, skipped1, skipped2, origEdgeFirst, origEdgeLast);
        ++this.shortcutCount;
        this.setShortcutForPrepareEdge(prepareEdge, scId);
    }

    @Override
    public int finishContractingNode() {
        return this.shortcutCount;
    }

    @Override
    public void finishContraction() {
        AllCHEdgesIterator iter = this.chGraph.getAllEdges();
        while (iter.next()) {
            if (!iter.isShortcut()) continue;
            int skip1 = this.getShortcutForArc(iter.getSkippedEdge1());
            int skip2 = this.getShortcutForArc(iter.getSkippedEdge2());
            iter.setSkippedEdges(skip1, skip2);
        }
    }

    private void setShortcutForPrepareEdge(int prepareEdge, int shortcut) {
        int index = prepareEdge - this.origEdges;
        if (index >= this.shortcutsByPrepareEdges.size()) {
            this.shortcutsByPrepareEdges.resize(index + 1);
        }
        this.shortcutsByPrepareEdges.set(index, shortcut);
    }

    private int getShortcutForArc(int prepareEdge) {
        if (prepareEdge < this.origEdges) {
            return prepareEdge;
        }
        int index = prepareEdge - this.origEdges;
        return this.shortcutsByPrepareEdges.get(index);
    }
}

