/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntIndexedContainer;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.PointList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Path {
    final Graph graph;
    private final NodeAccess nodeAccess;
    private double weight = Double.MAX_VALUE;
    private double distance;
    private long time;
    private IntArrayList edgeIds = new IntArrayList();
    private int fromNode = -1;
    private int endNode = -1;
    private List<String> description;
    private boolean found;
    private String debugInfo = "";

    public Path(Graph graph) {
        this.graph = graph;
        this.nodeAccess = graph.getNodeAccess();
    }

    public List<String> getDescription() {
        if (this.description == null) {
            return Collections.emptyList();
        }
        return this.description;
    }

    public Path setDescription(List<String> description) {
        this.description = description;
        return this;
    }

    public IntArrayList getEdges() {
        return this.edgeIds;
    }

    public void setEdges(IntArrayList edgeIds) {
        this.edgeIds = edgeIds;
    }

    public void addEdge(int edge) {
        this.edgeIds.add(edge);
    }

    public int getEdgeCount() {
        return this.edgeIds.size();
    }

    public int getEndNode() {
        return this.endNode;
    }

    public Path setEndNode(int end) {
        this.endNode = end;
        return this;
    }

    private int getFromNode() {
        if (this.fromNode < 0) {
            throw new IllegalStateException("fromNode < 0 should not happen");
        }
        return this.fromNode;
    }

    public Path setFromNode(int from) {
        this.fromNode = from;
        return this;
    }

    public boolean isFound() {
        return this.found;
    }

    public Path setFound(boolean found) {
        this.found = found;
        return this;
    }

    public Path setDistance(double distance) {
        this.distance = distance;
        return this;
    }

    public Path addDistance(double distance) {
        this.distance += distance;
        return this;
    }

    public double getDistance() {
        return this.distance;
    }

    public long getTime() {
        return this.time;
    }

    public Path addTime(long time) {
        this.time += time;
        return this;
    }

    public double getWeight() {
        return this.weight;
    }

    public Path setWeight(double w) {
        this.weight = w;
        return this;
    }

    public EdgeIteratorState getFinalEdge() {
        return this.graph.getEdgeIteratorState(this.edgeIds.get(this.edgeIds.size() - 1), this.endNode);
    }

    public void setDebugInfo(String debugInfo) {
        this.debugInfo = debugInfo;
    }

    public String getDebugInfo() {
        return this.debugInfo;
    }

    public void forEveryEdge(EdgeVisitor visitor) {
        int tmpNode = this.getFromNode();
        int len = this.edgeIds.size();
        int prevEdgeId = -1;
        for (int i = 0; i < len; ++i) {
            EdgeIteratorState edgeBase = this.graph.getEdgeIteratorState(this.edgeIds.get(i), tmpNode);
            if (edgeBase == null) {
                throw new IllegalStateException("Edge " + this.edgeIds.get(i) + " was empty when requested with node " + tmpNode + ", array index:" + i + ", edges:" + this.edgeIds.size());
            }
            tmpNode = edgeBase.getBaseNode();
            edgeBase = this.graph.getEdgeIteratorState(edgeBase.getEdge(), tmpNode);
            visitor.next(edgeBase, i, prevEdgeId);
            prevEdgeId = edgeBase.getEdge();
        }
        visitor.finish();
    }

    public List<EdgeIteratorState> calcEdges() {
        final ArrayList<EdgeIteratorState> edges = new ArrayList<EdgeIteratorState>(this.edgeIds.size());
        if (this.edgeIds.isEmpty()) {
            return edges;
        }
        this.forEveryEdge(new EdgeVisitor(){

            @Override
            public void next(EdgeIteratorState eb, int index, int prevEdgeId) {
                edges.add(eb);
            }

            @Override
            public void finish() {
            }
        });
        return edges;
    }

    public IntIndexedContainer calcNodes() {
        final IntArrayList nodes = new IntArrayList(this.edgeIds.size() + 1);
        if (this.edgeIds.isEmpty()) {
            if (this.isFound()) {
                nodes.add(this.endNode);
            }
            return nodes;
        }
        int tmpNode = this.getFromNode();
        nodes.add(tmpNode);
        this.forEveryEdge(new EdgeVisitor(){

            @Override
            public void next(EdgeIteratorState eb, int index, int prevEdgeId) {
                nodes.add(eb.getAdjNode());
            }

            @Override
            public void finish() {
            }
        });
        return nodes;
    }

    public PointList calcPoints() {
        final PointList points = new PointList(this.edgeIds.size() + 1, this.nodeAccess.is3D());
        if (this.edgeIds.isEmpty()) {
            if (this.isFound()) {
                points.add(this.nodeAccess, this.endNode);
            }
            return points;
        }
        int tmpNode = this.getFromNode();
        points.add(this.nodeAccess, tmpNode);
        this.forEveryEdge(new EdgeVisitor(){

            @Override
            public void next(EdgeIteratorState eb, int index, int prevEdgeId) {
                PointList pl = eb.fetchWayGeometry(FetchMode.PILLAR_AND_ADJ);
                for (int j = 0; j < pl.getSize(); ++j) {
                    points.add(pl, j);
                }
            }

            @Override
            public void finish() {
            }
        });
        return points;
    }

    public String toString() {
        return "found: " + this.found + ", weight: " + this.weight + ", time: " + this.time + ", distance: " + this.distance + ", edges: " + this.edgeIds.size();
    }

    public static interface EdgeVisitor {
        public void next(EdgeIteratorState var1, int var2, int var3);

        public void finish();
    }
}

