/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.resources;

import com.graphhopper.gtfs.GraphExplorer;
import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.Label;
import com.graphhopper.gtfs.MultiCriteriaLabelSetting;
import com.graphhopper.gtfs.PtEncodedValues;
import com.graphhopper.gtfs.RealtimeFeed;
import com.graphhopper.http.WebHelper;
import com.graphhopper.isochrone.algorithm.ContourBuilder;
import com.graphhopper.isochrone.algorithm.ReadableTriangulation;
import com.graphhopper.json.geo.JsonFeature;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.FastestWeighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.GHPoint;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.triangulate.ConformingDelaunayTriangulator;
import org.locationtech.jts.triangulate.ConstraintVertex;
import org.locationtech.jts.triangulate.DelaunayTriangulationBuilder;
import org.locationtech.jts.triangulate.quadedge.QuadEdge;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeSubdivision;
import org.locationtech.jts.triangulate.quadedge.Vertex;

@Path(value="isochrone-pt")
public class PtIsochroneResource {
    private static final double JTS_TOLERANCE = 1.0E-5;
    private GtfsStorage gtfsStorage;
    private EncodingManager encodingManager;
    private GraphHopperStorage graphHopperStorage;
    private LocationIndex locationIndex;
    private final Function<Label, Double> z = label -> label.currentTime;

    @Inject
    public PtIsochroneResource(GtfsStorage gtfsStorage, EncodingManager encodingManager, GraphHopperStorage graphHopperStorage, LocationIndex locationIndex) {
        this.gtfsStorage = gtfsStorage;
        this.encodingManager = encodingManager;
        this.graphHopperStorage = graphHopperStorage;
        this.locationIndex = locationIndex;
    }

    @GET
    @Produces(value={"application/json"})
    public Response doGet(@QueryParam(value="point") GHPoint source, @QueryParam(value="time_limit") @DefaultValue(value="600") long seconds, @QueryParam(value="reverse_flow") @DefaultValue(value="false") boolean reverseFlow, @QueryParam(value="pt.earliest_departure_time") String departureTimeString, @QueryParam(value="pt.blocked_route_types") @DefaultValue(value="0") int blockedRouteTypes, @QueryParam(value="result") @DefaultValue(value="multipolygon") String format) {
        Instant initialTime;
        try {
            initialTime = Instant.parse(departureTimeString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Illegal value for required parameter %s: [%s]", "pt.earliest_departure_time", departureTimeString));
        }
        double targetZ = initialTime.toEpochMilli() + seconds * 1000L;
        GeometryFactory geometryFactory = new GeometryFactory();
        DefaultEdgeFilter filter = DefaultEdgeFilter.allEdges(this.graphHopperStorage.getEncodingManager().getEncoder("foot"));
        Snap snap = this.locationIndex.findClosest(source.lat, source.lon, filter);
        QueryGraph queryGraph = QueryGraph.create((Graph)this.graphHopperStorage, Collections.singletonList(snap));
        if (!snap.isValid()) {
            throw new IllegalArgumentException("Cannot find point: " + source);
        }
        PtEncodedValues ptEncodedValues = PtEncodedValues.fromEncodingManager(this.encodingManager);
        GraphExplorer graphExplorer = new GraphExplorer(queryGraph, new FastestWeighting(this.encodingManager.getEncoder("foot")), ptEncodedValues, this.gtfsStorage, RealtimeFeed.empty(this.gtfsStorage), reverseFlow, false, 5.0, reverseFlow);
        MultiCriteriaLabelSetting router = new MultiCriteriaLabelSetting(graphExplorer, ptEncodedValues, reverseFlow, false, false, false, 1000000, Collections.emptyList());
        final HashMap z1 = new HashMap();
        final NodeAccess nodeAccess = queryGraph.getNodeAccess();
        MultiCriteriaLabelSetting.SPTVisitor sptVisitor = nodeLabel -> {
            Coordinate nodeCoordinate = new Coordinate(nodeAccess.getLongitude(nodeLabel.adjNode), nodeAccess.getLatitude(nodeLabel.adjNode));
            z1.merge(nodeCoordinate, this.z.apply(nodeLabel), Math::min);
        };
        if (format.equals("multipoint")) {
            router.calcLabels(snap.getClosestNode(), initialTime, blockedRouteTypes, sptVisitor, label -> (double)label.currentTime <= targetZ);
            MultiPoint exploredPoints = geometryFactory.createMultiPointFromCoords(z1.keySet().toArray(new Coordinate[0]));
            return this.wrap(exploredPoints);
        }
        router.calcLabels(snap.getClosestNode(), initialTime, blockedRouteTypes, sptVisitor, label -> (double)label.currentTime <= targetZ);
        MultiPoint exploredPoints = geometryFactory.createMultiPointFromCoords(z1.keySet().toArray(new Coordinate[0]));
        this.locationIndex.query(BBox.fromEnvelope(exploredPoints.getEnvelopeInternal()), new LocationIndex.Visitor(){

            @Override
            public void onNode(int nodeId) {
                Coordinate nodeCoordinate = new Coordinate(nodeAccess.getLongitude(nodeId), nodeAccess.getLatitude(nodeId));
                z1.merge(nodeCoordinate, Double.MAX_VALUE, Math::min);
            }
        });
        exploredPoints = geometryFactory.createMultiPointFromCoords(z1.keySet().toArray(new Coordinate[0]));
        CoordinateList siteCoords = DelaunayTriangulationBuilder.extractUniqueCoordinates(exploredPoints);
        ArrayList<ConstraintVertex> constraintVertices = new ArrayList<ConstraintVertex>();
        for (Object siteCoord : siteCoords) {
            Coordinate coord = (Coordinate)siteCoord;
            constraintVertices.add(new ConstraintVertex(coord));
        }
        ConformingDelaunayTriangulator cdt = new ConformingDelaunayTriangulator(constraintVertices, 1.0E-5);
        cdt.setConstraints(new ArrayList(), new ArrayList());
        cdt.formInitialDelaunay();
        QuadEdgeSubdivision tin = cdt.getSubdivision();
        for (Vertex vertex : tin.getVertices(true)) {
            if (tin.isFrameVertex(vertex)) {
                vertex.setZ(Double.MAX_VALUE);
                continue;
            }
            Double aDouble = (Double)z1.get(vertex.getCoordinate());
            if (aDouble != null) {
                vertex.setZ(aDouble);
                continue;
            }
            vertex.setZ(Double.MAX_VALUE);
        }
        ReadableTriangulation triangulation = ReadableTriangulation.wrap(tin);
        ContourBuilder contourBuilder = new ContourBuilder(triangulation);
        MultiPolygon isoline = contourBuilder.computeIsoline(targetZ, triangulation.getEdges());
        if (format.equals("triangulation")) {
            HashMap<String, Object> properties;
            JsonFeature feature;
            Response response = new Response();
            for (Vertex vertex : tin.getVertices(true)) {
                feature = new JsonFeature();
                feature.setGeometry(geometryFactory.createPoint(vertex.getCoordinate()));
                properties = new HashMap<String, Object>();
                properties.put("z", vertex.getZ());
                feature.setProperties(properties);
                response.polygons.add(feature);
            }
            for (QuadEdge edge : tin.getPrimaryEdges(false)) {
                feature = new JsonFeature();
                feature.setGeometry(edge.toLineSegment().toGeometry(geometryFactory));
                properties = new HashMap();
                feature.setProperties(properties);
                response.polygons.add(feature);
            }
            JsonFeature feature2 = new JsonFeature();
            feature2.setGeometry(isoline);
            HashMap<String, Object> properties2 = new HashMap<String, Object>();
            properties2.put("z", targetZ);
            feature2.setProperties(properties2);
            response.polygons.add(feature2);
            response.info.copyrights.addAll(WebHelper.COPYRIGHTS);
            return response;
        }
        return this.wrap(isoline);
    }

    private Response wrap(Geometry isoline) {
        JsonFeature feature = new JsonFeature();
        feature.setGeometry(isoline);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("bucket", 0);
        feature.setProperties(properties);
        Response response = new Response();
        response.polygons.add(feature);
        response.info.copyrights.addAll(WebHelper.COPYRIGHTS);
        return response;
    }

    public static class Response {
        public List<JsonFeature> polygons = new ArrayList<JsonFeature>();
        public Info info = new Info();

        public static class Info {
            public List<String> copyrights = new ArrayList<String>();
        }
    }
}

