/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm.conditional;

import com.graphhopper.reader.osm.conditional.ParsedCalendar;
import com.graphhopper.util.Helper;
import java.text.DateFormat;
import java.util.Calendar;

public class DateRange {
    private final Calendar from;
    private final Calendar to;
    boolean yearless = false;
    boolean dayOnly = false;
    boolean reverse = false;

    public DateRange(ParsedCalendar from, ParsedCalendar to) {
        Calendar fromCal = from.parsedCalendar;
        Calendar toCal = to.parsedCalendar;
        if (fromCal.get(0) != toCal.get(0)) {
            throw new IllegalArgumentException("Different calendar eras are not allowed. From:" + from + " To:" + to);
        }
        if (from.isYearless() && to.isYearless()) {
            this.yearless = true;
        }
        if (from.isDayOnly() && to.isDayOnly()) {
            this.dayOnly = true;
        }
        if (fromCal.getTimeInMillis() > toCal.getTimeInMillis()) {
            if (!this.yearless && !this.dayOnly) {
                throw new IllegalArgumentException("'from' after 'to' not allowed, except for isYearless and isDayOnly DateRanges. From:" + from + " To:" + to);
            }
            this.reverse = true;
        }
        this.from = from.getMin();
        this.to = to.getMax();
    }

    public boolean isInRange(Calendar date) {
        if (!this.yearless && !this.dayOnly) {
            return date.after(this.from) && date.before(this.to) || date.equals(this.from) || date.equals(this.to);
        }
        if (this.dayOnly) {
            int currentDayOfWeek = date.get(7);
            if (this.reverse) {
                return this.from.get(7) <= currentDayOfWeek || currentDayOfWeek <= this.to.get(7);
            }
            return this.from.get(7) <= currentDayOfWeek && currentDayOfWeek <= this.to.get(7);
        }
        if (this.reverse) {
            return this.isInRangeYearlessReverse(date);
        }
        return this.isInRangeYearless(date);
    }

    private boolean isInRangeYearless(Calendar date) {
        if (this.from.get(2) < date.get(2) && date.get(2) < this.to.get(2)) {
            return true;
        }
        if (this.from.get(2) == date.get(2) && this.to.get(2) == date.get(2)) {
            return this.from.get(5) <= date.get(5) && date.get(5) <= this.to.get(5);
        }
        if (this.from.get(2) == date.get(2)) {
            return this.from.get(5) <= date.get(5);
        }
        if (this.to.get(2) == date.get(2)) {
            return date.get(5) <= this.to.get(5);
        }
        return false;
    }

    private boolean isInRangeYearlessReverse(Calendar date) {
        int currMonth = date.get(2);
        if (this.from.get(2) < currMonth || currMonth < this.to.get(2)) {
            return true;
        }
        if (this.from.get(2) == currMonth && this.to.get(2) == currMonth) {
            return this.from.get(5) < date.get(5) || date.get(5) < this.to.get(5);
        }
        if (this.from.get(2) == currMonth) {
            return this.from.get(5) <= date.get(5);
        }
        if (this.to.get(2) == currMonth) {
            return date.get(5) <= this.to.get(5);
        }
        return false;
    }

    public String toString() {
        DateFormat f = Helper.createFormatter();
        return "yearless:" + this.yearless + ", dayOnly:" + this.dayOnly + ", reverse:" + this.reverse + ", from:" + f.format(this.from.getTime()) + ", to:" + f.format(this.to.getTime());
    }
}

