/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.util.DistancePlaneProjection;
import com.graphhopper.util.PointList;

public class GraphElevationSmoothing {
    private static final int MAX_SEARCH_DISTANCE = 150;

    public static PointList smoothElevation(PointList geometry) {
        for (int i = 1; i < geometry.size() - 1; ++i) {
            int start = i;
            int j = i - 1;
            while (j >= 0 && 150.0 > DistancePlaneProjection.DIST_PLANE.calcDist(geometry.getLat(i), geometry.getLon(i), geometry.getLat(j), geometry.getLon(j))) {
                start = j--;
            }
            int end = i;
            for (int j2 = i + 1; j2 < geometry.size() && 150.0 > DistancePlaneProjection.DIST_PLANE.calcDist(geometry.getLat(i), geometry.getLon(i), geometry.getLat(j2), geometry.getLon(j2)); ++j2) {
                end = j2 + 1;
            }
            if (start == end) continue;
            double sum = 0.0;
            for (int j3 = start; j3 < end; ++j3) {
                if (!(150.0 > DistancePlaneProjection.DIST_PLANE.calcDist(geometry.getLat(i), geometry.getLon(i), geometry.getLat(j3), geometry.getLon(j3)))) continue;
                sum += geometry.getEle(j3);
            }
            double smoothed = sum / (double)(end - start);
            geometry.setElevation(i, smoothed);
        }
        return geometry;
    }
}

