/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.navigation;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopperAPI;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.navigation.DistanceConfig;
import com.graphhopper.navigation.DistanceUtils;
import com.graphhopper.navigation.NavigateResponseConverter;
import com.graphhopper.util.Helper;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.TranslationMap;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="navigate/directions/v5/gh")
public class NavigateResource {
    private static final Logger logger = LoggerFactory.getLogger(NavigateResource.class);
    private final GraphHopperAPI graphHopper;
    private final TranslationMap translationMap;
    private final Map<String, String> resolverMap;

    @Inject
    public NavigateResource(GraphHopperAPI graphHopper, TranslationMap translationMap, GraphHopperConfig config) {
        this.graphHopper = graphHopper;
        this.resolverMap = config.asPMap().getObject("profiles_mapbox", new HashMap());
        if (this.resolverMap.isEmpty()) {
            this.resolverMap.put("driving", "car");
            this.resolverMap.put("driving-traffic", "car");
            this.resolverMap.put("walking", "foot");
            this.resolverMap.put("cycling", "bike");
        }
        this.translationMap = translationMap;
    }

    @GET
    @Path(value="/{profile}/{coordinatesArray : .+}")
    @Produces(value={"application/json"})
    public Response doGet(@Context HttpServletRequest httpReq, @Context UriInfo uriInfo, @Context ContainerRequestContext rc, @QueryParam(value="steps") @DefaultValue(value="false") boolean enableInstructions, @QueryParam(value="voice_instructions") @DefaultValue(value="false") boolean voiceInstructions, @QueryParam(value="banner_instructions") @DefaultValue(value="false") boolean bannerInstructions, @QueryParam(value="roundabout_exits") @DefaultValue(value="false") boolean roundaboutExits, @QueryParam(value="voice_units") @DefaultValue(value="metric") String voiceUnits, @QueryParam(value="overview") @DefaultValue(value="simplified") String overview, @QueryParam(value="geometries") @DefaultValue(value="polyline") String geometries, @QueryParam(value="bearings") @DefaultValue(value="") String bearings, @QueryParam(value="language") @DefaultValue(value="en") String localeStr, @PathParam(value="profile") String mapboxProfile) {
        if (!geometries.equals("polyline6")) {
            throw new IllegalArgumentException("Currently, we only support polyline6");
        }
        if (!enableInstructions) {
            throw new IllegalArgumentException("Currently, you need to enable steps");
        }
        if (!roundaboutExits) {
            throw new IllegalArgumentException("Roundabout exits have to be enabled right now");
        }
        if (!voiceInstructions) {
            throw new IllegalArgumentException("You need to enable voice instructions right now");
        }
        if (!bannerInstructions) {
            throw new IllegalArgumentException("You need to enable banner instructions right now");
        }
        double minPathPrecision = 1.0;
        if (overview.equals("full")) {
            minPathPrecision = 0.0;
        }
        DistanceUtils.Unit unit = voiceUnits.equals("metric") ? DistanceUtils.Unit.METRIC : DistanceUtils.Unit.IMPERIAL;
        String ghProfile = this.resolverMap.getOrDefault(mapboxProfile, mapboxProfile);
        List<GHPoint> requestPoints = this.getPointsFromRequest(httpReq, mapboxProfile);
        List<Double> favoredHeadings = NavigateResource.getBearing(bearings);
        if (favoredHeadings.size() > 0 && favoredHeadings.size() != requestPoints.size()) {
            throw new IllegalArgumentException("Number of bearings and waypoints did not match");
        }
        StopWatch sw = new StopWatch().start();
        GHResponse ghResponse = this.calcRoute(favoredHeadings, requestPoints, ghProfile, localeStr, enableInstructions, minPathPrecision);
        if (!ghResponse.hasErrors() && favoredHeadings.size() > 0) {
            GHResponse noHeadingResponse = this.calcRoute(Collections.EMPTY_LIST, requestPoints, ghProfile, localeStr, enableInstructions, minPathPrecision);
            if (ghResponse.getBest().getDistance() != noHeadingResponse.getBest().getDistance()) {
                ghResponse.getAll().add(noHeadingResponse.getBest());
            }
        }
        float took = sw.stop().getSeconds();
        String infoStr = httpReq.getRemoteAddr() + " " + httpReq.getLocale() + " " + httpReq.getHeader("User-Agent");
        String logStr = httpReq.getQueryString() + " " + infoStr + " " + requestPoints + ", took:" + took + ", " + ghProfile;
        Locale locale = Helper.getLocale(localeStr);
        DistanceConfig config = new DistanceConfig(unit, this.translationMap, locale);
        if (ghResponse.hasErrors()) {
            logger.error(logStr + ", errors:" + ghResponse.getErrors());
            return Response.status(422).entity(NavigateResponseConverter.convertFromGHResponseError(ghResponse)).header("X-GH-Took", "" + Math.round(took * 1000.0f)).build();
        }
        logger.info(logStr);
        return Response.ok(NavigateResponseConverter.convertFromGHResponse(ghResponse, this.translationMap, locale, config)).header("X-GH-Took", "" + Math.round(took * 1000.0f)).build();
    }

    private GHResponse calcRoute(List<Double> favoredHeadings, List<GHPoint> requestPoints, String profileStr, String localeStr, boolean enableInstructions, double minPathPrecision) {
        GHRequest request = favoredHeadings.size() > 0 ? new GHRequest(requestPoints, favoredHeadings) : new GHRequest(requestPoints);
        request.setProfile(profileStr).setLocale(localeStr).putHint("calc_points", true).putHint("instructions", enableInstructions).putHint("way_point_max_distance", minPathPrecision).putHint("ch.disable", true).putHint("pass_through", false);
        return this.graphHopper.route(request);
    }

    private List<GHPoint> getPointsFromRequest(HttpServletRequest httpServletRequest, String profile) {
        String url = httpServletRequest.getRequestURI();
        url = url.replaceFirst("/navigate/directions/v5/gh/" + profile + "/", "");
        url = url.replaceAll("\\?[*]", "");
        String[] pointStrings = url.split(";");
        ArrayList<GHPoint> points = new ArrayList<GHPoint>(pointStrings.length);
        for (int i = 0; i < pointStrings.length; ++i) {
            points.add(GHPoint.fromStringLonLat(pointStrings[i]));
        }
        return points;
    }

    static List<Double> getBearing(String bearingString) {
        if (bearingString == null || bearingString.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        String[] bearingArray = bearingString.split(";", -1);
        ArrayList<Double> bearings = new ArrayList<Double>(bearingArray.length);
        for (int i = 0; i < bearingArray.length; ++i) {
            String singleBearing = bearingArray[i];
            if (singleBearing.isEmpty()) {
                bearings.add(Double.NaN);
                continue;
            }
            if (!singleBearing.contains(",")) {
                throw new IllegalArgumentException("You passed an invalid bearings parameter " + bearingString);
            }
            String[] singleBearingArray = singleBearing.split(",");
            try {
                bearings.add(Double.parseDouble(singleBearingArray[0]));
                continue;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("You passed an invalid bearings parameter " + bearingString);
            }
        }
        return bearings;
    }
}

