/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopperAPI;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.config.CHProfile;
import com.graphhopper.config.LMProfile;
import com.graphhopper.config.Profile;
import com.graphhopper.reader.DataReader;
import com.graphhopper.reader.dem.CGIARProvider;
import com.graphhopper.reader.dem.EdgeElevationInterpolator;
import com.graphhopper.reader.dem.ElevationProvider;
import com.graphhopper.reader.dem.GMTEDProvider;
import com.graphhopper.reader.dem.MultiSourceElevationProvider;
import com.graphhopper.reader.dem.SRTMGL1Provider;
import com.graphhopper.reader.dem.SRTMProvider;
import com.graphhopper.reader.dem.SkadiProvider;
import com.graphhopper.reader.osm.conditional.DateRangeParser;
import com.graphhopper.routing.DefaultWeightingFactory;
import com.graphhopper.routing.Router;
import com.graphhopper.routing.RouterConfig;
import com.graphhopper.routing.WeightingFactory;
import com.graphhopper.routing.ch.CHPreparationHandler;
import com.graphhopper.routing.ev.DefaultEncodedValueFactory;
import com.graphhopper.routing.ev.EncodedValueFactory;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RoadEnvironment;
import com.graphhopper.routing.lm.LMConfig;
import com.graphhopper.routing.lm.LMPreparationHandler;
import com.graphhopper.routing.lm.LandmarkStorage;
import com.graphhopper.routing.subnetwork.PrepareRoutingSubnetworks;
import com.graphhopper.routing.util.CustomModel;
import com.graphhopper.routing.util.DefaultFlagEncoderFactory;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.FlagEncoderFactory;
import com.graphhopper.routing.util.parsers.DefaultTagParserFactory;
import com.graphhopper.routing.util.parsers.TagParserFactory;
import com.graphhopper.routing.weighting.DefaultTurnCostProvider;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.routing.weighting.custom.CustomProfile;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.DAType;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.GHDirectory;
import com.graphhopper.storage.GHLock;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.LockFactory;
import com.graphhopper.storage.NativeFSLockFactory;
import com.graphhopper.storage.SimpleFSLockFactory;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.util.Constants;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.TranslationMap;
import com.graphhopper.util.Unzipper;
import com.graphhopper.util.details.PathDetailsBuilderFactory;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphHopper
implements GraphHopperAPI {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Profile> profilesByName = new LinkedHashMap<String, Profile>();
    private final String fileLockName = "gh.lock";
    private final TranslationMap trMap = new TranslationMap().doImport();
    boolean removeZipped = true;
    private GraphHopperStorage ghStorage;
    private EncodingManager encodingManager;
    private int defaultSegmentSize = -1;
    private String ghLocation = "";
    private DAType dataAccessType = DAType.RAM_STORE;
    private boolean sortGraph = false;
    private boolean elevation = false;
    private LockFactory lockFactory = new NativeFSLockFactory();
    private boolean allowWrites = true;
    private boolean fullyLoaded = false;
    private boolean smoothElevation = false;
    private double longEdgeSamplingDistance = Double.MAX_VALUE;
    private final RouterConfig routerConfig = new RouterConfig();
    private LocationIndex locationIndex;
    private int preciseIndexResolution = 300;
    private int maxRegionSearch = 4;
    private int minNetworkSize = 200;
    private final LMPreparationHandler lmPreparationHandler = new LMPreparationHandler();
    private final CHPreparationHandler chPreparationHandler = new CHPreparationHandler();
    private String dataReaderFile;
    private double dataReaderWayPointMaxDistance = 1.0;
    private int dataReaderWorkerThreads = 2;
    private ElevationProvider eleProvider = ElevationProvider.NOOP;
    private FlagEncoderFactory flagEncoderFactory = new DefaultFlagEncoderFactory();
    private EncodedValueFactory encodedValueFactory = new DefaultEncodedValueFactory();
    private TagParserFactory tagParserFactory = new DefaultTagParserFactory();
    private PathDetailsBuilderFactory pathBuilderFactory = new PathDetailsBuilderFactory();
    private static final String INTERPOLATION_KEY = "prepare.elevation_interpolation.done";

    protected GraphHopper loadGraph(GraphHopperStorage g2) {
        this.ghStorage = g2;
        this.setFullyLoaded();
        this.initLocationIndex();
        return this;
    }

    public EncodingManager getEncodingManager() {
        return this.encodingManager;
    }

    public GraphHopper setEncodingManager(EncodingManager em) {
        this.ensureNotLoaded();
        this.encodingManager = em;
        return this;
    }

    public ElevationProvider getElevationProvider() {
        return this.eleProvider;
    }

    public GraphHopper setElevationProvider(ElevationProvider eleProvider) {
        if (eleProvider == null || eleProvider == ElevationProvider.NOOP) {
            this.setElevation(false);
        } else {
            this.setElevation(true);
        }
        this.eleProvider = eleProvider;
        return this;
    }

    protected int getWorkerThreads() {
        return this.dataReaderWorkerThreads;
    }

    protected double getWayPointMaxDistance() {
        return this.dataReaderWayPointMaxDistance;
    }

    public GraphHopper setWayPointMaxDistance(double wayPointMaxDistance) {
        this.dataReaderWayPointMaxDistance = wayPointMaxDistance;
        return this;
    }

    public GraphHopper setPathDetailsBuilderFactory(PathDetailsBuilderFactory pathBuilderFactory) {
        this.pathBuilderFactory = pathBuilderFactory;
        return this;
    }

    public PathDetailsBuilderFactory getPathDetailsBuilderFactory() {
        return this.pathBuilderFactory;
    }

    public GraphHopper forServer() {
        this.routerConfig.setSimplifyResponse(true);
        return this.setInMemory();
    }

    public GraphHopper forDesktop() {
        this.routerConfig.setSimplifyResponse(false);
        return this.setInMemory();
    }

    public GraphHopper forMobile() {
        this.routerConfig.setSimplifyResponse(false);
        return this.setMemoryMapped();
    }

    public GraphHopper setPreciseIndexResolution(int precision) {
        this.ensureNotLoaded();
        this.preciseIndexResolution = precision;
        return this;
    }

    public GraphHopper setMinNetworkSize(int minNetworkSize) {
        this.ensureNotLoaded();
        this.minNetworkSize = minNetworkSize;
        return this;
    }

    public GraphHopper setInMemory() {
        this.ensureNotLoaded();
        this.dataAccessType = DAType.RAM_STORE;
        return this;
    }

    public GraphHopper setStoreOnFlush(boolean storeOnFlush) {
        this.ensureNotLoaded();
        this.dataAccessType = storeOnFlush ? DAType.RAM_STORE : DAType.RAM;
        return this;
    }

    public GraphHopper setMemoryMapped() {
        this.ensureNotLoaded();
        this.dataAccessType = DAType.MMAP;
        return this;
    }

    public GraphHopper setProfiles(Profile ... profiles) {
        return this.setProfiles(Arrays.asList(profiles));
    }

    public GraphHopper setProfiles(List<Profile> profiles) {
        this.profilesByName.clear();
        for (Profile profile : profiles) {
            Profile previous = this.profilesByName.put(profile.getName(), profile);
            if (previous == null) continue;
            throw new IllegalArgumentException("Profile names must be unique. Duplicate name: '" + profile.getName() + "'");
        }
        return this;
    }

    public List<Profile> getProfiles() {
        return new ArrayList<Profile>(this.profilesByName.values());
    }

    public Profile getProfile(String profileName) {
        return this.profilesByName.get(profileName);
    }

    public boolean hasElevation() {
        return this.elevation;
    }

    public GraphHopper setElevation(boolean includeElevation) {
        this.elevation = includeElevation;
        return this;
    }

    public GraphHopper setLongEdgeSamplingDistance(double longEdgeSamplingDistance) {
        this.longEdgeSamplingDistance = longEdgeSamplingDistance;
        return this;
    }

    public GraphHopper setElevationWayPointMaxDistance(double elevationWayPointMaxDistance) {
        this.routerConfig.setElevationWayPointMaxDistance(elevationWayPointMaxDistance);
        return this;
    }

    public String getGraphHopperLocation() {
        return this.ghLocation;
    }

    public GraphHopper setGraphHopperLocation(String ghLocation) {
        this.ensureNotLoaded();
        if (ghLocation == null) {
            throw new IllegalArgumentException("graphhopper location cannot be null");
        }
        this.ghLocation = ghLocation;
        return this;
    }

    public String getDataReaderFile() {
        return this.dataReaderFile;
    }

    public GraphHopper setDataReaderFile(String dataReaderFileStr) {
        this.ensureNotLoaded();
        if (Helper.isEmpty(dataReaderFileStr)) {
            throw new IllegalArgumentException("Data reader file cannot be empty.");
        }
        this.dataReaderFile = dataReaderFileStr;
        return this;
    }

    public GraphHopperStorage getGraphHopperStorage() {
        if (this.ghStorage == null) {
            throw new IllegalStateException("GraphHopper storage not initialized");
        }
        return this.ghStorage;
    }

    public void setGraphHopperStorage(GraphHopperStorage ghStorage) {
        this.ghStorage = ghStorage;
        this.setFullyLoaded();
    }

    public LocationIndex getLocationIndex() {
        if (this.locationIndex == null) {
            throw new IllegalStateException("Location index not initialized");
        }
        return this.locationIndex;
    }

    protected void setLocationIndex(LocationIndex locationIndex) {
        this.locationIndex = locationIndex;
    }

    public GraphHopper setSortGraph(boolean sortGraph) {
        this.ensureNotLoaded();
        this.sortGraph = sortGraph;
        return this;
    }

    public boolean isAllowWrites() {
        return this.allowWrites;
    }

    public GraphHopper setAllowWrites(boolean allowWrites) {
        this.allowWrites = allowWrites;
        return this;
    }

    public TranslationMap getTranslationMap() {
        return this.trMap;
    }

    public GraphHopper setFlagEncoderFactory(FlagEncoderFactory factory) {
        this.flagEncoderFactory = factory;
        return this;
    }

    public EncodedValueFactory getEncodedValueFactory() {
        return this.encodedValueFactory;
    }

    public GraphHopper setEncodedValueFactory(EncodedValueFactory factory) {
        this.encodedValueFactory = factory;
        return this;
    }

    public TagParserFactory getTagParserFactory() {
        return this.tagParserFactory;
    }

    public GraphHopper setTagParserFactory(TagParserFactory factory) {
        this.tagParserFactory = factory;
        return this;
    }

    public GraphHopper init(GraphHopperConfig ghConfig) {
        String graphHopperFolder;
        if (ghConfig.has("osmreader.osm")) {
            throw new IllegalArgumentException("Instead osmreader.osm use datareader.file, for other changes see core/files/changelog.txt");
        }
        String tmpOsmFile = ghConfig.getString("datareader.file", "");
        if (!Helper.isEmpty(tmpOsmFile)) {
            this.dataReaderFile = tmpOsmFile;
        }
        if (Helper.isEmpty(graphHopperFolder = ghConfig.getString("graph.location", "")) && Helper.isEmpty(this.ghLocation)) {
            if (Helper.isEmpty(this.dataReaderFile)) {
                throw new IllegalArgumentException("If no graph.location is provided you need to specify an OSM file.");
            }
            graphHopperFolder = Helper.pruneFileEnd(this.dataReaderFile) + "-gh";
        }
        this.setGraphHopperLocation(graphHopperFolder);
        this.defaultSegmentSize = ghConfig.getInt("graph.dataaccess.segment_size", this.defaultSegmentSize);
        String graphDATypeStr = ghConfig.getString("graph.dataaccess", "RAM_STORE");
        this.dataAccessType = DAType.fromString(graphDATypeStr);
        this.sortGraph = ghConfig.getBool("graph.do_sort", this.sortGraph);
        this.removeZipped = ghConfig.getBool("graph.remove_zipped", this.removeZipped);
        EncodingManager encodingManager = this.createEncodingManager(ghConfig);
        if (encodingManager != null) {
            this.setEncodingManager(encodingManager);
        }
        this.lockFactory = ghConfig.getString("graph.locktype", "native").equals("simple") ? new SimpleFSLockFactory() : new NativeFSLockFactory();
        this.smoothElevation = ghConfig.getBool("graph.elevation.smoothing", false);
        this.longEdgeSamplingDistance = ghConfig.getDouble("graph.elevation.long_edge_sampling_distance", Double.MAX_VALUE);
        this.setElevationWayPointMaxDistance(ghConfig.getDouble("graph.elevation.way_point_max_distance", Double.MAX_VALUE));
        ElevationProvider elevationProvider = GraphHopper.createElevationProvider(ghConfig);
        this.setElevationProvider(elevationProvider);
        if (this.longEdgeSamplingDistance < Double.MAX_VALUE && !elevationProvider.getInterpolate()) {
            this.logger.warn("Long edge sampling enabled, but bilinear interpolation disabled. See #1953");
        }
        this.minNetworkSize = ghConfig.getInt("prepare.min_network_size", this.minNetworkSize);
        this.setProfiles(ghConfig.getProfiles());
        this.chPreparationHandler.init(ghConfig);
        this.lmPreparationHandler.init(ghConfig);
        this.dataReaderWayPointMaxDistance = ghConfig.getDouble("routing.way_point_max_distance", this.dataReaderWayPointMaxDistance);
        this.dataReaderWorkerThreads = ghConfig.getInt("datareader.worker_threads", this.dataReaderWorkerThreads);
        this.preciseIndexResolution = ghConfig.getInt("index.high_resolution", this.preciseIndexResolution);
        this.maxRegionSearch = ghConfig.getInt("index.max_region_search", this.maxRegionSearch);
        this.routerConfig.setMaxVisitedNodes(ghConfig.getInt("routing.max_visited_nodes", this.routerConfig.getMaxVisitedNodes()));
        this.routerConfig.setMaxRoundTripRetries(ghConfig.getInt("routing.round_trip.max_retries", this.routerConfig.getMaxRoundTripRetries()));
        this.routerConfig.setNonChMaxWaypointDistance(ghConfig.getInt("routing.non_ch.max_waypoint_distance", this.routerConfig.getNonChMaxWaypointDistance()));
        this.routerConfig.setCHDisablingAllowed(ghConfig.getBool("routing.ch.disabling_allowed", this.routerConfig.isCHDisablingAllowed()));
        this.routerConfig.setLMDisablingAllowed(ghConfig.getBool("routing.lm.disabling_allowed", this.routerConfig.isLMDisablingAllowed()));
        int activeLandmarkCount = ghConfig.getInt("routing.lm.active_landmarks", Math.min(8, this.lmPreparationHandler.getLandmarks()));
        if (activeLandmarkCount > this.lmPreparationHandler.getLandmarks()) {
            throw new IllegalArgumentException("Default value for active landmarks " + activeLandmarkCount + " should be less or equal to landmark count of " + this.lmPreparationHandler.getLandmarks());
        }
        this.routerConfig.setActiveLandmarkCount(activeLandmarkCount);
        return this;
    }

    private EncodingManager createEncodingManager(GraphHopperConfig ghConfig) {
        String flagEncodersStr = ghConfig.getString("graph.flag_encoders", "");
        String encodedValueStr = ghConfig.getString("graph.encoded_values", "");
        if (flagEncodersStr.isEmpty() && encodedValueStr.isEmpty()) {
            return null;
        }
        EncodingManager.Builder emBuilder = new EncodingManager.Builder();
        if (!encodedValueStr.isEmpty()) {
            emBuilder.addAll(this.tagParserFactory, encodedValueStr);
        }
        this.registerCustomEncodedValues(emBuilder);
        if (!flagEncodersStr.isEmpty()) {
            emBuilder.addAll(this.flagEncoderFactory, flagEncodersStr);
        }
        emBuilder.setEnableInstructions(ghConfig.getBool("datareader.instructions", true));
        emBuilder.setPreferredLanguage(ghConfig.getString("datareader.preferred_language", ""));
        emBuilder.setDateRangeParser(DateRangeParser.createInstance(ghConfig.getString("datareader.date_range_parser_day", "")));
        return emBuilder.build();
    }

    private static ElevationProvider createElevationProvider(GraphHopperConfig ghConfig) {
        String baseURL;
        String eleProviderStr = Helper.toLowerCase(ghConfig.getString("graph.elevation.provider", "noop"));
        if (ghConfig.has("graph.elevation.calcmean")) {
            throw new IllegalArgumentException("graph.elevation.calcmean is deprecated, use graph.elevation.interpolate");
        }
        boolean interpolate = ghConfig.has("graph.elevation.interpolate") ? "bilinear".equals(ghConfig.getString("graph.elevation.interpolate", "none")) : ghConfig.getBool("graph.elevation.calc_mean", false);
        String cacheDirStr = ghConfig.getString("graph.elevation.cache_dir", "");
        if (cacheDirStr.isEmpty()) {
            cacheDirStr = ghConfig.getString("graph.elevation.cachedir", "");
        }
        if ((baseURL = ghConfig.getString("graph.elevation.base_url", "")).isEmpty()) {
            ghConfig.getString("graph.elevation.baseurl", "");
        }
        boolean removeTempElevationFiles = ghConfig.getBool("graph.elevation.cgiar.clear", true);
        removeTempElevationFiles = ghConfig.getBool("graph.elevation.clear", removeTempElevationFiles);
        DAType elevationDAType = DAType.fromString(ghConfig.getString("graph.elevation.dataaccess", "MMAP"));
        ElevationProvider elevationProvider = ElevationProvider.NOOP;
        if (eleProviderStr.equalsIgnoreCase("srtm")) {
            elevationProvider = new SRTMProvider(cacheDirStr);
        } else if (eleProviderStr.equalsIgnoreCase("cgiar")) {
            elevationProvider = new CGIARProvider(cacheDirStr);
        } else if (eleProviderStr.equalsIgnoreCase("gmted")) {
            elevationProvider = new GMTEDProvider(cacheDirStr);
        } else if (eleProviderStr.equalsIgnoreCase("srtmgl1")) {
            elevationProvider = new SRTMGL1Provider(cacheDirStr);
        } else if (eleProviderStr.equalsIgnoreCase("multi")) {
            elevationProvider = new MultiSourceElevationProvider(cacheDirStr);
        } else if (eleProviderStr.equalsIgnoreCase("skadi")) {
            elevationProvider = new SkadiProvider(cacheDirStr);
        }
        elevationProvider.setAutoRemoveTemporaryFiles(removeTempElevationFiles);
        elevationProvider.setInterpolate(interpolate);
        if (!baseURL.isEmpty()) {
            elevationProvider.setBaseURL(baseURL);
        }
        elevationProvider.setDAType(elevationDAType);
        return elevationProvider;
    }

    private void printInfo() {
        this.logger.info("version " + Constants.VERSION + "|" + Constants.BUILD_DATE + " (" + Constants.getVersions() + ")");
        if (this.ghStorage != null) {
            this.logger.info("graph " + this.ghStorage.toString() + ", details:" + this.ghStorage.toDetailsString());
        }
    }

    public GraphHopper importOrLoad() {
        if (!this.load(this.ghLocation)) {
            this.printInfo();
            this.process(this.ghLocation, false);
        } else {
            this.printInfo();
        }
        return this;
    }

    public void importAndClose() {
        if (!this.load(this.ghLocation)) {
            this.printInfo();
            this.process(this.ghLocation, true);
        } else {
            this.printInfo();
            this.logger.info("Graph already imported into " + this.ghLocation);
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GraphHopper process(String graphHopperLocation, boolean closeEarly) {
        this.setGraphHopperLocation(graphHopperLocation);
        GHLock lock = null;
        try {
            if (this.ghStorage.getDirectory().getDefaultType().isStoring()) {
                this.lockFactory.setLockDir(new File(graphHopperLocation));
                lock = this.lockFactory.create("gh.lock", true);
                if (!lock.tryLock()) {
                    throw new RuntimeException("To avoid multiple writers we need to obtain a write lock but it failed. In " + graphHopperLocation, lock.getObtainFailedReason());
                }
            }
            this.readData();
            this.cleanUp();
            this.postProcessing(closeEarly);
            this.flush();
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
        return this;
    }

    private void readData() {
        try {
            DataReader reader = this.importData();
            DateFormat f = Helper.createFormatter();
            this.ghStorage.getProperties().put("datareader.import.date", f.format(new Date()));
            if (reader.getDataDate() != null) {
                this.ghStorage.getProperties().put("datareader.data.date", f.format(reader.getDataDate()));
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot read file " + this.getDataReaderFile(), ex);
        }
    }

    protected DataReader importData() throws IOException {
        this.ensureWriteAccess();
        if (this.ghStorage == null) {
            throw new IllegalStateException("Load graph before importing OSM data");
        }
        if (this.dataReaderFile == null) {
            throw new IllegalStateException("Couldn't load from existing folder: " + this.ghLocation + " but also cannot use file for DataReader as it wasn't specified!");
        }
        DataReader reader = this.createReader(this.ghStorage);
        this.logger.info("using " + this.ghStorage.toString() + ", memory:" + Helper.getMemInfo());
        reader.readGraph();
        return reader;
    }

    protected DataReader createReader(GraphHopperStorage ghStorage) {
        throw new UnsupportedOperationException("Cannot create DataReader. Solutions: avoid import via calling load directly, provide a DataReader or use e.g. GraphHopperOSM or a different subclass");
    }

    protected DataReader initDataReader(DataReader reader) {
        if (this.dataReaderFile == null) {
            throw new IllegalArgumentException("No file for DataReader specified");
        }
        this.logger.info("start creating graph from " + this.dataReaderFile);
        return reader.setFile(new File(this.dataReaderFile)).setElevationProvider(this.eleProvider).setWorkerThreads(this.dataReaderWorkerThreads).setWayPointMaxDistance(this.dataReaderWayPointMaxDistance).setWayPointElevationMaxDistance(this.routerConfig.getElevationWayPointMaxDistance()).setSmoothElevation(this.smoothElevation).setLongEdgeSamplingDistance(this.longEdgeSamplingDistance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean load(String graphHopperFolder) {
        List<CHConfig> chConfigs;
        if (Helper.isEmpty(graphHopperFolder)) {
            throw new IllegalStateException("GraphHopperLocation is not specified. Call setGraphHopperLocation or init before");
        }
        if (this.fullyLoaded) {
            throw new IllegalStateException("graph is already successfully loaded");
        }
        File tmpFileOrFolder = new File(graphHopperFolder);
        if (!tmpFileOrFolder.isDirectory() && tmpFileOrFolder.exists()) {
            throw new IllegalArgumentException("GraphHopperLocation cannot be an existing file. Has to be either non-existing or a folder.");
        }
        File compressed = new File(graphHopperFolder + ".ghz");
        if (compressed.exists() && !compressed.isDirectory()) {
            try {
                new Unzipper().unzip(compressed.getAbsolutePath(), graphHopperFolder, this.removeZipped);
            }
            catch (IOException ex) {
                throw new RuntimeException("Couldn't extract file " + compressed.getAbsolutePath() + " to " + graphHopperFolder, ex);
            }
        }
        this.setGraphHopperLocation(graphHopperFolder);
        if (this.encodingManager == null) {
            this.setEncodingManager(EncodingManager.create(this.encodedValueFactory, this.flagEncoderFactory, this.ghLocation));
        }
        if (!this.allowWrites && this.dataAccessType.isMMap()) {
            this.dataAccessType = DAType.MMAP_RO;
        }
        GHDirectory dir = new GHDirectory(this.ghLocation, this.dataAccessType);
        this.ghStorage = new GraphHopperStorage(dir, this.encodingManager, this.hasElevation(), this.encodingManager.needsTurnCostsSupport(), this.defaultSegmentSize);
        this.checkProfilesConsistency();
        if (this.lmPreparationHandler.isEnabled()) {
            this.initLMPreparationHandler();
        }
        if (this.chPreparationHandler.isEnabled()) {
            this.initCHPreparationHandler();
            chConfigs = this.chPreparationHandler.getCHConfigs();
        } else {
            chConfigs = Collections.emptyList();
        }
        this.ghStorage.addCHGraphs(chConfigs);
        if (!new File(graphHopperFolder).exists()) {
            return false;
        }
        GHLock lock = null;
        try {
            if (this.ghStorage.getDirectory().getDefaultType().isStoring() && this.isAllowWrites()) {
                this.lockFactory.setLockDir(new File(this.ghLocation));
                lock = this.lockFactory.create("gh.lock", false);
                if (!lock.tryLock()) {
                    throw new RuntimeException("To avoid reading partial data we need to obtain the read lock but it failed. In " + this.ghLocation, lock.getObtainFailedReason());
                }
            }
            if (!this.ghStorage.loadExisting()) {
                boolean bl = false;
                return bl;
            }
            this.postProcessing(false);
            this.setFullyLoaded();
            boolean bl = true;
            return bl;
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
    }

    private void checkProfilesConsistency() {
        for (Profile profile : this.profilesByName.values()) {
            if (!this.encodingManager.hasEncoder(profile.getVehicle())) {
                throw new IllegalArgumentException("Unknown vehicle '" + profile.getVehicle() + "' in profile: " + profile + ". Make sure all vehicles used in 'profiles' exist in 'graph.flag_encoders'");
            }
            FlagEncoder encoder = this.encodingManager.getEncoder(profile.getVehicle());
            if (profile.isTurnCosts() && !encoder.supportsTurnCosts()) {
                throw new IllegalArgumentException("The profile '" + profile.getName() + "' was configured with 'turn_costs=true', but the corresponding vehicle '" + profile.getVehicle() + "' does not support turn costs.\nYou need to add `|turn_costs=true` to the vehicle in `graph.flag_encoders`");
            }
            try {
                this.createWeighting(profile, new PMap());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Could not create weighting for profile: '" + profile.getName() + "'.\nProfile: " + profile + "\nError: " + e.getMessage());
            }
            if (!(profile instanceof CustomProfile)) continue;
            CustomModel customModel = ((CustomProfile)profile).getCustomModel();
            if (customModel == null) {
                throw new IllegalArgumentException("custom model for profile '" + profile.getName() + "' was empty");
            }
            if ("custom".equals(profile.getWeighting())) continue;
            throw new IllegalArgumentException("profile '" + profile.getName() + "' has a custom model but weighting=" + profile.getWeighting() + " was defined");
        }
        LinkedHashSet<String> chConfigSet = new LinkedHashSet<String>(this.chPreparationHandler.getCHProfiles().size());
        for (CHProfile chConfig : this.chPreparationHandler.getCHProfiles()) {
            boolean added = chConfigSet.add(chConfig.getProfile());
            if (!added) {
                throw new IllegalArgumentException("Duplicate CH reference to profile '" + chConfig.getProfile() + "'");
            }
            if (this.profilesByName.containsKey(chConfig.getProfile())) continue;
            throw new IllegalArgumentException("CH profile references unknown profile '" + chConfig.getProfile() + "'");
        }
        LinkedHashMap<String, LMProfile> linkedHashMap = new LinkedHashMap<String, LMProfile>(this.lmPreparationHandler.getLMProfiles().size());
        for (LMProfile lmProfile : this.lmPreparationHandler.getLMProfiles()) {
            LMProfile previous = linkedHashMap.put(lmProfile.getProfile(), lmProfile);
            if (previous != null) {
                throw new IllegalArgumentException("Multiple LM profiles are using the same profile '" + lmProfile.getProfile() + "'");
            }
            if (!this.profilesByName.containsKey(lmProfile.getProfile())) {
                throw new IllegalArgumentException("LM profile references unknown profile '" + lmProfile.getProfile() + "'");
            }
            if (!lmProfile.usesOtherPreparation() || this.profilesByName.containsKey(lmProfile.getPreparationProfile())) continue;
            throw new IllegalArgumentException("LM profile references unknown preparation profile '" + lmProfile.getPreparationProfile() + "'");
        }
        for (LMProfile lmConfig : this.lmPreparationHandler.getLMProfiles()) {
            if (lmConfig.usesOtherPreparation() && !linkedHashMap.containsKey(lmConfig.getPreparationProfile())) {
                throw new IllegalArgumentException("Unknown LM preparation profile '" + lmConfig.getPreparationProfile() + "' in LM profile '" + lmConfig.getProfile() + "' cannot be used as preparation_profile");
            }
            if (!lmConfig.usesOtherPreparation() || !((LMProfile)linkedHashMap.get(lmConfig.getPreparationProfile())).usesOtherPreparation()) continue;
            throw new IllegalArgumentException("Cannot use '" + lmConfig.getPreparationProfile() + "' as preparation_profile for LM profile '" + lmConfig.getProfile() + "', because it uses another profile for preparation itself.");
        }
    }

    public final CHPreparationHandler getCHPreparationHandler() {
        return this.chPreparationHandler;
    }

    private void initCHPreparationHandler() {
        if (this.chPreparationHandler.hasCHConfigs()) {
            return;
        }
        for (CHProfile chConfig : this.chPreparationHandler.getCHProfiles()) {
            Profile profile = this.profilesByName.get(chConfig.getProfile());
            if (profile.isTurnCosts()) {
                this.chPreparationHandler.addCHConfig(CHConfig.edgeBased(profile.getName(), this.createWeighting(profile, new PMap())));
                continue;
            }
            this.chPreparationHandler.addCHConfig(CHConfig.nodeBased(profile.getName(), this.createWeighting(profile, new PMap())));
        }
    }

    public final LMPreparationHandler getLMPreparationHandler() {
        return this.lmPreparationHandler;
    }

    private void initLMPreparationHandler() {
        if (this.lmPreparationHandler.hasLMProfiles()) {
            return;
        }
        for (LMProfile lmProfile : this.lmPreparationHandler.getLMProfiles()) {
            if (lmProfile.usesOtherPreparation()) continue;
            Profile profile = this.profilesByName.get(lmProfile.getProfile());
            Weighting weighting = this.createWeighting(profile, new PMap(), true);
            this.lmPreparationHandler.addLMConfig(new LMConfig(profile.getName(), weighting));
        }
    }

    public final void postProcessing() {
        this.postProcessing(false);
    }

    protected void postProcessing(boolean closeEarly) {
        if (this.sortGraph) {
            if (this.ghStorage.isCHPossible() && this.isCHPrepared()) {
                throw new IllegalArgumentException("Sorting a prepared CHGraph is not possible yet. See #12");
            }
            GraphHopperStorage newGraph = GHUtility.newStorage(this.ghStorage);
            GHUtility.sortDFS(this.ghStorage, newGraph);
            this.logger.info("graph sorted (" + Helper.getMemInfo() + ")");
            this.ghStorage = newGraph;
        }
        if (!this.hasInterpolated() && this.hasElevation()) {
            this.interpolateBridgesTunnelsAndFerries();
        }
        this.initLocationIndex();
        this.importPublicTransit();
        if (this.lmPreparationHandler.isEnabled()) {
            this.lmPreparationHandler.createPreparations(this.ghStorage, this.locationIndex);
        }
        this.loadOrPrepareLM(closeEarly);
        if (this.chPreparationHandler.isEnabled()) {
            this.chPreparationHandler.createPreparations(this.ghStorage);
        }
        if (this.isCHPrepared()) {
            for (CHProfile profile : this.chPreparationHandler.getCHProfiles()) {
                if (this.getProfileVersion(profile.getProfile()).equals("" + this.profilesByName.get(profile.getProfile()).getVersion())) continue;
                throw new IllegalArgumentException("CH preparation of " + profile.getProfile() + " already exists in storage and doesn't match configuration");
            }
        } else {
            this.prepareCH(closeEarly);
        }
    }

    protected void registerCustomEncodedValues(EncodingManager.Builder emBuilder) {
    }

    protected void importPublicTransit() {
    }

    private boolean hasInterpolated() {
        return "true".equals(this.ghStorage.getProperties().get(INTERPOLATION_KEY));
    }

    void interpolateBridgesTunnelsAndFerries() {
        if (this.ghStorage.getEncodingManager().hasEncodedValue("road_environment")) {
            EnumEncodedValue<RoadEnvironment> roadEnvEnc = this.ghStorage.getEncodingManager().getEnumEncodedValue("road_environment", RoadEnvironment.class);
            StopWatch sw = new StopWatch().start();
            new EdgeElevationInterpolator(this.ghStorage, roadEnvEnc, RoadEnvironment.TUNNEL).execute();
            float tunnel = sw.stop().getSeconds();
            sw = new StopWatch().start();
            new EdgeElevationInterpolator(this.ghStorage, roadEnvEnc, RoadEnvironment.BRIDGE).execute();
            float bridge = sw.stop().getSeconds();
            sw = new StopWatch().start();
            new EdgeElevationInterpolator(this.ghStorage, roadEnvEnc, RoadEnvironment.FERRY).execute();
            this.ghStorage.getProperties().put(INTERPOLATION_KEY, true);
            this.logger.info("Bridge interpolation " + (int)bridge + "s, tunnel interpolation " + (int)tunnel + "s, ferry interpolation " + (int)sw.stop().getSeconds());
        }
    }

    public final Weighting createWeighting(Profile profile, PMap hints) {
        return this.createWeighting(profile, hints, false);
    }

    public final Weighting createWeighting(Profile profile, PMap hints, boolean disableTurnCosts) {
        return this.createWeightingFactory().createWeighting(profile, hints, disableTurnCosts);
    }

    protected WeightingFactory createWeightingFactory() {
        return new DefaultWeightingFactory(this.ghStorage, this.encodingManager);
    }

    @Override
    public GHResponse route(GHRequest request) {
        return this.createRouter().route(request);
    }

    private Router createRouter() {
        if (this.ghStorage == null || !this.fullyLoaded) {
            throw new IllegalStateException("Do a successful call to load or importOrLoad before routing");
        }
        if (this.ghStorage.isClosed()) {
            throw new IllegalStateException("You need to create a new GraphHopper instance as it is already closed");
        }
        if (this.locationIndex == null) {
            throw new IllegalStateException("Location index not initialized");
        }
        LinkedHashMap<String, CHGraph> chGraphs = new LinkedHashMap<String, CHGraph>();
        for (CHProfile chProfile : this.chPreparationHandler.getCHProfiles()) {
            String chGraphName = this.chPreparationHandler.getPreparation(chProfile.getProfile()).getCHConfig().getName();
            chGraphs.put(chProfile.getProfile(), this.ghStorage.getCHGraph(chGraphName));
        }
        LinkedHashMap<String, LandmarkStorage> landmarks = new LinkedHashMap<String, LandmarkStorage>();
        for (LMProfile lmp : this.lmPreparationHandler.getLMProfiles()) {
            landmarks.put(lmp.getProfile(), lmp.usesOtherPreparation() ? this.lmPreparationHandler.getPreparation(lmp.getPreparationProfile()).getLandmarkStorage() : this.lmPreparationHandler.getPreparation(lmp.getProfile()).getLandmarkStorage());
        }
        return new Router(this.ghStorage, this.locationIndex, this.profilesByName, this.pathBuilderFactory, this.trMap, this.routerConfig, this.createWeightingFactory(), chGraphs, landmarks);
    }

    protected LocationIndex createLocationIndex(Directory dir) {
        LocationIndexTree tmpIndex = new LocationIndexTree(this.ghStorage, dir);
        tmpIndex.setResolution(this.preciseIndexResolution);
        tmpIndex.setMaxRegionSearch(this.maxRegionSearch);
        if (!tmpIndex.loadExisting()) {
            this.ensureWriteAccess();
            tmpIndex.prepareIndex();
        }
        return tmpIndex;
    }

    protected void initLocationIndex() {
        if (this.locationIndex != null) {
            throw new IllegalStateException("Cannot initialize locationIndex twice!");
        }
        this.locationIndex = this.createLocationIndex(this.ghStorage.getDirectory());
    }

    private boolean isCHPrepared() {
        return "true".equals(this.ghStorage.getProperties().get("prepare.ch.done"));
    }

    private String getProfileVersion(String profile) {
        return this.ghStorage.getProperties().get("graph.profiles." + profile + ".version");
    }

    private void setProfileVersion(String profile, int version) {
        this.ghStorage.getProperties().put("graph.profiles." + profile + ".version", version);
    }

    protected void prepareCH(boolean closeEarly) {
        for (CHProfile profile : this.chPreparationHandler.getCHProfiles()) {
            if (this.getProfileVersion(profile.getProfile()).isEmpty() || this.getProfileVersion(profile.getProfile()).equals("" + this.profilesByName.get(profile.getProfile()).getVersion())) continue;
            throw new IllegalArgumentException("CH preparation of " + profile.getProfile() + " already exists in storage and doesn't match configuration");
        }
        boolean tmpPrepare = this.chPreparationHandler.isEnabled();
        if (tmpPrepare) {
            this.ensureWriteAccess();
            if (closeEarly) {
                this.locationIndex.flush();
                this.locationIndex.close();
                this.ghStorage.flushAndCloseEarly();
            }
            this.ghStorage.freeze();
            this.chPreparationHandler.prepare(this.ghStorage.getProperties(), closeEarly);
            this.ghStorage.getProperties().put("prepare.ch.done", true);
            for (CHProfile profile : this.chPreparationHandler.getCHProfiles()) {
                this.setProfileVersion(profile.getProfile(), this.profilesByName.get(profile.getProfile()).getVersion());
            }
        }
    }

    protected void loadOrPrepareLM(boolean closeEarly) {
        boolean tmpPrepare;
        boolean bl = tmpPrepare = this.lmPreparationHandler.isEnabled() && !this.lmPreparationHandler.getPreparations().isEmpty();
        if (tmpPrepare) {
            for (LMProfile profile : this.lmPreparationHandler.getLMProfiles()) {
                if (this.getProfileVersion(profile.getProfile()).isEmpty() || this.getProfileVersion(profile.getProfile()).equals("" + this.profilesByName.get(profile.getProfile()).getVersion())) continue;
                throw new IllegalArgumentException("LM preparation of " + profile.getProfile() + " already exists in storage and doesn't match configuration");
            }
            this.ensureWriteAccess();
            this.ghStorage.freeze();
            if (this.lmPreparationHandler.loadOrDoWork(this.ghStorage.getProperties(), closeEarly)) {
                this.ghStorage.getProperties().put("prepare.lm.done", true);
                for (LMProfile profile : this.lmPreparationHandler.getLMProfiles()) {
                    this.setProfileVersion(profile.getProfile(), this.profilesByName.get(profile.getProfile()).getVersion());
                }
            }
        }
    }

    protected void cleanUp() {
        PrepareRoutingSubnetworks preparation = new PrepareRoutingSubnetworks(this.ghStorage, this.buildSubnetworkRemovalJobs());
        preparation.setMinNetworkSize(this.minNetworkSize);
        preparation.doWork();
        this.logger.info("nodes: " + Helper.nf(this.ghStorage.getNodes()) + ", edges: " + Helper.nf(this.ghStorage.getEdges()));
    }

    private List<PrepareRoutingSubnetworks.PrepareJob> buildSubnetworkRemovalJobs() {
        List<FlagEncoder> encoders = this.encodingManager.fetchEdgeEncoders();
        ArrayList<PrepareRoutingSubnetworks.PrepareJob> jobs = new ArrayList<PrepareRoutingSubnetworks.PrepareJob>();
        for (FlagEncoder encoder : encoders) {
            if (encoder.supportsTurnCosts()) {
                DefaultTurnCostProvider turnCostProvider = new DefaultTurnCostProvider(encoder, this.ghStorage.getTurnCostStorage(), 0);
                jobs.add(new PrepareRoutingSubnetworks.PrepareJob(encoder.toString(), encoder.getAccessEnc(), turnCostProvider));
                continue;
            }
            jobs.add(new PrepareRoutingSubnetworks.PrepareJob(encoder.toString(), encoder.getAccessEnc(), null));
        }
        return jobs;
    }

    protected void flush() {
        this.logger.info("flushing graph " + this.ghStorage.toString() + ", details:" + this.ghStorage.toDetailsString() + ", " + Helper.getMemInfo() + ")");
        this.ghStorage.flush();
        this.logger.info("flushed graph " + Helper.getMemInfo() + ")");
        this.setFullyLoaded();
    }

    public void close() {
        if (this.ghStorage != null) {
            this.ghStorage.close();
        }
        if (this.locationIndex != null) {
            this.locationIndex.close();
        }
        try {
            this.lockFactory.forceRemove("gh.lock", true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clean() {
        if (this.getGraphHopperLocation().isEmpty()) {
            throw new IllegalStateException("Cannot clean GraphHopper without specified graphHopperLocation");
        }
        File folder = new File(this.getGraphHopperLocation());
        Helper.removeDir(folder);
    }

    protected void ensureNotLoaded() {
        if (this.fullyLoaded) {
            throw new IllegalStateException("No configuration changes are possible after loading the graph");
        }
    }

    protected void ensureWriteAccess() {
        if (!this.allowWrites) {
            throw new IllegalStateException("Writes are not allowed!");
        }
    }

    private void setFullyLoaded() {
        this.fullyLoaded = true;
    }

    public RouterConfig getRouterConfig() {
        return this.routerConfig;
    }
}

