/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.navigation;

import com.graphhopper.navigation.ConditionalDistanceVoiceInstructionConfig;
import com.graphhopper.navigation.DistanceUtils;
import com.graphhopper.navigation.FixedDistanceVoiceInstructionConfig;
import com.graphhopper.navigation.InitialVoiceInstructionConfig;
import com.graphhopper.navigation.VoiceInstructionConfig;
import com.graphhopper.util.TranslationMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class DistanceConfig {
    final List<VoiceInstructionConfig> voiceInstructions;

    public DistanceConfig(DistanceUtils.Unit unit, TranslationMap translationMap, Locale locale) {
        this.voiceInstructions = unit == DistanceUtils.Unit.METRIC ? Arrays.asList(new InitialVoiceInstructionConfig(DistanceUtils.UnitTranslationKey.FOR_HIGHER_DISTANCE_PLURAL.metric, translationMap, locale, 4250, 250, unit), new FixedDistanceVoiceInstructionConfig(DistanceUtils.UnitTranslationKey.IN_HIGHER_DISTANCE_PLURAL.metric, translationMap, locale, 2000, 2), new FixedDistanceVoiceInstructionConfig(DistanceUtils.UnitTranslationKey.IN_HIGHER_DISTANCE_SINGULAR.metric, translationMap, locale, 1000, 1), new ConditionalDistanceVoiceInstructionConfig(DistanceUtils.UnitTranslationKey.IN_LOWER_DISTANCE_PLURAL.metric, translationMap, locale, new int[]{400, 200}, new int[]{400, 200})) : Arrays.asList(new InitialVoiceInstructionConfig(DistanceUtils.UnitTranslationKey.FOR_HIGHER_DISTANCE_PLURAL.metric, translationMap, locale, 4250, 250, unit), new FixedDistanceVoiceInstructionConfig(DistanceUtils.UnitTranslationKey.IN_HIGHER_DISTANCE_PLURAL.imperial, translationMap, locale, 3220, 2), new FixedDistanceVoiceInstructionConfig(DistanceUtils.UnitTranslationKey.IN_HIGHER_DISTANCE_SINGULAR.imperial, translationMap, locale, 1610, 1), new ConditionalDistanceVoiceInstructionConfig(DistanceUtils.UnitTranslationKey.IN_LOWER_DISTANCE_PLURAL.imperial, translationMap, locale, new int[]{400, 200}, new int[]{1300, 600}));
    }

    public List<VoiceInstructionConfig.VoiceInstructionValue> getVoiceInstructionsForDistance(double distance, String turnDescription, String thenVoiceInstruction) {
        ArrayList<VoiceInstructionConfig.VoiceInstructionValue> instructionsConfigs = new ArrayList<VoiceInstructionConfig.VoiceInstructionValue>(this.voiceInstructions.size());
        for (VoiceInstructionConfig voiceConfig : this.voiceInstructions) {
            VoiceInstructionConfig.VoiceInstructionValue confi = voiceConfig.getConfigForDistance(distance, turnDescription, thenVoiceInstruction);
            if (confi == null) continue;
            instructionsConfigs.add(confi);
        }
        return instructionsConfigs;
    }
}

